/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.ca.ISignOperateCallback;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.helper.MultiLangEnumBridge;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.SourceRowReport;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.ClientCallback;
import kd.bos.form.ClientMethodResult;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.SignCallbackEvent;
import kd.bos.form.SignCallbackLisenter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.mcontrol.mobtable.IMobTablePackageDataHandler;
import kd.bos.form.mcontrol.mobtable.MobTable;
import kd.bos.form.mcontrol.mobtable.events.IBeforeCreateMobTableColumnsListener;
import kd.bos.form.mcontrol.mobtable.events.IMobTablePackageDataHandlerListener;
import kd.bos.form.mcontrol.mobtable.events.MobTablePackageDataHandlerEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.botp.MobTablePackageDataHandler;
import kd.bos.mutex.AutoReleaseLock;
import kd.bos.mutex.DataMutex;
import kd.bos.service.botp.facade.ConvertResultFormEditFacade;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.log4j.Logger;

public class MobConvertResultFormEdit
extends AbstractFormPlugin
implements IBeforeCreateMobTableColumnsListener,
SignCallbackLisenter,
ICloseCallBack {
    private static final long serialVersionUID = -96803951999592586L;
    private static Logger log = Logger.getLogger(MobConvertResultFormEdit.class);
    private static final String CACHEKEY_BILLCOUNT = "billcount";
    private static final String CACHEKEY_SAVECOUNT = "savecount";
    private static final String CACHEKEY_MUTEX = "mutxt";
    private static final String KEY_BILLLISTENTRY = "billlist";
    private static final String KEY_TBSAVEALL = "tbsaveall";
    private static final String BOS_BOTP_FORMPLUGIN = "bos-botp-formplugin";
    private static final String KEY_LBLSAVESTATUS = "lblsavestatus";
    private static final String MUTEX_OPERATIONKEY = "modify";
    private String mutex_NetCtrlGroupId = null;
    private ConvertResultFormEditFacade convertFormEditFacade = ConvertResultFormEditFacade.getInstance();
    private static final String KEY_FALSE = "false";
    private static final String MUTEX_REQUIRE_ERROR = "MUTEX_REQUIRE_ERROR";

    public void createNewData(BizDataEventArgs e) {
        MobTable mobTable = (MobTable)this.getControl(KEY_BILLLISTENTRY);
        mobTable.addBeforeCreateMobTableColumnsListener((IBeforeCreateMobTableColumnsListener)this);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
        String convertResultJson = pageCache.get("ConvertOperationResult");
        final ConvertOperationResult convertResult = (ConvertOperationResult)SerializationUtils.fromJsonString((String)convertResultJson, ConvertOperationResult.class);
        mobTable.addMobTablePackageDataHandlerListener(new IMobTablePackageDataHandlerListener(){

            public void createMobTablePackageDataHandler(MobTablePackageDataHandlerEvent mobTablePackageDataHandlerEvent) {
                mobTablePackageDataHandlerEvent.setMobTablePackageDataHandler((IMobTablePackageDataHandler)new MobTablePackageDataHandler(convertResult, MobConvertResultFormEdit.this.getTargetMainType(), SaveStatus.UN_SAVE.getName(), MobConvertResultFormEdit.this.getPageCache(), MobConvertResultFormEdit.this.loadBillNoFromDB(convertResult.getTargetEntityNumber(), convertResult.getTargetBillIds().toArray())));
            }
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_TBSAVEALL});
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put(CACHEKEY_BILLCOUNT, "0");
        if (this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()) == null) {
            return;
        }
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
        String convertResultJson = pageCache.get("ConvertOperationResult");
        ConvertOperationResult convertResult = (ConvertOperationResult)SerializationUtils.fromJsonString((String)convertResultJson, ConvertOperationResult.class);
        this.updateConvertResult(convertResult);
        this.refreshSaveTips();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.refreshSaveTips();
        this.showReport();
    }

    public void pageRelease(EventObject e) {
        this.releaseMutex();
        this.releasePushaMutex();
        ConvertOperationResult convertResult = this.getConvertResult();
        if (convertResult == null) {
            return;
        }
        MainEntityType mainType = this.getTargetMainType();
        convertResult.release(this.buildRefLoader(), mainType);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control srcControl = (Control)evt.getSource();
        if (KEY_TBSAVEALL.equalsIgnoreCase(srcControl.getKey())) {
            this.saveAll();
        }
    }

    private void showReport() {
        boolean showReport = false;
        String parmValue = (String)this.getView().getFormShowParameter().getCustomParam("showreport");
        if (StringUtils.isNotBlank((CharSequence)parmValue)) {
            showReport = Boolean.parseBoolean(parmValue);
        }
        if (!showReport) {
            return;
        }
        ConvertOperationResult convertResult = this.getConvertResult();
        String failMessage = convertResult.getMessage();
        if (convertResult.getBillReports().isEmpty()) {
            return;
        }
        SourceBillReport billReport = (SourceBillReport)convertResult.getBillReports().get(0);
        if (!billReport.getFailMessages().isEmpty()) {
            failMessage = (String)billReport.getFailMessages().get(0);
        } else if (!billReport.getLinkEntityRowReports().isEmpty()) {
            failMessage = ((SourceRowReport)billReport.getLinkEntityRowReports().get(0)).getFailMessage();
        }
        if (StringUtils.isNotBlank((CharSequence)failMessage)) {
            this.getView().showErrorNotification(failMessage);
        }
    }

    private void saveAll() {
        ConvertOperationResult convertResult = this.getConvertResult();
        if (convertResult == null) {
            return;
        }
        HashMap<SaveStatus, List<DynamicObject>> billObjs = new HashMap<SaveStatus, List<DynamicObject>>(16);
        this.getOpBillObjs(convertResult, billObjs);
        List<DynamicObject> beforeSaveObjs = this.getSaveObjs(billObjs, convertResult.getCachePageIds().size());
        int saveCount = Integer.parseInt(this.getPageCache().get(CACHEKEY_SAVECOUNT) == null ? "0" : this.getPageCache().get(CACHEKEY_SAVECOUNT));
        if (saveCount == convertResult.getCachePageIds().size() + convertResult.getTargetBillIds().size()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ecf\u5168\u90e8\u4fdd\u5b58\u6210\u529f\u3002", (String)"ConvertResultFormEdit_20", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        OperationResult mergeResult = this.batchSaveAll(beforeSaveObjs.toArray(new DynamicObject[0]));
        if (mergeResult != null && mergeResult.getSuccessPkIds() != null && !mergeResult.getSuccessPkIds().isEmpty()) {
            this.doAfterOperation(mergeResult, SaveStatus.SAVED, convertResult);
        }
    }

    private OperationResult batchSaveAll(DynamicObject[] billObjs) {
        BillEntityType mainType = (BillEntityType)this.getTargetMainType();
        String targetEntityNumber = mainType.getName();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isStrict", KEY_FALSE);
        operateOption.setVariableValue("ignorewarn", String.valueOf(true));
        operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        operateOption.setVariableValue("botptag_of_datasource", String.valueOf(true));
        log.info((Object)("botp\u7ed3\u679c\u4e0b\u6279\u91cf\u64cd\u4f5c\u53c2\u6570\uff1a" + operateOption));
        this.convertFormEditFacade.beforeDoOperation(this.getPageCache(), operateOption);
        OperationResult opResult = null;
        if (billObjs != null) {
            opResult = OperationServiceHelper.executeOperate((String)"save", (String)targetEntityNumber, (DynamicObject[])billObjs, (OperateOption)operateOption);
        }
        if (opResult != null && !opResult.isSuccess() && opResult.isNeedSign()) {
            ISignOperateCallback signOperateCallback = (ISignOperateCallback)TypesContainer.createInstance((String)"kd.bos.form.operate.SignOperateCallback");
            opResult = signOperateCallback.beforeSign(this.getView(), (SignCallbackLisenter)this, operateOption, ClientCallback.SignClientType.Secondry, SaveStatus.SAVED.toString()).sign(opResult);
            if (!opResult.isSuccess()) {
                this.getView().showOperationResult(opResult, "save");
            }
            return null;
        }
        if (opResult != null && !opResult.isSuccess()) {
            this.getView().showErrorNotification(opResult.getMessage());
            return null;
        }
        return opResult;
    }

    private List<DynamicObject> getSaveObjs(Map<SaveStatus, List<DynamicObject>> billObjs, int count) {
        ArrayList<DynamicObject> beforeSaveObjs = new ArrayList<DynamicObject>(count);
        for (Map.Entry<SaveStatus, List<DynamicObject>> entry : billObjs.entrySet()) {
            if (entry.getKey() != SaveStatus.UN_SAVE && entry.getKey() != SaveStatus.SAVED) continue;
            beforeSaveObjs.addAll((Collection<DynamicObject>)entry.getValue());
        }
        return beforeSaveObjs;
    }

    private void refreshSaveTips() {
        int billCount = this.getPageCache().get(CACHEKEY_BILLCOUNT) == null ? 0 : Integer.parseInt(this.getPageCache().get(CACHEKEY_BILLCOUNT));
        int saveCount = this.getPageCache().get(CACHEKEY_SAVECOUNT) == null ? 0 : Integer.parseInt(this.getPageCache().get(CACHEKEY_SAVECOUNT));
        String tipSaveStatus = "";
        if (saveCount <= 0) {
            tipSaveStatus = String.format(ResManager.loadKDString((String)"\u5171\u751f\u6210\u4e86%d\u5f20\u5355\u636e\uff0c\u5747\u672a\u4fdd\u5b58", (String)"ConvertResultFormEdit_3", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]), billCount);
        } else if (saveCount >= billCount) {
            tipSaveStatus = String.format(ResManager.loadKDString((String)"\u5171\u751f\u6210\u4e86%d\u5f20\u5355\u636e\uff0c\u5747\u5df2\u4fdd\u5b58", (String)"ConvertResultFormEdit_4", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]), billCount);
        }
        Label lblSaveStatus = (Label)this.getView().getControl(KEY_LBLSAVESTATUS);
        lblSaveStatus.setText(tipSaveStatus);
    }

    private void getOpBillObjs(ConvertOperationResult convertResult, Map<SaveStatus, List<DynamicObject>> billObjs) {
        MainEntityType mainType = this.getTargetMainType();
        ISimpleProperty pkProp = mainType.getPrimaryKey();
        IRefrencedataProvider refLoader = this.buildRefLoader();
        this.getModel().getDataEntity(true);
        for (String cachePageId : convertResult.getCachePageIds()) {
            SaveStatus status = SaveStatus.valueOf(0);
            if (!StringUtils.isNotBlank((CharSequence)cachePageId)) continue;
            DynamicObject billObj = convertResult.loadTargetDataObject(refLoader, mainType, cachePageId);
            if (!billObjs.containsKey((Object)status)) {
                billObjs.put(status, new ArrayList(convertResult.getCachePageIds().size()));
            }
            billObjs.get((Object)status).add(billObj);
            Object pkValue = billObj.getPkValue();
            if (!((IValidatorHanlder)pkProp).getValueComparator().compareValue(pkValue)) continue;
            pkValue = DBServiceHelper.genGlobalLongId();
            pkProp.setValue((Object)billObj, pkValue);
        }
    }

    private void doAfterOperation(OperationResult opResult, SaveStatus newStatus, final ConvertOperationResult convertResult) {
        DynamicObject[] fromDBObjs;
        MobTable mobTable = (MobTable)this.getView().getControl(KEY_BILLLISTENTRY);
        mobTable.addMobTablePackageDataHandlerListener(new IMobTablePackageDataHandlerListener(){

            public void createMobTablePackageDataHandler(MobTablePackageDataHandlerEvent mobTablePackageDataHandlerEvent) {
                mobTablePackageDataHandlerEvent.setMobTablePackageDataHandler((IMobTablePackageDataHandler)new MobTablePackageDataHandler(convertResult, MobConvertResultFormEdit.this.getTargetMainType(), SaveStatus.SAVED.getName(), MobConvertResultFormEdit.this.getPageCache(), MobConvertResultFormEdit.this.loadBillNoFromDB(convertResult.getTargetEntityNumber(), convertResult.getTargetBillIds().toArray())));
            }
        });
        BillEntityType mainType = (BillEntityType)this.getTargetMainType();
        HashMap<Long, DynamicObject> successObjs = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject obj : fromDBObjs = BusinessDataServiceHelper.load((Object[])opResult.getSuccessPkIds().toArray(), (DynamicObjectType)mainType)) {
            successObjs.put((Long)obj.getPkValue(), obj);
        }
        int saveCount = 0;
        for (String cachePageId : convertResult.getCachePageIds()) {
            Long billId = (Long)opResult.getSuccessPkIds().toArray()[saveCount];
            DynamicObject successObj = (DynamicObject)successObjs.get(billId);
            if (StringUtils.isNotBlank((CharSequence)cachePageId)) {
                convertResult.updateTargetDataObject(cachePageId, successObj);
            }
            ++saveCount;
        }
        this.getPageCache().put(CACHEKEY_SAVECOUNT, String.valueOf(saveCount));
        this.refreshSaveTips();
        this.updateConvertResult(convertResult);
        this.requestMutex(opResult.getSuccessPkIds().toArray());
        this.getView().updateView(KEY_BILLLISTENTRY);
        this.getModel().updateCache();
    }

    protected void requestMutex(Object[] pkValues) {
        if (MutexHelper.isOpenIntentLocks()) {
            return;
        }
        String netGroupId = this.loadMutexGroupId();
        if (StringUtils.isBlank((CharSequence)netGroupId)) {
            return;
        }
        String entityId = this.getTargetEntityNumber();
        boolean isStrict = false;
        ArrayList mutexRequireList = new ArrayList(10);
        for (Object pkValue : pkValues) {
            String objId = String.valueOf(pkValue);
            HashMap<String, Object> requireParam = new HashMap<String, Object>(16);
            requireParam.put("dataObjId", objId);
            requireParam.put("groupId", netGroupId);
            requireParam.put("entityKey", entityId);
            requireParam.put("operationKey", MUTEX_OPERATIONKEY);
            requireParam.put("isStrict", isStrict);
            mutexRequireList.add(requireParam);
        }
        HashSet<String> failObjIds = new HashSet<String>();
        HashSet<String> successObjIds = new HashSet<String>();
        try {
            Object pkValue;
            DataMutex dataMutex = DataMutex.create();
            pkValue = null;
            try {
                Map mutexResult = dataMutex.batchrequire(mutexRequireList);
                for (Map.Entry mutexItem : mutexResult.entrySet()) {
                    String objId = (String)mutexItem.getKey();
                    Boolean isMutexLocked = (Boolean)mutexItem.getValue();
                    if (!isMutexLocked.booleanValue()) {
                        failObjIds.add(objId);
                        continue;
                    }
                    AutoReleaseLock.create().register(objId, entityId, MUTEX_OPERATIONKEY);
                    successObjIds.add(objId);
                }
            }
            catch (Throwable throwable) {
                pkValue = throwable;
                throw throwable;
            }
            finally {
                if (dataMutex != null) {
                    if (pkValue != null) {
                        try {
                            dataMutex.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)pkValue).addSuppressed(throwable);
                        }
                    } else {
                        dataMutex.close();
                    }
                }
            }
        }
        catch (IOException e) {
            ErrorCode ec = new ErrorCode(MUTEX_REQUIRE_ERROR, String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:%s", (String)"ConvertResultFormEdit_12", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]), e.getMessage()));
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
        this.cacheMutexPKValue(successObjIds.toArray(new String[0]));
        if (!failObjIds.isEmpty()) {
            ErrorCode ec = new ErrorCode(MUTEX_REQUIRE_ERROR, ResManager.loadKDString((String)"\u7528\u6237\u81ea\u5df1\u521a\u4e0b\u63a8\u7684\u5355\u636e\u9a6c\u4e0a\u88ab\u5176\u4ed6\u4eba\u9501\u5b9a\uff0c\u4e0d\u53ef\u601d\u8bae", (String)"ConvertResultFormEdit_11", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
    }

    private void cacheMutexPKValue(String[] pkValues) {
        String mutexString = this.getPageCache().get(CACHEKEY_MUTEX);
        List cachePKValues = StringUtils.isBlank((CharSequence)mutexString) ? new ArrayList() : (List)SerializationUtils.fromJsonString((String)mutexString, List.class);
        HashSet<String> set = new HashSet<String>(cachePKValues);
        for (String pkValue : pkValues) {
            if (!set.add(pkValue)) continue;
            cachePKValues.add(pkValue);
        }
        this.getPageCache().put(CACHEKEY_MUTEX, SerializationUtils.toJsonString(cachePKValues));
    }

    private void releaseMutex() {
        String entityNumber = this.getTargetEntityNumber();
        String netGroupId = this.loadMutexGroupId();
        String mutexString = this.getPageCache().get(CACHEKEY_MUTEX);
        List cachePKValues = StringUtils.isBlank((CharSequence)mutexString) ? new ArrayList() : (List)SerializationUtils.fromJsonString((String)mutexString, List.class);
        if (cachePKValues.isEmpty()) {
            return;
        }
        ArrayList mutexRequireList = new ArrayList(10);
        for (Object pkValue : cachePKValues) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>(16);
            requireParam.put("dataObjId", pkValue);
            requireParam.put("groupId", netGroupId);
            requireParam.put("entityKey", entityNumber);
            requireParam.put("operationKey", MUTEX_OPERATIONKEY);
            mutexRequireList.add(requireParam);
        }
        try {
            Object pkValue;
            DataMutex dataMutex = DataMutex.create();
            pkValue = null;
            try {
                Map releaseResult = dataMutex.batchRelease(mutexRequireList);
                for (Map.Entry releaseItem : releaseResult.entrySet()) {
                    boolean releaseRet = (Boolean)releaseItem.getValue();
                    String pkValue2 = (String)releaseItem.getKey();
                    if (releaseRet) {
                        AutoReleaseLock.create().unRegister(pkValue2, entityNumber, MUTEX_OPERATIONKEY);
                        continue;
                    }
                    log.error((Object)("\u91ca\u653e\u6570\u636e\u5bf9\u8c61[" + pkValue2 + "]\u4e92\u65a5\u9501\u5931\u8d25."));
                }
            }
            catch (Throwable throwable) {
                pkValue = throwable;
                throw throwable;
            }
            finally {
                if (dataMutex != null) {
                    if (pkValue != null) {
                        try {
                            dataMutex.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)pkValue).addSuppressed(throwable);
                        }
                    } else {
                        dataMutex.close();
                    }
                }
            }
        }
        catch (IOException e) {
            ErrorCode ec = new ErrorCode(MUTEX_REQUIRE_ERROR, String.format(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519\u3002%s", (String)"ConvertResultFormEdit_13", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]), e.getMessage()));
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
    }

    private String loadMutexGroupId() {
        if (this.mutex_NetCtrlGroupId != null) {
            return this.mutex_NetCtrlGroupId;
        }
        String entityNumber = this.getTargetEntityNumber();
        Map netCtrlConf = EntityMetadataCache.getDataEntityNetCtrlOperate((String)entityNumber);
        if (netCtrlConf == null) {
            return "";
        }
        block0: for (Map.Entry groupId : netCtrlConf.entrySet()) {
            for (Map oper : (List)groupId.getValue()) {
                String operKey = (String)oper.get("operationKey");
                if (!StringUtils.equals((CharSequence)MUTEX_OPERATIONKEY, (CharSequence)operKey)) continue;
                this.mutex_NetCtrlGroupId = (String)groupId.getKey();
                continue block0;
            }
        }
        if (this.mutex_NetCtrlGroupId == null) {
            return "";
        }
        return this.mutex_NetCtrlGroupId;
    }

    private void releasePushaMutex() {
        ConvertOperationResult convertResult = this.getConvertResult();
        if (convertResult == null) {
            return;
        }
        if (convertResult.getDataMutexSrcBillIds().isEmpty()) {
            return;
        }
        HashSet srcBillIds = new HashSet(convertResult.getDataMutexSrcBillIds());
        ConvertServiceHelper.releasePushMutex((String)convertResult.getSourceEntityNumber(), srcBillIds);
        convertResult.getDataMutexSrcBillIds().clear();
    }

    private String getTargetEntityNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam("targetentitynumber");
    }

    private MainEntityType getTargetMainType() {
        String entityNUmber = this.getTargetEntityNumber();
        return EntityMetadataCache.getDataEntityType((String)entityNUmber);
    }

    private ConvertOperationResult getConvertResult() {
        String convertResultJson = this.getPageCache().get("ConvertOperationResult");
        if (StringUtils.isBlank((CharSequence)convertResultJson)) {
            log.warn((Object)ResManager.loadKDString((String)"botp \u4e0b\u63a8\u7ed3\u679c\u5df2\u6e05\u9664", (String)"ConvertResultFormEdit_29", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
            throw new KDBizException(ResManager.loadKDString((String)"botp \u4e0b\u63a8\u7ed3\u679c\u5df2\u6e05\u9664", (String)"ConvertResultFormEdit_29", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
        }
        return (ConvertOperationResult)SerializationUtils.fromJsonString((String)convertResultJson, ConvertOperationResult.class);
    }

    private void updateConvertResult(ConvertOperationResult convertResult) {
        this.getPageCache().put("ConvertOperationResult", SerializationUtils.toJsonString((Object)convertResult));
    }

    private IRefrencedataProvider buildRefLoader() {
        return new IRefrencedataProvider(){

            public void fillReferenceData(Object[] objs, IDataEntityType dType) {
                BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dType);
            }
        };
    }

    public void signCallback(SignCallbackEvent evt) {
        if (evt == null) {
            log.warn((Object)"botp \u4e0b\u63a8\u7b7e\u540d\u56de\u8c03\u7ed3\u679c\u4e3a\u7a7a\u3002\u3002\u3002");
            return;
        }
        log.warn((Object)"botp \u4e0b\u63a8\u7ed3\u679c\u6279\u91cf\u63d0\u4ea4\u7b7e\u540d\u6210\u529f\u56de\u8c03\u3002\u3002\u3002");
        ClientMethodResult ret = evt.getResult();
        if (!ret.getSuccess().booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5ba2\u6237\u7aef\u7b7e\u540d\u5931\u8d25\u3002", (String)"ConvertResultFormEdit_14", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private Map<Object, String> loadBillNoFromDB(String entityNumber, Object[] ids) {
        HashMap<Object, String> billNos = new HashMap<Object, String>();
        if (StringUtils.isBlank((CharSequence)entityNumber) || ids.length == 0) {
            return billNos;
        }
        BillEntityType mainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (StringUtils.isNotBlank((CharSequence)mainType.getBillNo())) {
            DynamicObject[] objs;
            ArrayList<String> selectedFields = new ArrayList<String>();
            selectedFields.add("id");
            selectedFields.add(mainType.getBillNo());
            BillEntityType subMainType = (BillEntityType)mainType.getSubEntityType(selectedFields);
            for (DynamicObject obj : objs = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)subMainType)) {
                String billNo = obj.getString(mainType.getBillNo());
                billNos.put(obj.getPkValue(), billNo);
            }
        }
        return billNos;
    }

    private static enum SaveStatus {
        UN_SAVE(0, new MultiLangEnumBridge("\u672a\u4fdd\u5b58", "SaveStatus_0", "bos-botp-formplugin")),
        SAVED(1, new MultiLangEnumBridge("\u5df2\u4fdd\u5b58", "SaveStatus_1", "bos-botp-formplugin")),
        Submit(2, new MultiLangEnumBridge("\u5df2\u63d0\u4ea4", "SaveStatus_2", "bos-botp-formplugin")),
        AUDIT(3, new MultiLangEnumBridge("\u5df2\u5ba1\u6838", "SaveStatus_3", "bos-botp-formplugin"));

        private int value;
        private String name;
        private MultiLangEnumBridge bridge = null;

        private SaveStatus(int value, MultiLangEnumBridge bridge) {
            this.value = value;
            this.bridge = bridge;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.bridge.loadKDString();
        }

        public static SaveStatus valueOf(int value) {
            SaveStatus status = UN_SAVE;
            switch (value) {
                case 0: {
                    status = UN_SAVE;
                    break;
                }
                case 1: {
                    status = SAVED;
                    break;
                }
                case 2: {
                    status = Submit;
                    break;
                }
                case 3: {
                    status = AUDIT;
                    break;
                }
                default: {
                    status = UN_SAVE;
                }
            }
            return status;
        }
    }
}

