/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.SourceRowReport;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.service.botp.facade.ConvertResultFormEditFacade;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;

public class MobConvertTrackerEdit
extends AbstractBillPlugIn {
    private static final String KEY_TITLE_PANEL_BILL = "titlepanel";
    private static final String KEY_TITLE_PANEL_BASE = "titleapanel";
    private ConvertOperationResult convertOperationResult;
    private ConvertResultFormEditFacade convertFormEditFacade = ConvertResultFormEditFacade.getInstance();

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        String cachePageId = ((BillShowParameter)this.getView().getFormShowParameter()).getCachePageId();
        if (StringUtils.isBlank((CharSequence)cachePageId)) {
            return;
        }
        ConvertOperationResult convertResult = this.getConvertResult();
        if (convertResult == null) {
            return;
        }
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
            }
        };
        MainEntityType mainType = this.getModel().getDataEntityType();
        DynamicObject dataEntity = convertResult.loadTargetDataObject(refDataProvider, mainType, cachePageId);
        if (dataEntity != null) {
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            this.convertFormEditFacade.beforeCreateDataForChildView(pageCache, dataEntity);
            ExtendedDataEntitySet dataEntitySet = new ExtendedDataEntitySet();
            dataEntitySet.Parse(new DynamicObject[]{dataEntity}, mainType);
            for (EntityType entityType : mainType.getAllEntities().values()) {
                ExtendedDataEntity[] extDataEntitys = dataEntitySet.FindByEntityKey(entityType.getName());
                if (extDataEntitys == null) continue;
                for (ExtendedDataEntity extDataEntity : extDataEntitys) {
                    if (!extDataEntity.getDataEntity().getDataEntityState().isBizChanged()) continue;
                    extDataEntity.getDataEntity().getDataEntityState().setPushChanged(true);
                }
            }
        }
        e.setDataEntity((Object)dataEntity);
        e.setFireAfterCreateNewData(false);
    }

    public void afterBindData(EventObject e) {
        IPageCache parentPageCache;
        String cacheProcessing;
        super.afterBindData(e);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null && StringUtils.isNotBlank((CharSequence)(cacheProcessing = (parentPageCache = (IPageCache)parentView.getService(IPageCache.class)).get("isload")))) {
            parentPageCache.put("isload", String.valueOf(false));
        }
        this.hideMainBar();
        this.showReport();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getSource() instanceof FormOperate) {
            FormOperate op = (FormOperate)e.getSource();
            boolean clearCachePage = false;
            if (StringUtils.equals((CharSequence)"new", (CharSequence)op.getType()) || StringUtils.equals((CharSequence)"copy", (CharSequence)op.getType())) {
                clearCachePage = true;
            } else if ((StringUtils.equals((CharSequence)"save", (CharSequence)op.getType()) || StringUtils.equals((CharSequence)"submit", (CharSequence)op.getType()) || StringUtils.equals((CharSequence)"audit", (CharSequence)op.getType())) && e.getOperationResult() != null && !e.getOperationResult().getSuccessPkIds().isEmpty()) {
                clearCachePage = true;
            }
            if (clearCachePage) {
                ((BillShowParameter)this.getView().getFormShowParameter()).setCachePageId(null);
                this.getView().cacheFormShowParameter();
            }
        }
    }

    public void pageRelease(EventObject e) {
        Boolean keepResult;
        String paramValue = (String)this.getView().getFormShowParameter().getCustomParam("keepresult");
        if (StringUtils.isNotBlank((CharSequence)paramValue) && (keepResult = Boolean.valueOf(paramValue)).booleanValue()) {
            return;
        }
        this.releaseResult();
        this.releasePushaMutex();
    }

    private void hideMainBar() {
        String parmValue = (String)this.getView().getFormShowParameter().getCustomParam("hidemainbar");
        if (StringUtils.isBlank((CharSequence)parmValue)) {
            return;
        }
        boolean hide = Boolean.parseBoolean(parmValue);
        if (!hide) {
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_TITLE_PANEL_BILL, KEY_TITLE_PANEL_BASE});
    }

    private void showReport() {
        String parmValue = this.getPageCache().get("showreport");
        boolean showReport = true;
        if (StringUtils.isNotBlank((CharSequence)parmValue) && !(showReport = Boolean.parseBoolean(parmValue))) {
            return;
        }
        this.getPageCache().put("showreport", String.valueOf(false));
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        ConvertOperationResult convertResult = this.getConvertResult();
        if (convertResult == null || parentView == null) {
            return;
        }
        parmValue = (String)this.getView().getFormShowParameter().getCustomParam("showreport");
        if (StringUtils.isBlank((CharSequence)parmValue)) {
            return;
        }
        showReport = Boolean.parseBoolean(parmValue);
        if (!showReport) {
            return;
        }
        if (this.getView() instanceof IMobileView) {
            MobConvertTrackerEdit.showMobileReport(this.getView(), convertResult);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_convertreport");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getOpenStyle().setInlineStyleCss(new StyleCss());
        showParameter.getOpenStyle().getInlineStyleCss().setHeight("410px");
        showParameter.getOpenStyle().getInlineStyleCss().setWidth("850px");
        showParameter.setShowTitle(true);
        showParameter.getCustomParams().put("convertresultpageid", this.getView().getFormShowParameter().getParentPageId());
        this.getView().showForm(showParameter);
    }

    private ConvertOperationResult getConvertResult() {
        if (this.convertOperationResult != null) {
            return this.convertOperationResult;
        }
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return null;
        }
        IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
        String convertResultJson = pageCache.get("ConvertOperationResult");
        if (StringUtils.isBlank((CharSequence)convertResultJson)) {
            return null;
        }
        this.convertOperationResult = (ConvertOperationResult)SerializationUtils.fromJsonString((String)convertResultJson, ConvertOperationResult.class);
        return this.convertOperationResult;
    }

    private void releaseResult() {
        ConvertOperationResult convertResult = this.getConvertResult();
        if (convertResult == null) {
            return;
        }
        MainEntityType mainType = this.getModel().getDataEntityType();
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
            }
        };
        convertResult.release(refDataProvider, mainType);
        this.getPageCache().remove("ConvertOperationResult");
    }

    private void releasePushaMutex() {
        ConvertOperationResult convertResult = this.getConvertResult();
        if (convertResult == null) {
            return;
        }
        if (convertResult.getDataMutexSrcBillIds().isEmpty()) {
            return;
        }
        HashSet srcBillIds = new HashSet(convertResult.getDataMutexSrcBillIds());
        ConvertServiceHelper.releasePushMutex((String)convertResult.getSourceEntityNumber(), srcBillIds);
        convertResult.getDataMutexSrcBillIds().clear();
    }

    private static void showMobileReport(IFormView view, ConvertOperationResult convertResult) {
        String failMessage = convertResult.getMessage();
        if (!convertResult.getBillReports().isEmpty()) {
            SourceBillReport billReport = (SourceBillReport)convertResult.getBillReports().get(0);
            if (!billReport.getFailMessages().isEmpty()) {
                failMessage = (String)billReport.getFailMessages().get(0);
            } else if (!billReport.getLinkEntityRowReports().isEmpty()) {
                failMessage = ((SourceRowReport)billReport.getLinkEntityRowReports().get(0)).getFailMessage();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)failMessage)) {
            view.showErrorNotification(failMessage);
        }
    }
}

