/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowComparator;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.MobileListShowParameter;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class MobLookUpTrackerEdit
extends AbstractMobFormPlugin
implements TreeNodeClickListener {
    private static final String CACHEKEY_PAGEIDS = "pageids";
    private static final String KEY_TABAP = "tabap";
    private static final String KEY_PRE_TARGETKEY = "tabbills";
    private Map<Long, TableDefine> tableDefines = new HashMap<Long, TableDefine>();
    private Map<String, TableDefine> mainTableDefines = new HashMap<String, TableDefine>();
    private Map<String, String> childPageIds = new HashMap<String, String>();
    private Map<String, String> checkRightAppIds;

    private Map<String, String> getCheckRightAppIds() {
        if (this.checkRightAppIds == null) {
            String appIds = (String)this.getView().getFormShowParameter().getCustomParam("track_checkrightappids");
            this.checkRightAppIds = StringUtils.isBlank((CharSequence)appIds) ? new HashMap<String, String>() : (Map)SerializationUtils.fromJsonString((String)appIds, Map.class);
        }
        return this.checkRightAppIds;
    }

    private boolean isShowEditStatus() {
        boolean isEditStatus = false;
        String showStatusParam = (String)this.getView().getFormShowParameter().getCustomParam("botp_track_edit_status");
        if (StringUtils.isNotBlank((CharSequence)showStatusParam)) {
            isEditStatus = Boolean.parseBoolean(showStatusParam);
        }
        return isEditStatus;
    }

    private List<String> getCustPlugins() {
        String custPlugParam = (String)this.getView().getFormShowParameter().getCustomParam("botp_track_cust_plugin");
        if (StringUtils.isBlank((CharSequence)custPlugParam)) {
            return new ArrayList<String>(0);
        }
        String[] custPlugClassNames = StringUtils.split((String)custPlugParam, (String)",");
        ArrayList<String> list = new ArrayList<String>(custPlugClassNames.length);
        for (String className : custPlugClassNames) {
            if (!StringUtils.isNotBlank((CharSequence)className) || list.contains(className)) continue;
            list.add(className);
        }
        return list;
    }

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showAllList();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String entityNumber = closedCallBackEvent.getActionId();
        String pageId = this.getPageId(entityNumber);
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            this.closePage(entityNumber);
        }
    }

    private void showAllList() {
        this.childPageIds.clear();
        Map<Long, HashSet<Long>> mainTableIdMap = this.findMainTableIds();
        int i = 0;
        for (Map.Entry<Long, HashSet<Long>> entry : mainTableIdMap.entrySet()) {
            Long mainTableId = entry.getKey();
            HashSet<Long> billIds = entry.getValue();
            this.showList(mainTableId, billIds, i);
            ++i;
        }
        this.putPageIds(this.childPageIds);
    }

    private void showList(Long mainTableId, HashSet<Long> billIds, Integer index) {
        MobileListShowParameter showParameter;
        TableDefine tableDefine = this.loadTableDefine(mainTableId);
        if (tableDefine == null) {
            return;
        }
        String entityNumber = tableDefine.getEntityNumber();
        String pageId = this.getPageId(entityNumber);
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            return;
        }
        if (billIds == null || billIds.size() == 0) {
            return;
        }
        String lookUpTrackerUseList = (String)this.getView().getFormShowParameter().getCustomParam("lookuptracker_use_list");
        if (billIds.size() == 1 && !Boolean.parseBoolean(lookUpTrackerUseList) && (showParameter = this.createBillShowParameter(entityNumber, billIds.iterator().next(), index)) != null) {
            this.getView().showForm((FormShowParameter)showParameter);
            this.childPageIds.put(entityNumber, showParameter.getPageId());
            return;
        }
        showParameter = this.createShowParameter(entityNumber, billIds, index);
        if (showParameter != null) {
            this.getView().showForm((FormShowParameter)showParameter);
            this.childPageIds.put(entityNumber, showParameter.getPageId());
        }
    }

    protected MobileBillShowParameter createBillShowParameter(String entityNumber, Long billId, Integer index) {
        MobileBillShowParameter mobileBillShowParameter = new MobileBillShowParameter();
        mobileBillShowParameter.setFormId(entityNumber + "_mob");
        mobileBillShowParameter.getCustomParams().put("isIgnoreLicense", true);
        mobileBillShowParameter.getCustomParams().put("bos_call_source_type", "botp_track");
        String appId = this.getCheckRightAppIds().get(entityNumber);
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            mobileBillShowParameter.getCustomParams().put("checkRightAppId", appId);
        }
        mobileBillShowParameter.setPkId((Object)billId);
        boolean isEditStatus = this.isShowEditStatus();
        if (isEditStatus) {
            mobileBillShowParameter.setStatus(OperationStatus.EDIT);
        } else {
            mobileBillShowParameter.setStatus(OperationStatus.VIEW);
            mobileBillShowParameter.setShowTitle(false);
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            mobileBillShowParameter.setCaption(String.format(ResManager.loadKDString((String)"%1$s%2$s\u67e5\u770b", (String)"MobLookUpTrackerEdit_4", (String)"bos-botp-formplugin", (Object[])new Object[0]), mainType.getDisplayName().toString(), " - "));
        }
        mobileBillShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        mobileBillShowParameter.getOpenStyle().setTargetKey(KEY_PRE_TARGETKEY + index);
        this.createTabPage(index, KEY_PRE_TARGETKEY + index, new LocaleString(mobileBillShowParameter.getCaption()));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entityNumber);
        mobileBillShowParameter.setCloseCallBack(closeCallBack);
        List<String> custPlugins = this.getCustPlugins();
        if (!custPlugins.isEmpty()) {
            for (String custPlugin : custPlugins) {
                mobileBillShowParameter.addCustPlugin(custPlugin);
            }
        }
        mobileBillShowParameter.setHasRight(true);
        return mobileBillShowParameter;
    }

    protected MobileListShowParameter createShowParameter(String entityNumber, HashSet<Long> billIds, Integer index) {
        MobileListShowParameter mobileListShowParameter = new MobileListShowParameter();
        mobileListShowParameter.setBillFormId(entityNumber);
        mobileListShowParameter.getCustomParams().put("isIgnoreLicense", true);
        mobileListShowParameter.getCustomParams().put("bos_call_source_type", "botp_track");
        String appId = this.getCheckRightAppIds().get(entityNumber);
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            mobileListShowParameter.getCustomParams().put("checkRightAppId", appId);
        }
        mobileListShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        mobileListShowParameter.getOpenStyle().setTargetKey(KEY_PRE_TARGETKEY + index);
        mobileListShowParameter.setShowTitle(false);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        mobileListShowParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u5217\u8868", (String)"MobLookUpTrackerEdit_3", (String)"bos-botp-formplugin", (Object[])new Object[0]), mainType.getDisplayName().toString()));
        this.createTabPage(index, KEY_PRE_TARGETKEY + index, new LocaleString(mobileListShowParameter.getCaption()));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entityNumber);
        mobileListShowParameter.setCloseCallBack(closeCallBack);
        QFilter qFilter = null;
        qFilter = billIds.size() == 1 ? new QFilter("id", "=", (Object)billIds.iterator().next()) : new QFilter("id", "in", (Object)billIds.toArray(new Long[0]));
        mobileListShowParameter.getListFilterParameter().setFilter(qFilter);
        mobileListShowParameter.addCustPlugin("kd.bos.form.plugin.botp.LookUpTrackerList");
        List<String> custPlugins = this.getCustPlugins();
        if (!custPlugins.isEmpty()) {
            for (String custPlugin : custPlugins) {
                mobileListShowParameter.addCustPlugin(custPlugin);
            }
        }
        mobileListShowParameter.setHasRight(true);
        return mobileListShowParameter;
    }

    private Map<Long, HashSet<Long>> findMainTableIds() {
        if (this.isLookDown()) {
            return this.findLookDownMainTableIds();
        }
        if (this.isLookUp()) {
            return this.findLookUpMainTableIds();
        }
        return this.findLookAllMainTableIds();
    }

    private Map<Long, HashSet<Long>> findLookUpMainTableIds() {
        List rows = BFRowComparator.compareLinkUpNodes(this.getLinkUpNodes());
        LinkedHashMap<Long, HashSet<Long>> sourceTableIds = new LinkedHashMap<Long, HashSet<Long>>();
        for (BFRow row : rows) {
            BFRowId rowId = row.getSId();
            this.addTableBillId(sourceTableIds, rowId);
        }
        return sourceTableIds;
    }

    private Map<Long, HashSet<Long>> findLookDownMainTableIds() {
        List<BFRowLinkDownNode> linkDownNodes = this.getLinkDownNodes();
        ArrayList targetNodes = new ArrayList();
        for (BFRowLinkDownNode node : linkDownNodes) {
            targetNodes.addAll(node.findAllChildNodes());
        }
        LinkedHashMap<Long, HashSet<Long>> targetTableIds = new LinkedHashMap<Long, HashSet<Long>>();
        for (BFRowLinkDownNode targetNode : targetNodes) {
            BFRowId rowId = targetNode.getRowId();
            this.addTableBillId(targetTableIds, rowId);
        }
        return targetTableIds;
    }

    private Map<Long, HashSet<Long>> findLookAllMainTableIds() {
        List<BFRow> allRows = this.getAllBFRows();
        LinkedHashMap<Long, HashSet<Long>> allTableBillIds = new LinkedHashMap<Long, HashSet<Long>>();
        for (BFRow row : allRows) {
            BFRowId sRowId = row.getSId();
            this.addTableBillId(allTableBillIds, sRowId);
            BFRowId tRowId = row.getId();
            this.addTableBillId(allTableBillIds, tRowId);
        }
        return allTableBillIds;
    }

    private void addTableBillId(Map<Long, HashSet<Long>> allTableBillIds, BFRowId rowId) {
        Long mainTableId = rowId.getMainTableId();
        Long billId = rowId.getBillId();
        HashSet billIds = allTableBillIds.computeIfAbsent(mainTableId, k -> new HashSet());
        billIds.add(billId);
    }

    private boolean isLookDown() {
        String lookupType = (String)this.getView().getFormShowParameter().getCustomParam("lookuptype");
        return StringUtils.isBlank((CharSequence)lookupType) || "lookdown".equals(lookupType);
    }

    private boolean isLookUp() {
        String lookupType = (String)this.getView().getFormShowParameter().getCustomParam("lookuptype");
        return StringUtils.isBlank((CharSequence)lookupType) || "lookup".equals(lookupType);
    }

    private boolean isLookAll() {
        String lookupType = (String)this.getView().getFormShowParameter().getCustomParam("lookuptype");
        return StringUtils.isBlank((CharSequence)lookupType) || "lookall".equals(lookupType);
    }

    private List<BFRowLinkUpNode> getLinkUpNodes() {
        String json = (String)this.getView().getFormShowParameter().getCustomParam("linknodes");
        if (StringUtils.isBlank((CharSequence)json)) {
            return new ArrayList<BFRowLinkUpNode>();
        }
        List nodes = (List)SerializationUtils.deSerializeFromBase64((String)json);
        return nodes;
    }

    private List<BFRowLinkDownNode> getLinkDownNodes() {
        String json = (String)this.getView().getFormShowParameter().getCustomParam("linknodes");
        if (StringUtils.isBlank((CharSequence)json)) {
            return new ArrayList<BFRowLinkDownNode>();
        }
        List nodes = (List)SerializationUtils.deSerializeFromBase64((String)json);
        return nodes;
    }

    private List<BFRow> getAllBFRows() {
        String json = (String)this.getView().getFormShowParameter().getCustomParam("linknodes");
        if (StringUtils.isBlank((CharSequence)json)) {
            return new ArrayList<BFRow>();
        }
        List nodes = (List)SerializationUtils.deSerializeFromBase64((String)json);
        return nodes;
    }

    private TableDefine loadMainTableDefine(String entityNumber) {
        TableDefine tableDefine = this.mainTableDefines.get(entityNumber);
        if (tableDefine == null && (tableDefine = ConvertMetaServiceHelper.loadTableDefine((String)entityNumber, (String)entityNumber)) != null) {
            this.mainTableDefines.put(entityNumber, tableDefine);
        }
        return tableDefine;
    }

    private TableDefine loadTableDefine(Long tableId) {
        TableDefine tableDefine = this.tableDefines.get(tableId);
        if (tableDefine == null && (tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)tableId)) != null) {
            this.tableDefines.put(tableId, tableDefine);
        }
        return tableDefine;
    }

    private String getPageId(String entityNumber) {
        Map<String, String> pageIds = this.getPageIds();
        return pageIds.get(entityNumber);
    }

    private void closePage(String entityNumber) {
        Map<String, String> pageIds = this.getPageIds();
        pageIds.remove(entityNumber);
        if (pageIds.isEmpty()) {
            this.getView().close();
        } else {
            this.putPageIds(pageIds);
        }
    }

    private void putPageIds(Map<String, String> childPageIds) {
        this.getPageCache().put(CACHEKEY_PAGEIDS, SerializationUtils.toJsonString(childPageIds));
    }

    private Map<String, String> getPageIds() {
        String cacheValue = this.getPageCache().get(CACHEKEY_PAGEIDS);
        if (StringUtils.isBlank((CharSequence)cacheValue)) {
            return new HashMap<String, String>();
        }
        return (Map)SerializationUtils.fromJsonString((String)cacheValue, Map.class);
    }

    private void createTabPage(Integer index, String key, LocaleString name) {
        Tab tab = (Tab)this.getView().getControl(KEY_TABAP);
        TabPageAp tabPageAp = new TabPageAp();
        tabPageAp.setKey(key);
        tabPageAp.setName(name);
        tab.insertControls(index.intValue(), Collections.singletonList(tabPageAp.createControl()));
    }
}

