/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.form.IPageCache;
import kd.bos.form.mcontrol.mobtable.MobTableRowBuilder;
import kd.bos.form.mcontrol.mobtable.MobTableRowData;
import kd.bos.form.mcontrol.mobtable.events.MobTableHandleResult;
import kd.bos.form.mcontrol.mobtable.events.MobTablePackageDataHandlerArgs;

class MobTablePackageDataHandler
extends kd.bos.form.mcontrol.mobtable.MobTablePackageDataHandler {
    private static final String KEY_SAVESTATUS = "savestatus";
    private static final String KEY_BILLNO = "billno";
    private static final String CACHEKEY_BILLCOUNT = "billcount";
    private static final String CACHEKEY_SAVECOUNT = "savecount";
    private ConvertOperationResult convertResult;
    private MainEntityType mainType;
    private String savestatus;
    private IPageCache pageCache;
    private Map<Object, String> billNos;

    public MobTablePackageDataHandler(ConvertOperationResult convertResult, MainEntityType mainType, String savestatus, IPageCache pageCache, Map<Object, String> billNos) {
        this.convertResult = convertResult;
        this.mainType = mainType;
        this.savestatus = savestatus;
        this.pageCache = pageCache;
        this.billNos = billNos;
    }

    public MobTableHandleResult handleData(MobTablePackageDataHandlerArgs args) {
        MobTableRowData mobTableRowData;
        int count = this.convertResult.getTargetBillIds().size() + this.convertResult.getCachePageIds().size();
        List mobTableColumns = args.getMobTableColumns();
        MobTableHandleResult mobTableHandleResult = new MobTableHandleResult();
        ArrayList<MobTableRowData> mobTableRowDataList = new ArrayList<MobTableRowData>(10);
        int rowIndex = 0;
        int savedCount = 0;
        for (String cachePageId : this.convertResult.getCachePageIds()) {
            mobTableRowData = MobTableRowBuilder.buildTemplateRowData((int)rowIndex, (List)mobTableColumns);
            mobTableRowData.setValue(KEY_SAVESTATUS, (Object)this.savestatus);
            mobTableRowData.setValue(KEY_BILLNO, (Object)this.getPushedBillNo(this.convertResult, this.mainType, this.buildRefLoader(), cachePageId));
            mobTableRowDataList.add(mobTableRowData);
            ++rowIndex;
        }
        for (Object pkId : this.convertResult.getTargetBillIds()) {
            mobTableRowData = MobTableRowBuilder.buildTemplateRowData((int)rowIndex, (List)mobTableColumns);
            mobTableRowData.setValue(KEY_SAVESTATUS, (Object)ResManager.loadKDString((String)"\u5df2\u4fdd\u5b58", (String)"MobTablePackageDataHandler_0", (String)"bos-botp-formplugin", (Object[])new Object[0]));
            mobTableRowData.setValue(KEY_BILLNO, (Object)this.billNos.get(pkId));
            mobTableRowDataList.add(mobTableRowData);
            ++rowIndex;
            ++savedCount;
        }
        this.pageCache.put(CACHEKEY_BILLCOUNT, String.valueOf(count));
        if (savedCount > 0) {
            this.pageCache.put(CACHEKEY_SAVECOUNT, String.valueOf(savedCount));
        }
        mobTableHandleResult.setMobTableRowDataList(mobTableRowDataList);
        return mobTableHandleResult;
    }

    private String getPushedBillNo(ConvertOperationResult convertResult, MainEntityType mainType, IRefrencedataProvider refLoader, String cachePageId) {
        if (!(mainType instanceof BillEntityType)) {
            return "";
        }
        String billNoKey = ((BillEntityType)mainType).getBillNo();
        if (StringUtils.isBlank((CharSequence)billNoKey)) {
            return "";
        }
        DynamicObject billObj = convertResult.loadTargetDataObject(refLoader, mainType, cachePageId, false);
        return billObj != null ? billObj.getString(billNoKey) : "";
    }

    private IRefrencedataProvider buildRefLoader() {
        return new IRefrencedataProvider(){

            public void fillReferenceData(Object[] objs, IDataEntityType dType) {
                BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dType);
            }
        };
    }
}

