/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp.jobtask;

import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.runtime.ConvertOpProgressCache;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.operate.botp.PushBigDataTask;
import kd.bos.form.plugin.botp.jobtask.JobFormTaskClickManager;
import kd.bos.form.plugin.botp.jobtask.JobFormTaskCloseManager;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;

public class BackgroundTaskManager {
    private IFormView formView;

    private BackgroundTaskManager(IFormView formView) {
        this.formView = formView;
    }

    public static BackgroundTaskManager newInstance(IFormView formView) {
        return new BackgroundTaskManager(formView);
    }

    public void dispatchBackgroundTask(PushArgs pushArgs) {
        JobFormInfo jobFormInfo = this.buildJobFormInfo(pushArgs);
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.toBackGround(taskId, jobFormInfo);
    }

    private void toBackGround(String taskId, JobFormInfo jobFormInfo) {
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (TaskClientProxy.isExistTask((String)taskId)) {
            return;
        }
        TaskClientProxy.addTask((IFormView)this.formView, (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
        BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
        ThreadPools.executeOnce((String)"task-botp-push-background-monitor", (Runnable)subscriber);
    }

    private JobFormInfo buildJobFormInfo(PushArgs pushArgs) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setName(ResManager.loadKDString((String)"\u4e0b\u63a8", (String)"BackgroundTaskManager_0", (String)"bos-botp-formplugin", (Object[])new Object[0]));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("bos");
        jobInfo.setTaskClassname(PushBigDataTask.class.getName());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PushArgs.class.getSimpleName() + "_taskId", pushArgs.getTaskId());
        jobInfo.setParams(params);
        ConvertOpProgressCache.setParam((String)pushArgs.getTaskId(), (String)PushArgs.class.getSimpleName(), (String)SerializationUtils.toJsonString((Object)pushArgs));
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(this.formView.getFormShowParameter().getParentPageId());
        jobFormInfo.setRootPageId(this.formView.getFormShowParameter().getRootPageId());
        jobFormInfo.setClickClassName(JobFormTaskClickManager.class.getName());
        CloseCallBack closeCallBack = new CloseCallBack(JobFormTaskCloseManager.class.getName(), "background_actionid");
        jobFormInfo.setCloseCallBack(closeCallBack);
        return jobFormInfo;
    }
}

