/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp.jobtask;

import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOpProgressCache;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.form.IFormView;
import kd.bos.form.operate.botp.Push;
import kd.bos.krpc.common.json.JSON;
import kd.bos.krpc.common.json.ParseException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.event.ClickEventArgs;

public class JobFormTaskClickManager
extends AbstractTaskClick {
    private static final Log log = LogFactory.getLog(JobFormTaskClickManager.class);

    public void click(ClickEventArgs e) {
        super.click(e);
        TaskInfo taskInfo = this.queryTask();
        if (taskInfo == null) {
            return;
        }
        if (!taskInfo.isTaskEnd()) {
            return;
        }
        this.complete(taskInfo);
        IFormView view = this.getParentView();
        if (view != null && !StringUtils.equals((CharSequence)this.getMainView().getPageId(), (CharSequence)view.getPageId())) {
            this.getMainView().sendFormAction(view);
        }
    }

    private void complete(TaskInfo taskInfo) {
        Optional<PushArgs> argsOptional;
        IFormView view = this.getParentView();
        if (view == null) {
            view = this.getMainView();
        }
        if (!(argsOptional = this.loadPushArgs(taskInfo)).isPresent()) {
            return;
        }
        PushArgs pushArgs = argsOptional.get();
        if (ConvertOpProgressCache.isError((String)pushArgs.getTaskId())) {
            view.showErrMessage(ConvertOpProgressCache.getErrorMessage((String)pushArgs.getTaskId()), "");
            return;
        }
        Optional<ConvertOperationResult> operateResultOptional = this.loadConvertOoperationResult(taskInfo);
        if (!operateResultOptional.isPresent()) {
            view.showErrorNotification("convertOperationResult is not found");
            return;
        }
        ConvertOperationResult operateResult = operateResultOptional.get();
        if (!operateResult.isSuccess()) {
            Push.showReport((IFormView)view, (AbstractConvertServiceArgs)pushArgs, (ConvertOperationResult)operateResult);
            return;
        }
        if (operateResult.getCachePageIds().size() + operateResult.getTargetBillIds().size() == 1) {
            Push.showTargetBill((IFormView)view, (PushArgs)pushArgs, (ConvertOperationResult)operateResult, (boolean)pushArgs.isShowReport());
            return;
        }
        Push.showMultiTargetBills((IFormView)view, (PushArgs)pushArgs, (ConvertOperationResult)operateResult, (boolean)pushArgs.isShowReport());
    }

    private Optional<PushArgs> loadPushArgs(TaskInfo taskInfo) {
        if (!taskInfo.isTaskEnd()) {
            return Optional.empty();
        }
        String dataStr = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)dataStr)) {
            return Optional.empty();
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)dataStr, Map.class);
        Object pushArgsStr = data.get("pushArgs");
        PushArgs args = null;
        try {
            args = (PushArgs)JSON.parse((String)pushArgsStr.toString(), PushArgs.class);
        }
        catch (ParseException e) {
            log.error((Throwable)e);
        }
        return Optional.ofNullable(args);
    }

    private Optional<ConvertOperationResult> loadConvertOoperationResult(TaskInfo taskInfo) {
        if (!taskInfo.isTaskEnd()) {
            return Optional.empty();
        }
        String dataStr = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)dataStr)) {
            return Optional.empty();
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)dataStr, Map.class);
        Object convertOperationResultStr = data.get("ConvertOperationResult");
        ConvertOperationResult result = (ConvertOperationResult)SerializationUtils.fromJsonString((String)convertOperationResultStr.toString(), ConvertOperationResult.class);
        return Optional.ofNullable(result);
    }
}

