/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp.layout;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.botp.layout.LayoutConfigItem;
import kd.bos.form.plugin.botp.layout.LayoutInfo;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.cardentry.CardEntryFieldAp;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class BotpLayoutManager {
    private static Log log = LogFactory.getLog(BotpLayoutManager.class);
    private static final String BOS_BOTP_FORMPLUGIN = "bos-botp-formplugin";
    public static final String BILLPARAMETER_PUSH_DRAW_LAYOUTCONFIG = "pushdrawlayoutconfigdata";
    public static final String SYMBOL_LAYOUTCOMBOITEM = "&";
    private static final String GROPUP_BILLF7 = "billF7:%s:%s";
    private static final String CACHEKEY_PCLAYOUTF7 = "pcLayoutF7:%s";
    private static final String CACHEKEY_MOBILELAYOUTF7 = "mobileLayoutF7:%s";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_MODELTYPE = "modeltype";

    public List<LayoutConfigItem> queryLayoutConfig(String entityNumber, String configDataKey) {
        List<LayoutConfigItem> layoutConfigItemList = new ArrayList<LayoutConfigItem>();
        try {
            if (StringUtils.isBlank((CharSequence)entityNumber)) {
                return layoutConfigItemList;
            }
            Map billParameter = SystemParamServiceHelper.loadBillParameterObjectFromCache((String)entityNumber);
            if (MapUtils.isEmpty((Map)billParameter)) {
                return layoutConfigItemList;
            }
            Object configData = billParameter.get(configDataKey);
            if (StringUtils.isNotBlank(configData) && configData instanceof String) {
                layoutConfigItemList = SerializationUtils.fromJsonStringToList((String)((String)configData), LayoutConfigItem.class);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return layoutConfigItemList;
    }

    public List<ComboItem> convertLayoutComboItemList(List<ComboItem> comboItemList, ConvertOpParameter opParameter, boolean isPc, IFormView formView) {
        boolean isbillsofplugin = Boolean.parseBoolean((String)formView.getFormShowParameter().getCustomParam("isbillsofplugin"));
        if (isbillsofplugin) {
            return comboItemList;
        }
        List<LayoutConfigItem> layoutConfigItemList = this.queryLayoutConfig(opParameter.getEntityNumber(), BILLPARAMETER_PUSH_DRAW_LAYOUTCONFIG);
        ArrayList<ComboItem> layoutComboItemList = new ArrayList<ComboItem>();
        if (CollectionUtils.isNotEmpty(layoutConfigItemList)) {
            Map<String, LayoutConfigItem> billLayoutConfigMapping = this.groupLayoutConfigMapping(layoutConfigItemList);
            for (ComboItem comboItem : comboItemList) {
                List<ComboItem> matchLayoutComboItemList = this.replaceLayoutName(comboItem.getValue(), billLayoutConfigMapping, opParameter, isPc, formView.getPageCache());
                if (CollectionUtils.isNotEmpty(matchLayoutComboItemList)) {
                    layoutComboItemList.addAll(matchLayoutComboItemList);
                    continue;
                }
                layoutComboItemList.add(comboItem);
            }
        }
        return CollectionUtils.isNotEmpty(layoutComboItemList) ? layoutComboItemList : comboItemList;
    }

    public Map<String, LayoutConfigItem> groupLayoutConfigMapping(List<LayoutConfigItem> layoutConfigItemList) {
        HashMap<String, LayoutConfigItem> layoutConfigItemMapping = new HashMap<String, LayoutConfigItem>(layoutConfigItemList.size());
        for (LayoutConfigItem layoutConfigItem : layoutConfigItemList) {
            StringBuilder builder = new StringBuilder(layoutConfigItem.getOption());
            layoutConfigItemMapping.put(builder.append(SYMBOL_LAYOUTCOMBOITEM).append(layoutConfigItem.getToFormId()).toString(), layoutConfigItem);
        }
        return layoutConfigItemMapping;
    }

    public List<ComboItem> replaceLayoutName(String entityNumber, Map<String, LayoutConfigItem> billLayoutConfigMapping, ConvertOpParameter opParameter, boolean isPc, IPageCache pageCache) {
        ArrayList<ComboItem> layoutComboItemList = new ArrayList<ComboItem>();
        LayoutConfigItem layoutConfigItem = this.matchLayoutConfigItem(entityNumber, opParameter, billLayoutConfigMapping);
        if (layoutConfigItem == null) {
            return layoutComboItemList;
        }
        String[] layoutIds = layoutConfigItem.getLayoutIds(isPc);
        String[] layoutNumbers = layoutConfigItem.getLayoutNumbers(isPc);
        String[] layoutNames = layoutConfigItem.getLayoutNames(isPc);
        List<String> usableLayoutNumberList = this.queryLayoutNumberListFromCache(entityNumber, pageCache, isPc);
        for (int i = 0; i < layoutIds.length; ++i) {
            if (!usableLayoutNumberList.contains(layoutNumbers[i])) continue;
            ComboItem layoutItem = new ComboItem();
            layoutItem.setValue(layoutConfigItem.getToFormId() + SYMBOL_LAYOUTCOMBOITEM + layoutIds[i]);
            layoutItem.setCaption(new LocaleString(Lang.get().toString(), layoutNames[i]));
            layoutComboItemList.add(layoutItem);
        }
        return layoutComboItemList;
    }

    public String getBillItemValue(IDataModel dataModel, String billFieldKey) {
        String billItemValue = (String)dataModel.getValue(billFieldKey);
        return this.getEntityNumberFromItemValue(billItemValue);
    }

    public boolean billItemValueChange(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        return !StringUtils.equals((CharSequence)this.getEntityNumberFromItemValue((String)newValue), (CharSequence)this.getEntityNumberFromItemValue((String)oldValue));
    }

    public void setDefaultBill(String defBillEntityNumber, List<ComboItem> billItems, IDataModel dataModel, String comboFieldKey) {
        for (ComboItem billItem : billItems) {
            String entityNumberOfItemValue = this.getEntityNumberFromItemValue(billItem.getValue());
            if (!StringUtils.equals((CharSequence)defBillEntityNumber, (CharSequence)entityNumberOfItemValue)) continue;
            dataModel.setValue(comboFieldKey, (Object)billItem.getValue());
            break;
        }
    }

    private String getEntityNumberFromItemValue(String billItemValue) {
        if (StringUtils.isNotBlank((CharSequence)billItemValue) && billItemValue.contains(SYMBOL_LAYOUTCOMBOITEM)) {
            billItemValue = billItemValue.split(SYMBOL_LAYOUTCOMBOITEM)[0];
        }
        return billItemValue;
    }

    public List<String> queryLayoutNumberListFromCache(String billNumber, IPageCache pageCache, boolean isPc) {
        return isPc ? this.queryPcLayoutNumberListFromCache(billNumber, pageCache) : this.queryMobileLayoutNumberListFromCache(billNumber, pageCache);
    }

    private List<String> queryPcLayoutNumberListFromCache(String billNumber, IPageCache pageCache) {
        if (pageCache == null) {
            return this.queryPcLayoutNumberListFromDB(billNumber);
        }
        String cacheKey = String.format(CACHEKEY_PCLAYOUTF7, billNumber);
        String layoutNumberListJson = pageCache.get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)layoutNumberListJson)) {
            return SerializationUtils.fromJsonStringToList((String)layoutNumberListJson, String.class);
        }
        List<String> layoutNumberList = this.queryPcLayoutNumberListFromDB(billNumber);
        pageCache.put(cacheKey, SerializationUtils.toJsonString(layoutNumberList));
        return layoutNumberList;
    }

    private List<String> queryPcLayoutNumberListFromDB(String billNumber) {
        List<LayoutInfo> pcLayoutInfoList = this.queryLayoutByFormId(billNumber, true, true);
        ArrayList<String> layoutNumberList = new ArrayList<String>(pcLayoutInfoList.size());
        for (LayoutInfo layout : pcLayoutInfoList) {
            layoutNumberList.add(layout.getLayoutNumber());
        }
        return layoutNumberList;
    }

    private List<String> queryMobileLayoutNumberListFromCache(String billNumber, IPageCache pageCache) {
        if (pageCache == null) {
            return this.queryMobileLayoutNumberListFromDB(billNumber, pageCache);
        }
        String cacheKey = String.format(CACHEKEY_MOBILELAYOUTF7, billNumber);
        String layoutNumberListJson = pageCache.get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)layoutNumberListJson)) {
            return SerializationUtils.fromJsonStringToList((String)layoutNumberListJson, String.class);
        }
        List<String> layoutNumberList = this.queryMobileLayoutNumberListFromDB(billNumber, pageCache);
        pageCache.put(cacheKey, SerializationUtils.toJsonString(layoutNumberList));
        return layoutNumberList;
    }

    private List<String> queryMobileLayoutNumberListFromDB(String billNumber, IPageCache pageCache) {
        List<LayoutInfo> mobileLayoutInfoList = this.queryLayoutByFormId(billNumber, true, false);
        ArrayList<String> layoutNumberList = new ArrayList<String>(mobileLayoutInfoList.size());
        for (LayoutInfo mobileLayout : mobileLayoutInfoList) {
            layoutNumberList.add(mobileLayout.getLayoutNumber());
        }
        return layoutNumberList;
    }

    private LayoutConfigItem matchLayoutConfigItem(String entityNumber, ConvertOpParameter opParameter, Map<String, LayoutConfigItem> billLayoutConfigMapping) {
        String opType = opParameter.getOpType() == ConvertOpType.Push ? "push" : "draw";
        StringBuilder builder = new StringBuilder(opType);
        return billLayoutConfigMapping.get(builder.append(SYMBOL_LAYOUTCOMBOITEM).append(entityNumber).toString());
    }

    private List<LayoutInfo> queryLayoutByFormId(String formId, boolean withDefaultLayout, boolean isPc) {
        ArrayList<String> formIdList = new ArrayList<String>(1);
        formIdList.add(formId);
        List<LayoutInfo> layoutInfoList = this.queryLayoutByFormId(formIdList, withDefaultLayout);
        ArrayList<LayoutInfo> resultLayoutInfoList = new ArrayList<LayoutInfo>();
        for (LayoutInfo layoutInfo : layoutInfoList) {
            boolean mobileModelType;
            String modelType = layoutInfo.getModelType();
            boolean pcModelType = !"MobileBillFormModel".equals(modelType);
            boolean bl = mobileModelType = "BillFormModel".equals(modelType) || "BaseFormModel".equals(modelType) || "MobileBillFormModel".equals(modelType);
            if (isPc && pcModelType) {
                resultLayoutInfoList.add(layoutInfo);
                continue;
            }
            if (isPc || !mobileModelType) continue;
            resultLayoutInfoList.add(layoutInfo);
        }
        return resultLayoutInfoList;
    }

    public List<LayoutInfo> queryLayoutByFormId(List<String> formIdList, boolean withDefaultLayout) {
        final ArrayList<LayoutInfo> layoutInfoList = new ArrayList<LayoutInfo>();
        if (CollectionUtils.isEmpty(formIdList)) {
            return layoutInfoList;
        }
        Object[] sqlParams = new SqlParameter[1 + formIdList.size()];
        sqlParams[0] = new SqlParameter(":FLocaleId", 12, (Object)Lang.get().toString());
        StringBuilder sql = new StringBuilder("select t0.fid layoutId,t0.fnumber layoutNumber, t0.fmodeltype, t1.fname, t2.fnumber entityNumber").append("  from t_meta_formdesign t0 ").append("  left join t_meta_formdesign_l t1 on (t0.fid = t1.fid and t1.flocaleid = ?) ").append(withDefaultLayout ? "  left join t_meta_entitydesign t2 on t0.fentityid = t2.fid " : "  left join t_meta_entitydesign t2 on (t0.fentityid = t2.fid and t0.fnumber <> t2.fnumber) ").append("  where t0.ftype <> '2' ").append("  and t2.fnumber in ( ");
        for (int i = 0; i < formIdList.size(); ++i) {
            sql.append("  ?, ");
            sqlParams[i + 1] = new SqlParameter(":FNumber", 12, (Object)formIdList.get(i));
        }
        sql.deleteCharAt(sql.lastIndexOf(","));
        sql.append(" ) ");
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    String layoutId = rs.getString(1);
                    String layoutNumber = rs.getString(2);
                    String modelType = rs.getString(3);
                    String layoutName = rs.getString(4);
                    if (StringUtils.isBlank((CharSequence)layoutName)) {
                        layoutName = layoutNumber;
                    }
                    String entityNumber = rs.getString(5);
                    LayoutInfo layoutInfo = new LayoutInfo(layoutId, layoutNumber, layoutName, entityNumber, modelType);
                    layoutInfoList.add(layoutInfo);
                }
                return true;
            }
        };
        DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])sqlParams, (ResultSetHandler)action);
        return layoutInfoList;
    }

    public void resetMobileLayout(DynamicObject formMeta) {
        boolean billOrBaseModelType;
        String modelType = formMeta.getString(FIELD_MODELTYPE);
        boolean bl = billOrBaseModelType = "BillFormModel".equals(modelType) || "BaseFormModel".equals(modelType);
        if (billOrBaseModelType) {
            String formNumber = formMeta.getString(FIELD_NUMBER);
            try {
                LocaleString mobileFormName = this.queryMobileLayoutName(modelType, formNumber, formMeta.getString(FIELD_NAME));
                formMeta.set(FIELD_NUMBER, (Object)(formNumber + "_mob"));
                formMeta.set(FIELD_NAME, (Object)mobileFormName.getLocaleValue());
                formMeta.set(FIELD_MODELTYPE, (Object)ResManager.loadKDString((String)"\u79fb\u52a8\u5355\u636e", (String)"BotpLayoutManager_1", (String)BOS_BOTP_FORMPLUGIN, (Object[])new Object[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public LocaleString queryMobileLayoutName(String modelType, String formNumber, String defaultName) {
        boolean billOrBaseModelType = "BillFormModel".equals(modelType) || "BaseFormModel".equals(modelType);
        LocaleString mobileFormName = null;
        if (billOrBaseModelType) {
            String mobileFormNumber = formNumber + "_mob";
            FormConfig mobileFormConfig = FormMetadataCache.getFormConfig((String)mobileFormNumber);
            mobileFormName = mobileFormConfig != null ? mobileFormConfig.getCaption() : null;
        }
        return mobileFormName != null && StringUtils.isNotBlank((CharSequence)mobileFormName.getLocaleValue()) ? mobileFormName : new LocaleString(defaultName);
    }

    public List<CardEntryFieldAp> replaceLayoutName(String entityNumber, Map<String, LayoutConfigItem> billLayoutConfigMapping, ConvertOpParameter opParameter, boolean isPc, String fieldKey, IPageCache pageCache) {
        ArrayList<CardEntryFieldAp> cardEntryFieldApList = new ArrayList<CardEntryFieldAp>();
        LayoutConfigItem layoutConfigItem = this.matchLayoutConfigItem(entityNumber, opParameter, billLayoutConfigMapping);
        if (layoutConfigItem == null) {
            return cardEntryFieldApList;
        }
        String[] layoutIds = layoutConfigItem.getLayoutIds(isPc);
        String[] layoutNumbers = layoutConfigItem.getLayoutNumbers(isPc);
        String[] layoutNames = layoutConfigItem.getLayoutNames(isPc);
        List<String> usableLayoutNumberList = this.queryLayoutNumberListFromCache(entityNumber, pageCache, isPc);
        for (int i = 0; i < layoutIds.length; ++i) {
            if (!usableLayoutNumberList.contains(layoutNumbers[i])) continue;
            String radioName = layoutNames[i];
            String radioValue = layoutConfigItem.getToFormId() + SYMBOL_LAYOUTCOMBOITEM + layoutIds[i];
            CardEntryFieldAp radioAp = this.getRadioField(radioValue, radioName, fieldKey);
            cardEntryFieldApList.add(radioAp);
        }
        return cardEntryFieldApList;
    }

    public CardEntryFieldAp getRadioField(String id, String name, String radioGroup) {
        CardEntryFieldAp fieldAp = new CardEntryFieldAp();
        fieldAp.setId(id);
        fieldAp.setKey(id);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setHeight(new LocaleString("48px"));
        fieldAp.setWidth(new LocaleString("100%"));
        fieldAp.setFireUpdEvt(true);
        fieldAp.setAutoWrap(false);
        RadioField rf = new RadioField();
        rf.setId(id);
        rf.setKey(id);
        rf.setName(new LocaleString(name));
        rf.setItems(id);
        rf.setGroup(radioGroup);
        fieldAp.setField((Field)rf);
        return fieldAp;
    }

    public void setDefaultRadiGroupItem(String entityNumber, List<ControlAp<?>> cardEntryFieldApList, IDataModel dataModel, String comboFieldKey) {
        for (ControlAp<?> cardEntryFieldAp : cardEntryFieldApList) {
            String entityNumberOfItemValue = this.getEntityNumberFromItemValue(cardEntryFieldAp.getId());
            if (!StringUtils.equals((CharSequence)entityNumber, (CharSequence)entityNumberOfItemValue)) continue;
            dataModel.setValue(comboFieldKey, (Object)cardEntryFieldAp.getId());
            break;
        }
    }
}

