/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp.link;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.botp.linkquery.LinkTrackerPo;
import kd.bos.entity.botp.linkquery.QueryTrackerLinkArgs;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.botp.QueryLinkServiceHelper;

public class TrackerQuery
extends AbstractListPlugin {
    private static final String BOS_BOTP_FORMPLUGIN = "bos-botp-formplugin";
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_TBAR = "tbar_main";
    private static final String KEY_BTN_DELETE = "delete";
    private static final String KEY_BTN_REFRESH = "refresh";
    private static final String KEY_SOURCE_BILL_IDS = "sourcebillfids";
    private static final String KEY_TARGET_BILL_IDS = "targetbillfids";
    private static final String KEY_SOURCEIDS = "sourceIds";
    private static final String KEY_TARGETIDS = "targetIds";
    private static final String KEY_TARGETNUMBER = "targetNumber";
    private static final String KEY_FIDS = "fids";
    private static final String KEY_BILLNOMAP = "billnoMap";
    private static final String KEY_DELETEMAP = "deleteMap";
    private static final String KEY_SEQ = "seq";
    private static final String KEY_SOURCEBILLNO = "sourcebillno";
    private static final String KEY_TARGETBILLNO = "targetbillno";
    private static final String KEY_FID = "fid";
    private static final String KEY_FSTABLEID = "fstableid";
    private static final String KEY_FSBILLID = "fsbillid";
    private static final String KEY_FTTABLEID = "fttableid";
    private static final String KEY_FTBILLID = "ftbillid";
    private static final String KEY_FCREATETIME = "fcreatetime";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.query();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar mbar = (Toolbar)this.getView().getControl(KEY_TBAR);
        mbar.addItemClickListener((ItemClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)KEY_BTN_REFRESH, (CharSequence)evt.getItemKey())) {
            this.query();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
    }

    private void query() {
        List sourceIds = (List)this.getView().getFormShowParameter().getCustomParam(KEY_SOURCEIDS);
        List targetIds = (List)this.getView().getFormShowParameter().getCustomParam(KEY_TARGETIDS);
        String targetNumber = (String)this.getView().getFormShowParameter().getCustomParam(KEY_TARGETNUMBER);
        String mapJson = (String)this.getView().getFormShowParameter().getCustomParam(KEY_BILLNOMAP);
        HashMap map = (HashMap)JSON.parseObject((String)mapJson, HashMap.class);
        this.getView().getModel().setValue(KEY_SOURCE_BILL_IDS, (Object)String.join((CharSequence)",", sourceIds));
        this.getView().getModel().setValue(KEY_TARGET_BILL_IDS, (Object)String.join((CharSequence)",", targetIds));
        List<Object> sourceBillIds = new ArrayList(16);
        List<Object> targetBillIds = new ArrayList(16);
        if (sourceIds != null) {
            sourceBillIds = sourceIds;
        } else {
            String sourceBill = (String)this.getModel().getValue(KEY_SOURCE_BILL_IDS);
            if (StringUtils.isNotBlank((CharSequence)sourceBill)) {
                sourceBillIds = Arrays.asList(sourceBill.split(","));
            }
        }
        if (targetIds != null) {
            targetBillIds = targetIds;
        } else {
            String targetBill = (String)this.getModel().getValue(KEY_TARGET_BILL_IDS);
            if (StringUtils.isNotBlank((CharSequence)targetBill)) {
                targetBillIds = Arrays.asList(targetBill.split(","));
            }
        }
        QueryTrackerLinkArgs args = new QueryTrackerLinkArgs(targetNumber, sourceBillIds, targetBillIds);
        List list = QueryLinkServiceHelper.queryTrackerLink((QueryTrackerLinkArgs)args);
        this.refreshEntryGrid(list, map);
    }

    private void refreshEntryGrid(List<LinkTrackerPo> linkTrackers, HashMap<String, String> map) {
        this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRY_ENTITY);
        rows.clear();
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRY_ENTITY);
        int seq = 1;
        for (LinkTrackerPo linkTracker : linkTrackers) {
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            row.set(KEY_SEQ, (Object)seq);
            if (map != null) {
                row.set(KEY_SOURCEBILLNO, (Object)map.get(linkTracker.getFsbillid()));
                row.set(KEY_TARGETBILLNO, (Object)map.get(linkTracker.getFtbillid()));
            }
            row.set(KEY_FID, (Object)linkTracker.getFid());
            row.set(KEY_FSTABLEID, (Object)linkTracker.getFstableid());
            row.set(KEY_FSBILLID, (Object)linkTracker.getFsbillid());
            row.set(KEY_FTTABLEID, (Object)linkTracker.getFttableid());
            row.set(KEY_FTBILLID, (Object)linkTracker.getFtbillid());
            row.set(KEY_FCREATETIME, (Object)linkTracker.getFcreatetime());
            rows.add((Object)row);
            ++seq;
        }
        this.getView().updateView(KEY_ENTRY_ENTITY);
    }
}

