/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.botp.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.botp.runtime.ConvertOpRule;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.args.PushArgsFactory;
import kd.bos.servicehelper.botp.ConvertServiceHelper;

public class FilterRuleUtils {
    private List<ConvertBill> filterBills = new ArrayList<ConvertBill>();

    public List<ConvertBill> filterBill(List<ConvertBill> billList, ConvertOpParameter opParameter) {
        ArrayList<ConvertBill> bills = new ArrayList<ConvertBill>(billList.size());
        for (ConvertBill bill : billList) {
            List<ConvertRuleElement> rules = this.doCheck(opParameter, bill.getEntityNumber());
            if (rules == null || rules.size() <= 0) continue;
            bill.getRules().clear();
            for (ConvertRuleElement rule : rules) {
                ConvertOpRule opRule = new ConvertOpRule(rule.getId(), rule.getName().toString());
                opRule.setVisibled(rule.isVisibled());
                bill.getRules().add(opRule);
            }
            bills.add(bill);
        }
        return bills;
    }

    private List<ConvertRuleElement> doCheck(ConvertOpParameter opParameter, String targetEntityNumber) {
        PushArgs args = this.buildPushArgs(opParameter, targetEntityNumber);
        if (args == null) {
            return null;
        }
        List result = ConvertServiceHelper.checkRunRuleCondition((PushArgs)args);
        return result;
    }

    private PushArgs buildPushArgs(ConvertOpParameter opParameter, String targetEntityNumber) {
        PushArgs args = PushArgsFactory.newInstances();
        if (StringUtils.isNotBlank((CharSequence)opParameter.getAppId())) {
            args.setAppId(opParameter.getAppId());
        }
        args.setSourceEntityNumber(opParameter.getEntityNumber());
        args.setTargetEntityNumber(targetEntityNumber);
        args.setSelectedRows((List)opParameter.getSelectedRows());
        args.setBuildConvReport(true);
        args.getCustomParams().putAll(opParameter.getCustomParams());
        args.setOpInfo(opParameter.getOpInfo());
        return args;
    }

    public List<ConvertBill> getFilterBills(List<ConvertBill> billList, ConvertOpParameter opParameter) {
        if (this.filterBills.size() > 0) {
            return this.filterBills;
        }
        this.filterBills = this.filterBill(billList, opParameter);
        return this.filterBills;
    }
}

