/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.botp;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.exception.KDException;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.botp.ConvertRuleMetadata;
import kd.bos.metadata.botp.ConvertRuleTemplate;
import kd.bos.metadata.botp.DesignConvertRuleMeta;
import kd.bos.metadata.dao.MetadataReader;

public class ConvertRuleReader {
    public ConvertRuleMetadata loadMeta(String id, boolean runtime) {
        return this.loadMeta(id, runtime, false);
    }

    public List<ConvertRuleMetadata> batchLoadMeta(String[] ids, boolean runtime) {
        ArrayList<ConvertRuleMetadata> ruleMetaDatas = new ArrayList<ConvertRuleMetadata>(16);
        for (String id : ids) {
            ruleMetaDatas.add(this.loadMeta(id, runtime));
        }
        return ruleMetaDatas;
    }

    public ConvertRuleMetadata loadMeta(String id, boolean runtime, boolean isBaseMeta) {
        IDataEntityType designerMetaType = OrmUtils.getDataEntityType(DesignConvertRuleMeta.class);
        AbstractMetadata meta = this.readRuleMetadata(id, designerMetaType, runtime, isBaseMeta);
        return (ConvertRuleMetadata)meta;
    }

    public List<ConvertRuleMetadata> loadMetas(String sourceEntityNumber, String targetEntityNumber) {
        IDataEntityType designerMetaType = OrmUtils.getDataEntityType(DesignConvertRuleMeta.class);
        List<String> ruleIds = this.loadRuleIds(sourceEntityNumber, targetEntityNumber, false);
        ArrayList<ConvertRuleMetadata> ruleMetadatas = new ArrayList<ConvertRuleMetadata>();
        for (String ruleId : ruleIds) {
            try {
                AbstractMetadata metadata = this.readRuleMetadata(ruleId, designerMetaType, false, false);
                ruleMetadatas.add((ConvertRuleMetadata)metadata);
            }
            catch (KDException kDException) {}
        }
        return ruleMetadatas;
    }

    public List<ConvertRuleElement> loadRules(String sourceEntityNumber, String targetEntityNumber) {
        IDataEntityType designerMetaType = OrmUtils.getDataEntityType(DesignConvertRuleMeta.class);
        List<String> ruleIds = this.loadRuleIds(sourceEntityNumber, targetEntityNumber, true);
        ArrayList<ConvertRuleElement> rules = new ArrayList<ConvertRuleElement>(10);
        for (String ruleId : ruleIds) {
            ConvertRuleMetadata metadata = (ConvertRuleMetadata)this.readRuleMetadata(ruleId, designerMetaType, true, false);
            if (metadata == null) continue;
            rules.add(metadata.getRuleElement());
        }
        return rules;
    }

    public List<String> loadRuleIds(String sourceEntityNumber, String targetEntityNumber, boolean runtime) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FId ");
        sBuilder.append("FROM ").append(this.getGrayTableName("T_BOTP_ConvertRule"));
        sBuilder.append(" WHERE FSourceEntityNumber = ? and FTargetEntityNumber = ? ");
        if (runtime) {
            sBuilder.append("and FType <> '2'");
        }
        Object[] params = new SqlParameter[]{new SqlParameter(":FSourceEntityNumber", 12, (Object)sourceEntityNumber), new SqlParameter(":FTargetEntityNumber", 12, (Object)targetEntityNumber)};
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> ids = new ArrayList<String>(10);
                while (rs.next()) {
                    String id = rs.getString("FId");
                    ids.add(id);
                }
                return ids;
            }
        };
        List ruleIds = (List)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
        if (ruleIds.isEmpty() && AppGroupUtils.isGrayGroup()) {
            sBuilder = new StringBuilder();
            sBuilder.append("SELECT FId ");
            sBuilder.append("FROM  ").append("T_BOTP_ConvertRule");
            sBuilder.append(" WHERE FSourceEntityNumber = ? and FTargetEntityNumber = ? ");
            if (runtime) {
                sBuilder.append("and FType <> '2'");
            }
            ruleIds = (List)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
        }
        return ruleIds;
    }

    public String buildXml(String ruleId, boolean runtime, boolean onlyLocaleValue) {
        String xmlData = "";
        ConvertRuleMetadata convertRuleMetadata = this.loadMeta(ruleId, runtime);
        if (convertRuleMetadata != null) {
            ConvertRuleTemplate template = new ConvertRuleTemplate();
            xmlData = template.buildDiffXml(convertRuleMetadata, null, onlyLocaleValue);
        }
        return xmlData;
    }

    private AbstractMetadata readRuleMetadata(String id, IDataEntityType designerMetaType, boolean runtime, boolean isBaseMeta) {
        MetadataReader reader = this.createMetaReader();
        AbstractMetadata meta = reader.readMeta(id, designerMetaType, runtime, isBaseMeta);
        if (meta == null && AppGroupUtils.isGrayGroup()) {
            reader = new MetadataReader();
            meta = reader.readMeta(id, designerMetaType, runtime, isBaseMeta);
        }
        return meta;
    }

    protected String getGrayTableName(String tabName) {
        if (!AppGroupUtils.isGrayGroup()) {
            return tabName;
        }
        return String.format("%s_%s", tabName, AppGroupUtils.getCurrentAppGroup());
    }

    private MetadataReader createMetaReader() {
        MetadataReader reader = new MetadataReader();
        reader.setColloctionIgnorePKValue(true);
        reader.setAppGroup(AppGroupUtils.getCurrentAppGroup());
        return reader;
    }
}

