/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.botp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.metadata.botp.common.RuleIsvHelper;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

class RuleDeleteChecker
extends AbstractValidator {
    boolean check = false;

    RuleDeleteChecker() {
    }

    public Set<String> preparePropertys() {
        Set fields = super.preparePropertys();
        fields.add("isv");
        return fields;
    }

    public void initializeConfiguration() {
        super.initializeConfiguration();
        if (StringUtils.equalsIgnoreCase((CharSequence)"delete", (CharSequence)this.getOperateKey())) {
            this.check = true;
        }
    }

    public void validate() {
        if (!this.check) {
            return;
        }
        this.validateExistChildren();
        this.validateISV();
    }

    private void validateExistChildren() {
        ArrayList<String> ruleIds = new ArrayList<String>(10);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String ruleId = (String)dataEntity.getDataEntity().getPkValue();
            ruleIds.add(ruleId);
        }
        HashSet<String> parentIds = new HashSet<String>();
        ORM orm = ORM.create();
        QFilter qFilter = new QFilter("parentid", "in", (Object)ruleIds.toArray(new String[0]));
        ExtendedDataEntity[] extendedDataEntityArray = null;
        try (DataSet ds = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "botp_writebackrule", "id, parentid", new QFilter[]{qFilter});){
            while (ds.hasNext()) {
                Row row = ds.next();
                String parentId = row.getString("parentid");
                parentIds.add(parentId);
            }
        }
        catch (Throwable object) {
            extendedDataEntityArray = object;
            throw object;
        }
        String errMsg_existChildren = ResManager.loadKDString((String)"\u5b58\u5728\u6269\u5c55\u6216\u7ee7\u627f\u7684\u5b50\u89c4\u5219\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"WriteBackRuleOpPlug_0", (String)"bos-botp-metadata", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String ruleId = (String)dataEntity.getDataEntity().getPkValue();
            if (!parentIds.contains(ruleId)) continue;
            this.addMessage(dataEntity, "", errMsg_existChildren, ErrorLevel.FatalError);
        }
    }

    private void validateISV() {
        String errMsg_isv = ResManager.loadKDString((String)"\u6b64\u529f\u80fd\u975e\u672c\u5f00\u53d1\u5546\u5f00\u53d1\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"WriteBackRuleOpPlug_1", (String)"bos-botp-metadata", (Object[])new Object[0]);
        String currentIsv = RuleIsvHelper.getUserIsv();
        boolean isKingdee = RuleIsvHelper.isKindeeIsv();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String isv = dataEntity.getDataEntity().getString("isv");
            if (isKingdee && StringUtils.isBlank((CharSequence)isv)) {
                isv = currentIsv;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)isv, (CharSequence)currentIsv)) continue;
            this.addMessage(dataEntity, "", errMsg_isv, ErrorLevel.FatalError);
        }
    }
}

