/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.botp;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.botp.WriteBackRuleCache;
import kd.bos.entity.botp.WriteBackRuleElement;
import kd.bos.entity.botp.WriteBackRuleElementSerializer;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.botp.DesignWriteBackRuleMeta;
import kd.bos.metadata.botp.WriteBackRuleMetadata;
import kd.bos.metadata.botp.WriteBackRuleReader;
import kd.bos.metadata.botp.WriteBackRuleVer;
import kd.bos.metadata.dao.MetadataWriter;

public class WriteBackRuleWriter {
    private static final int INITIAL_SIZE = 3;

    public static Map<String, Object> save(WriteBackRuleMetadata ruleMetadata) {
        WriteBackRuleWriter.setBizappId(ruleMetadata);
        WriteBackRuleWriter.updateVersion(ruleMetadata);
        WriteBackRuleWriter.clearCache();
        MetadataWriter writer = new MetadataWriter("WriteBackRuleModel");
        Map result = writer.save(new AbstractMetadata[]{ruleMetadata});
        return result;
    }

    public static Map<String, Object> delete(String[] ruleIds) {
        WriteBackRuleWriter.clearCache(ruleIds);
        IDataEntityType dType = OrmUtils.getDataEntityType(DesignWriteBackRuleMeta.class);
        BusinessDataWriter.delete((IDataEntityType)dType, (Object[])ruleIds);
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        result.put("success", true);
        result.put("message", ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"WriteBackRuleWriter_0", (String)"bos-botp-metadata", (Object[])new Object[0]));
        return result;
    }

    public static void updateInheritRuleVer(String parentRuleId) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FID ");
        sBuilder.append("FROM T_BOTP_WriteBackRule ");
        sBuilder.append("WHERE FParentId = ? and FType <> ? ");
        Object[] params = new SqlParameter[]{new SqlParameter(":FParentId", 12, (Object)parentRuleId), new SqlParameter(":FType", 1, (Object)"2")};
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> ids = new ArrayList<String>(10);
                while (rs.next()) {
                    String id = rs.getString("FID");
                    ids.add(id);
                }
                return ids;
            }
        };
        List ruleIds = (List)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
        if (ruleIds.isEmpty()) {
            return;
        }
        WriteBackRuleReader reader = new WriteBackRuleReader();
        for (String ruleId : ruleIds) {
            WriteBackRuleMetadata ruleMeta = reader.loadMeta(ruleId, false);
            WriteBackRuleWriter.save(ruleMeta);
        }
    }

    public static void clearCache(String[] ruleIds) {
        WriteBackRuleWriter.clearCache();
    }

    public static Long saveRuleVar(WriteBackRuleElement ruleElement) {
        long extVersion;
        long oriVersion;
        String ruleId = ruleElement.getId();
        Long cacheVerId = WriteBackRuleCache.loadRuleVerId((String)ruleId, (long)(oriVersion = ruleElement.getOriVersion()), (long)(extVersion = ruleElement.getExtVersion()));
        if (cacheVerId != null && Long.compare(cacheVerId, 0L) != 0) {
            return cacheVerId;
        }
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FVerId ");
        sBuilder.append("FROM T_BOTP_WriteBackRuleVer ");
        sBuilder.append("WHERE FRuleId = ? ");
        sBuilder.append("and FOriVersion = ? ");
        sBuilder.append("and FExtVersion = ? ");
        Object[] params = new SqlParameter[]{new SqlParameter(":FRuleId", 12, (Object)ruleId), new SqlParameter(":FOriVersion", -5, (Object)oriVersion), new SqlParameter(":FExtVersion", -5, (Object)extVersion)};
        ResultSetHandler<Long> action = new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                Long id = 0L;
                if (rs.next()) {
                    id = rs.getLong("FVerId");
                }
                return id;
            }
        };
        long verId = (Long)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
        if (verId == 0L) {
            WriteBackRuleVer ver = new WriteBackRuleVer();
            ver.setRuleId(ruleId);
            ver.setOriVersion(oriVersion);
            ver.setExtVersion(extVersion);
            String json = WriteBackRuleElementSerializer.serializeToString((WriteBackRuleElement)ruleElement, null);
            ver.setData(json);
            verId = DB.genGlobalLongId();
            ver.setVerId(verId);
            IDataEntityType dType = OrmUtils.getDataEntityType(WriteBackRuleVer.class);
            BusinessDataWriter.save((IDataEntityType)dType, (Object[])new Object[]{ver});
        }
        WriteBackRuleCache.cacheRuleVerId((String)ruleId, (long)oriVersion, (long)extVersion, (long)verId);
        return verId;
    }

    private static void setBizappId(final WriteBackRuleMetadata ruleMetadata) {
        if (StringUtils.isBlank((CharSequence)ruleMetadata.getBizappId())) {
            String sql = "SELECT FNumber, FSubsysId, FBizAppId FROM t_meta_entitydesign WHERE FNumber = ?";
            Object[] params = new SqlParameter[]{new SqlParameter(":FNumber", 12, (Object)ruleMetadata.getRuleElement().getTargetEntityNumber())};
            ResultSetHandler<Object> action = new ResultSetHandler<Object>(){

                public Object handle(ResultSet rs) throws Exception {
                    if (rs.next()) {
                        int subSysId = rs.getInt("FSubsysId");
                        String bizAppId = rs.getString("FBizAppId");
                        ruleMetadata.setSubSysId(subSysId);
                        ruleMetadata.setBizappId(bizAppId);
                    }
                    return null;
                }
            };
            DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
        }
    }

    private static void updateVersion(WriteBackRuleMetadata ruleMetadata) {
        long version = DB.genGlobalLongId();
        if (ruleMetadata.getDevType().equals("2")) {
            ruleMetadata.getRuleElement().setExtVersion(version);
        } else {
            ruleMetadata.getRuleElement().setOriVersion(version);
            WriteBackRuleWriter.updateInheritRuleVer(ruleMetadata.getId());
        }
    }

    private static void clearCache() {
        WriteBackRuleCache.clearAllRuleCache();
    }
}

