/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata.openapi;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.botp.ConvertRuleMetadata;
import kd.bos.metadata.botp.ConvertRuleReader;
import kd.bos.metadata.botp.WriteBackRuleMetadata;
import kd.bos.metadata.botp.WriteBackRuleReader;
import kd.bos.service.metadata.MultiLangMetadataLoad;

public class BotpMetaLReaderPlugin
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(MultiLangMetadataLoad.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String id = params.get("id").toString();
            int type = 0;
            if (params.get("type") != null) {
                type = Integer.parseInt(params.get("type").toString());
            }
            Map<String, Object> localeItems = this.readMeta(id, type);
            result.put("id", id);
            result.put("ver", Long.valueOf(System.currentTimeMillis()).toString());
            result.put("version", localeItems.get("version"));
            result.put("isv", localeItems.get("isv"));
            localeItems.remove("version");
            localeItems.remove("isv");
            result.put("localeData", localeItems);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u591a\u8bed\u8a00\u8bcd\u6761\u5931\u8d25: " + e.getMessage());
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u591a\u8bed\u8a00\u8bcd\u6761\u5931\u8d25%s", (String)"BotpMetaLReaderPlugin_0", (String)"bos-botp-metadata", (Object[])new Object[0]), e.getMessage()));
        }
        return ApiResult.success(result);
    }

    private Map<String, Object> readMeta(String id, int type) {
        List<Object> list = new ArrayList();
        HashMap<String, Object> result = new HashMap<String, Object>();
        switch (type) {
            case 0: {
                ConvertRuleMetadata cRuleMeta = this.readConvertRuleMeta(id);
                list = cRuleMeta.getLocaleItems();
                Date cVersion = cRuleMeta.getModifyDate();
                result.put("version", cVersion != null ? String.valueOf(cVersion.getTime()) : Long.valueOf(System.currentTimeMillis()));
                result.put("isv", cRuleMeta.getIsv());
                break;
            }
            case 1: {
                WriteBackRuleMetadata meta = this.readWriteBackRuleMeta(id);
                list = meta.getLocaleItems();
                long version = meta.getRuleElement().getOriVersion();
                result.put("version", String.valueOf(version));
                result.put("isv", meta.getIsv());
                break;
            }
        }
        if (list != null) {
            for (Map localeItemsMap : list) {
                for (Map.Entry entry : localeItemsMap.entrySet()) {
                    ILocaleValue localeitem = (ILocaleValue)entry.getValue();
                    result.put((String)entry.getKey(), (LocaleString)localeitem);
                }
            }
        }
        return result;
    }

    private ConvertRuleMetadata readConvertRuleMeta(String id) {
        ConvertRuleReader reader = new ConvertRuleReader();
        return reader.loadMeta(id, false);
    }

    private WriteBackRuleMetadata readWriteBackRuleMeta(String id) {
        WriteBackRuleReader reader = new WriteBackRuleReader();
        return reader.loadMeta(id, false);
    }
}

