/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.ctbotp;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.ctbotp.CtConvertRuleCache;
import kd.bos.entity.ctbotp.CtConvertRuleElement;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.ctbotp.CtConvertRuleMetadata;
import kd.bos.metadata.ctbotp.CtConvertRuleTemplate;
import kd.bos.metadata.ctbotp.DesignCtConvertRuleMeta;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CtConvertRuleReader {
    private static final Log log = LogFactory.getLog(CtConvertRuleCache.class);
    private static final String BOS_CTBOTP_METADATA = "bos-ctbotp-metadata";
    private static String KEY_BOS_CTBOTP_TENANTPATH = "bos_ctbotp_tenantpath";
    private static String CTSY_TENANT = "ctsy_tenant";
    private static String KEY_NUMBER = "number";

    public CtConvertRuleMetadata loadMeta(String id, boolean runtime) {
        return this.loadMeta(id, runtime, false);
    }

    public List<CtConvertRuleMetadata> batchLoadMeta(String[] ids, boolean runtime) {
        ArrayList<CtConvertRuleMetadata> ruleMetaDatas = new ArrayList<CtConvertRuleMetadata>(16);
        for (String id : ids) {
            CtConvertRuleMetadata metadata = this.loadMeta(id, runtime);
            if (metadata == null) continue;
            ruleMetaDatas.add(metadata);
        }
        return ruleMetaDatas;
    }

    public CtConvertRuleMetadata loadMeta(String id, boolean runtime, boolean isBaseMeta) {
        IDataEntityType designerMetaType = OrmUtils.getDataEntityType(DesignCtConvertRuleMeta.class);
        AbstractMetadata meta = this.readRuleMetadata(id, designerMetaType, runtime, isBaseMeta);
        return (CtConvertRuleMetadata)meta;
    }

    public List<CtConvertRuleMetadata> loadMetas(String sourceTenant, String sourceDataCenter, String sourceEntityNumber, String targetTenant, String targetDataCenter, String targetEntityNumber) {
        IDataEntityType designerMetaType = OrmUtils.getDataEntityType(DesignCtConvertRuleMeta.class);
        List<String> ruleIds = this.loadRuleIds(sourceTenant, sourceDataCenter, sourceEntityNumber, targetTenant, targetDataCenter, targetEntityNumber, false);
        ArrayList<CtConvertRuleMetadata> ruleMetadatas = new ArrayList<CtConvertRuleMetadata>();
        for (String ruleId : ruleIds) {
            try {
                AbstractMetadata metadata = this.readRuleMetadata(ruleId, designerMetaType, false, false);
                ruleMetadatas.add((CtConvertRuleMetadata)metadata);
            }
            catch (KDException exp) {
                log.error((Throwable)exp);
            }
        }
        return ruleMetadatas;
    }

    public List<CtConvertRuleMetadata> loadMetas(String sourceEntityNumber, String targetEntityNumber) {
        IDataEntityType designerMetaType = OrmUtils.getDataEntityType(DesignCtConvertRuleMeta.class);
        List<String> ruleIds = this.loadRuleIds(sourceEntityNumber, targetEntityNumber, false);
        ArrayList<CtConvertRuleMetadata> ruleMetadatas = new ArrayList<CtConvertRuleMetadata>();
        for (String ruleId : ruleIds) {
            try {
                AbstractMetadata metadata = this.readRuleMetadata(ruleId, designerMetaType, false, false);
                ruleMetadatas.add((CtConvertRuleMetadata)metadata);
            }
            catch (KDException exp) {
                log.error((Throwable)exp);
            }
        }
        return ruleMetadatas;
    }

    public List<CtConvertRuleElement> loadRules(String sourceTenant, String sourceDataCenter, String sourceEntityNumber, String targetTenant, String targetDataCenter, String targetEntityNumber) {
        IDataEntityType designerMetaType = OrmUtils.getDataEntityType(DesignCtConvertRuleMeta.class);
        List<String> ruleIds = this.loadRuleIds(sourceTenant, sourceDataCenter, sourceEntityNumber, targetTenant, targetDataCenter, targetEntityNumber, true);
        ArrayList<CtConvertRuleElement> rules = new ArrayList<CtConvertRuleElement>(10);
        for (String ruleId : ruleIds) {
            CtConvertRuleMetadata metadata = (CtConvertRuleMetadata)this.readRuleMetadata(ruleId, designerMetaType, true, false);
            if (metadata == null) continue;
            rules.add(metadata.getRuleElement());
        }
        return rules;
    }

    public List<String> loadRuleIds(String sourceTenant, String sourceDataCenter, String sourceEntityNumber, String targetTenant, String targetDataCenter, String targetEntityNumber, boolean runtime) {
        String tenantPathNumber = CtConvertRuleReader.getTenantPathNumber(sourceTenant, sourceDataCenter, targetTenant, targetDataCenter);
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT a.FId ");
        sBuilder.append("FROM ").append(this.getGrayTableName("T_CTBOTP_ConvertRule a "));
        sBuilder.append("LEFT JOIN ").append(this.getGrayTableName("T_CTBOTP_ConvertRule_S s "));
        sBuilder.append("ON ").append("a.fid =s.fid");
        sBuilder.append(" WHERE a.FSourceEntityNumber = ? and a.FTargetEntityNumber = ? ");
        sBuilder.append(" and s.FTenantPath = ? ");
        if (runtime) {
            sBuilder.append("and a.FType <> '2'");
        }
        Object[] params = new SqlParameter[]{new SqlParameter(":FSourceEntityNumber", 12, (Object)sourceEntityNumber), new SqlParameter(":FTargetEntityNumber", 12, (Object)targetEntityNumber), new SqlParameter(":FTenantPath", 12, (Object)tenantPathNumber)};
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> ids = new ArrayList<String>(10);
                while (rs.next()) {
                    String id = rs.getString("FId");
                    ids.add(id);
                }
                return ids;
            }
        };
        List ruleIds = (List)DB.query((DBRoute)DBRoute.base, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
        if (ruleIds.isEmpty() && AppGroupUtils.isGrayGroup()) {
            sBuilder = new StringBuilder();
            sBuilder.append("SELECT a.FId ");
            sBuilder.append("FROM  ").append("T_CTBOTP_ConvertRule a ");
            sBuilder.append("LEFT JOIN ").append("T_CTBOTP_ConvertRule_S s ");
            sBuilder.append("ON ").append("a.fid =s.fid");
            sBuilder.append(" WHERE a.FSourceEntityNumber = ? and a.FTargetEntityNumber = ? ");
            sBuilder.append(" and s.FTenantPath = ? ");
            if (runtime) {
                sBuilder.append("and a.FType <> '2'");
            }
            ruleIds = (List)DB.query((DBRoute)DBRoute.base, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
        }
        return ruleIds;
    }

    public List<String> loadRuleIds(String sourceEntityNumber, String targetEntityNumber, boolean runtime) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT a.FId ");
        sBuilder.append("FROM ").append(this.getGrayTableName("T_CTBOTP_ConvertRule a "));
        sBuilder.append(" WHERE a.FSourceEntityNumber = ? and a.FTargetEntityNumber = ? ");
        if (runtime) {
            sBuilder.append("and a.FType <> '2'");
        }
        Object[] params = new SqlParameter[]{new SqlParameter(":FSourceEntityNumber", 12, (Object)sourceEntityNumber), new SqlParameter(":FTargetEntityNumber", 12, (Object)targetEntityNumber)};
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> ids = new ArrayList<String>(10);
                while (rs.next()) {
                    String id = rs.getString("FId");
                    ids.add(id);
                }
                return ids;
            }
        };
        List ruleIds = (List)DB.query((DBRoute)DBRoute.base, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
        if (ruleIds.isEmpty() && AppGroupUtils.isGrayGroup()) {
            sBuilder = new StringBuilder();
            sBuilder.append("SELECT a.FId ");
            sBuilder.append("FROM  ").append("T_CTBOTP_ConvertRule a ");
            sBuilder.append(" WHERE a.FSourceEntityNumber = ? and a.FTargetEntityNumber = ? ");
            if (runtime) {
                sBuilder.append("and a.FType <> '2'");
            }
            ruleIds = (List)DB.query((DBRoute)DBRoute.base, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
        }
        return ruleIds;
    }

    public String buildXml(String ruleId, boolean runtime, boolean onlyLocaleValue) {
        String xmlData = "";
        CtConvertRuleMetadata convertRuleMetadata = this.loadMeta(ruleId, runtime);
        if (convertRuleMetadata != null) {
            CtConvertRuleTemplate template = new CtConvertRuleTemplate();
            xmlData = template.buildDiffXml(convertRuleMetadata, null, onlyLocaleValue);
        }
        return xmlData;
    }

    private AbstractMetadata readRuleMetadata(String id, IDataEntityType designerMetaType, boolean runtime, boolean isBaseMeta) {
        MetadataReader reader = this.createMetaReader();
        AbstractMetadata meta = reader.readMeta(id, designerMetaType, runtime, isBaseMeta);
        if (meta == null && AppGroupUtils.isGrayGroup()) {
            reader = new MetadataReader();
            meta = reader.readMeta(id, designerMetaType, runtime, isBaseMeta);
        }
        return meta;
    }

    protected String getGrayTableName(String tabName) {
        if (!AppGroupUtils.isGrayGroup()) {
            return tabName;
        }
        return String.format("%s_%s", tabName, AppGroupUtils.getCurrentAppGroup());
    }

    private MetadataReader createMetaReader() {
        MetadataReader reader = new MetadataReader();
        reader.setColloctionIgnorePKValue(true);
        reader.setAppGroup(AppGroupUtils.getCurrentAppGroup());
        return reader;
    }

    private static String getTenantPathNumber(String sourceTenantId, String sourceAccountId, String targetTenantId, String targetAccountId) {
        DynamicObject sourceTenant = CtConvertRuleReader.getTenantInfoById(sourceTenantId, sourceAccountId);
        DynamicObject targetTenant = CtConvertRuleReader.getTenantInfoById(targetTenantId, targetAccountId);
        QFilter[] filter = new QFilter[]{new QFilter("sourcetenant", "=", sourceTenant.getPkValue()), new QFilter("targettenant", "=", targetTenant.getPkValue())};
        DynamicObject tenantPath = BusinessDataServiceHelper.loadSingleFromCache((String)KEY_BOS_CTBOTP_TENANTPATH, (QFilter[])filter);
        String number = "";
        if (tenantPath == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6e90\u79df\u6237:%1$s\uff0c\u76ee\u6807\u79df\u6237:%2$s\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u79df\u6237\u8def\u7ebf\u3002", (String)"CtConvertRuleReader_0", (String)BOS_CTBOTP_METADATA, (Object[])new Object[0]), sourceTenantId, targetTenantId));
        }
        number = tenantPath.getString(KEY_NUMBER);
        return number;
    }

    private static DynamicObject getTenantInfoById(String tenantId, String accountId) {
        DynamicObject tenant = BusinessDataServiceHelper.loadSingle((String)CTSY_TENANT, (QFilter[])new QFilter[]{new QFilter("tenantid", "=", (Object)tenantId), new QFilter("accountid", "=", (Object)accountId)});
        return tenant;
    }
}

