/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp;

import java.util.List;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.ISupportInitialize;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.CheckPoint;
import kd.bos.entity.botp.CheckResult;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.formula.FormulaEngine;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class CRCondition
extends CRFormula
implements ISupportInitialize {
    private transient boolean _isInitialize;
    private FilterCondition filterCondition;
    private String filterString;
    private boolean enabled = true;
    private String id;
    private int seq;

    @ComplexPropertyAttribute
    @KSMethod
    public FilterCondition getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(FilterCondition newFilterCondition) {
        if (this.filterCondition == null || newFilterCondition == null) {
            this.filterCondition = newFilterCondition;
        } else {
            int rowIndex = 0;
            List srcRows = newFilterCondition.getFilterRow();
            List targetRows = this.filterCondition.getFilterRow();
            for (SimpleFilterRow srcRow : srcRows) {
                if (rowIndex + 1 > targetRows.size()) {
                    targetRows.add(srcRow);
                } else {
                    SimpleFilterRow targetRow = (SimpleFilterRow)targetRows.get(rowIndex);
                    targetRow.setCompareType(srcRow.getCompareType());
                    targetRow.setCompareTypeDesc(srcRow.getCompareTypeDesc());
                    targetRow.setEntityNumber(srcRow.getEntityNumber());
                    targetRow.setFieldName(srcRow.getFieldName());
                    targetRow.setLeftBracket(srcRow.getLeftBracket());
                    targetRow.setLogic(srcRow.getLogic());
                    targetRow.setRightBracket(srcRow.getRightBracket());
                    this.mergeValues(targetRow.getValue(), srcRow.getValue());
                    this.mergeValues(targetRow.getBaseDataIds(), srcRow.getBaseDataIds());
                }
                ++rowIndex;
            }
            for (int i = targetRows.size() - 1; i >= rowIndex; --i) {
                targetRows.remove(i);
            }
        }
    }

    private void mergeValues(List<FilterValue> targetValues, List<FilterValue> srcValues) {
        if (srcValues == null || srcValues.isEmpty()) {
            targetValues.clear();
        } else {
            int valIndex = 0;
            for (FilterValue srcValue : srcValues) {
                if (valIndex + 1 > targetValues.size()) {
                    targetValues.add(srcValue);
                } else {
                    targetValues.get(valIndex).setValue(srcValue.getValue());
                }
                ++valIndex;
            }
            for (int i = targetValues.size() - 1; i >= valIndex; --i) {
                targetValues.remove(i);
            }
        }
    }

    @KSMethod
    @SimplePropertyAttribute
    public String getFilterString() {
        if (this.filterCondition == null) {
            return SerializationUtils.toJsonString((Object)new FilterCondition());
        }
        return SerializationUtils.toJsonString((Object)this.getFilterCondition());
    }

    @KSMethod
    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    @SimplePropertyAttribute(name="Enabled")
    @DefaultValueAttribute(value="true")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @SimplePropertyAttribute(isPrimaryKey=true)
    @KSMethod
    public String getId() {
        if (StringUtils.isBlank((CharSequence)this.id)) {
            this.id = Uuid16.create().toString();
        }
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    @SimplePropertyAttribute
    @KSMethod
    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public String buildFullFormula(MainEntityType mainType) {
        return this.buildFullFormula(mainType, null, null);
    }

    public String buildFullFormula(MainEntityType mainType, IUserService userService, ITimeService timeService) {
        String gridFormula = "";
        String handFormula = this.getExpression();
        if (this.filterCondition != null && this.filterCondition.getFilterRow().size() > 0) {
            FilterBuilder filterBuilder = new FilterBuilder(mainType, this.filterCondition);
            if (userService != null) {
                filterBuilder.setUserService(userService);
            }
            if (timeService == null) {
                filterBuilder.setTimeService((ITimeService)new TimeService());
            } else {
                filterBuilder.setTimeService(timeService);
            }
            String[] filterScripts = filterBuilder.buildFilterScript();
            gridFormula = filterScripts[0];
        }
        String fullFormula = this.joinFilter(gridFormula, handFormula);
        return fullFormula;
    }

    private String joinFilter(String filter1, String filter2) {
        if (StringUtils.isBlank((CharSequence)filter1)) {
            return filter2;
        }
        if (StringUtils.isBlank((CharSequence)filter2)) {
            return filter1;
        }
        return String.format("(%s) and (%s)", filter1, filter2);
    }

    public void check(MainEntityType mainType, CheckPoint checkPoint, CheckResult checkResult) {
        String[] vars;
        String fullExp = this.buildFullFormula(mainType);
        if (StringUtils.isBlank((CharSequence)fullExp)) {
            return;
        }
        for (String var : vars = FormulaEngine.extractVariables((String)fullExp)) {
            if (RowDataModel.findProperty((MainEntityType)mainType, (String)var) != null) continue;
            String errMessage = String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u5305\u542b\u4e86\u672a\u77e5\u53d8\u91cf[%s]", (String)"CRCondition_0", (String)"bos-botp-core", (Object[])new Object[0]), var);
            checkResult.addErrorMessage(checkPoint, errMessage);
        }
    }

    public void beginInit() {
        this._isInitialize = true;
    }

    public void endInit() {
        if (StringUtils.isNotBlank((CharSequence)this.filterString)) {
            this.filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)this.filterString, FilterCondition.class);
        }
        this.filterString = null;
        this._isInitialize = false;
    }

    public boolean isInitialized() {
        return this._isInitialize;
    }
}

