/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.AttachmentPanelMapPolicy;
import kd.bos.entity.botp.BillTypeMapPolicy;
import kd.bos.entity.botp.BizRulePolicy;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CheckPoint;
import kd.bos.entity.botp.CheckResult;
import kd.bos.entity.botp.FieldMapPolicy;
import kd.bos.entity.botp.FilterPolicy;
import kd.bos.entity.botp.GroupByPolicy;
import kd.bos.entity.botp.LinkEntityPolicy;
import kd.bos.entity.botp.OptionPolicy;
import kd.bos.entity.botp.PlugInPolicy;
import kd.bos.entity.botp.extcontrol.ExtControlElement;
import kd.bos.entity.botp.extcontrol.ExtControlParam;
import kd.bos.entity.botp.extcontrol.enums.ExtControlModelEnum;
import kd.bos.exception.KDBizException;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class ConvertRuleElement {
    private static final String BOS_ENTITY_CORE = "bos-botp-core";
    private String id;
    private LocaleString name;
    private String sourceEntityNumber;
    private String targetEntityNumber;
    private String sysStatus = "0";
    private static final String SYSSTATUS_NORMUAL = "1";
    private boolean enabled = true;
    private boolean defRule = true;
    private boolean visibled = true;
    private boolean visibledCtrl = false;
    private boolean drawVisibled = true;
    private CRCondition runCondition;
    private LinkEntityPolicy linkEntityPolicy;
    private FieldMapPolicy fieldMapPolicy;
    private FilterPolicy filterPolicy;
    private GroupByPolicy groupByPolicy;
    private PlugInPolicy plugInPolicy;
    private BizRulePolicy bizRulePolicy;
    private BillTypeMapPolicy billTypeMapPolicy;
    private AttachmentPanelMapPolicy attachmentPanelMapPolicy;
    private OptionPolicy optionPolicy = new OptionPolicy();
    private List<ExtControlElement> extElements = new ArrayList<ExtControlElement>(10);
    private boolean autoSave = false;
    private boolean billPush = false;
    private transient long checkVersionTimeMillis;
    private String cacheVersion;

    public ConvertRuleElement() {
        this.linkEntityPolicy = new LinkEntityPolicy();
        this.fieldMapPolicy = new FieldMapPolicy();
        this.filterPolicy = new FilterPolicy();
        this.groupByPolicy = new GroupByPolicy();
        this.plugInPolicy = new PlugInPolicy();
        this.bizRulePolicy = new BizRulePolicy();
        this.billTypeMapPolicy = new BillTypeMapPolicy();
        this.attachmentPanelMapPolicy = new AttachmentPanelMapPolicy();
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=ExtControlElement.class, displayName="ExtElement")
    public List<ExtControlElement> getExtElements() {
        return this.extElements;
    }

    public void setExtElements(List<ExtControlElement> extElements) {
        this.extElements = extElements;
    }

    @SimplePropertyAttribute(isPrimaryKey=true)
    @KSMethod
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @SimplePropertyAttribute
    @KSMethod
    public LocaleString getName() {
        return this.name;
    }

    public void setName(LocaleString name) {
        this.name = name;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getSourceEntityNumber() {
        return this.sourceEntityNumber;
    }

    public void setSourceEntityNumber(String sourceEntityNumber) {
        this.sourceEntityNumber = sourceEntityNumber;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getTargetEntityNumber() {
        return this.targetEntityNumber;
    }

    public void setTargetEntityNumber(String targetEntityNumber) {
        this.targetEntityNumber = targetEntityNumber;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getSysStatus() {
        return this.sysStatus;
    }

    public void setSysStatus(String sysStatus) {
        this.sysStatus = sysStatus;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="true")
    @KSMethod
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @KSMethod
    public boolean isNormual() {
        return !SYSSTATUS_NORMUAL.equals(this.sysStatus) && this.enabled;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="true")
    @KSMethod
    public boolean isDefRule() {
        return this.defRule;
    }

    public void setDefRule(boolean defRule) {
        this.defRule = defRule;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="true")
    @KSMethod
    public boolean isVisibled() {
        return this.visibled;
    }

    public void setVisibled(boolean visibled) {
        this.visibled = visibled;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="false")
    @KSMethod
    public boolean isVisibledCtrl() {
        return this.visibledCtrl;
    }

    public void setVisibledCtrl(boolean visibledCtrl) {
        this.visibledCtrl = visibledCtrl;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="true")
    @KSMethod
    public boolean isDrawVisibled() {
        return this.drawVisibled;
    }

    public void setDrawVisibled(boolean drawVisibled) {
        this.drawVisibled = drawVisibled;
    }

    @ComplexPropertyAttribute
    @KSMethod
    public CRCondition getRunCondition() {
        return this.runCondition;
    }

    public void setRunCondition(CRCondition runCondition) {
        this.runCondition = runCondition;
    }

    @ComplexPropertyAttribute
    @KSMethod
    public LinkEntityPolicy getLinkEntityPolicy() {
        return this.linkEntityPolicy;
    }

    public void setLinkEntityPolicy(LinkEntityPolicy linkEntityPolicy) {
        this.linkEntityPolicy = linkEntityPolicy;
    }

    @ComplexPropertyAttribute
    @KSMethod
    public FieldMapPolicy getFieldMapPolicy() {
        return this.fieldMapPolicy;
    }

    public void setFieldMapPolicy(FieldMapPolicy fieldMapPolicy) {
        this.fieldMapPolicy = fieldMapPolicy;
    }

    @ComplexPropertyAttribute
    @KSMethod
    public FilterPolicy getFilterPolicy() {
        return this.filterPolicy;
    }

    public void setFilterPolicy(FilterPolicy filterPolicy) {
        this.filterPolicy = filterPolicy;
    }

    @ComplexPropertyAttribute
    @KSMethod
    public GroupByPolicy getGroupByPolicy() {
        return this.groupByPolicy;
    }

    public void setGroupByPolicy(GroupByPolicy groupByPolicy) {
        this.groupByPolicy = groupByPolicy;
    }

    @ComplexPropertyAttribute
    @KSMethod
    public PlugInPolicy getPlugInPolicy() {
        return this.plugInPolicy;
    }

    public void setPlugInPolicy(PlugInPolicy plugInPolicy) {
        this.plugInPolicy = plugInPolicy;
    }

    @ComplexPropertyAttribute
    @KSMethod
    public BizRulePolicy getBizRulePolicy() {
        return this.bizRulePolicy;
    }

    public void setBizRulePolicy(BizRulePolicy bizRulePolicy) {
        this.bizRulePolicy = bizRulePolicy;
    }

    @ComplexPropertyAttribute
    @KSMethod
    public BillTypeMapPolicy getBillTypeMapPolicy() {
        return this.billTypeMapPolicy;
    }

    public void setBillTypeMapPolicy(BillTypeMapPolicy billTypeMapPolicy) {
        this.billTypeMapPolicy = billTypeMapPolicy;
    }

    @ComplexPropertyAttribute
    @KSMethod
    public AttachmentPanelMapPolicy getAttachmentPanelMapPolicy() {
        return this.attachmentPanelMapPolicy;
    }

    public void setAttachmentPanelMapPolicy(AttachmentPanelMapPolicy attachmentPanelMapPolicy) {
        this.attachmentPanelMapPolicy = attachmentPanelMapPolicy;
    }

    @ComplexPropertyAttribute
    @KSMethod
    public OptionPolicy getOptionPolicy() {
        return this.optionPolicy;
    }

    public void setOptionPolicy(OptionPolicy optionPolicy) {
        this.optionPolicy = optionPolicy;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="false")
    @KSMethod
    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="false")
    @KSMethod
    public boolean isBillPush() {
        return this.billPush;
    }

    public void setBillPush(boolean billPush) {
        this.billPush = billPush;
    }

    public String getCacheVersion() {
        return this.cacheVersion;
    }

    public void setCacheVersion(String cacheVersion) {
        this.cacheVersion = cacheVersion;
    }

    public long getCheckVersionTimeMillis() {
        return this.checkVersionTimeMillis;
    }

    public void setCheckVersionTimeMillis(long checkVersionTimeMillis) {
        this.checkVersionTimeMillis = checkVersionTimeMillis;
    }

    public boolean check(CheckPoint parentPoint, CheckResult checkResult, Map<Integer, ExtControlElement> elementMap) {
        CheckPoint checkPoint = new CheckPoint(parentPoint, StringUtils.isBlank((CharSequence)this.getName().getLocaleValue()) ? this.getId() : this.getName().getLocaleValue());
        CheckPoint baseInfoCheckPoint = new CheckPoint(checkPoint, ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"ConvertRuleElement_0", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
        MainEntityType srcMainType = null;
        MainEntityType tgtMainType = null;
        if (StringUtils.isBlank((CharSequence)this.getSourceEntityNumber())) {
            this.addErrorMessage(baseInfoCheckPoint, checkResult, ResManager.loadKDString((String)"\u8f6c\u6362\u6e90\u5355\u4e0d\u80fd\u4e3a\u7a7a", (String)"ConvertRuleElement_1", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
        } else {
            srcMainType = EntityMetadataCache.getDataEntityType((String)this.getSourceEntityNumber());
            if (srcMainType == null) {
                this.addErrorMessage(baseInfoCheckPoint, checkResult, ResManager.loadKDString((String)"\u8f6c\u6362\u6e90\u5355\u5df2\u7ecf\u4e0d\u5b58\u5728\u4e86", (String)"ConvertRuleElement_2", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
            }
        }
        if (StringUtils.isBlank((CharSequence)this.getTargetEntityNumber())) {
            this.addErrorMessage(baseInfoCheckPoint, checkResult, ResManager.loadKDString((String)"\u8f6c\u6362\u76ee\u6807\u5355\u4e0d\u80fd\u4e3a\u7a7a", (String)"ConvertRuleElement_3", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
        } else {
            tgtMainType = EntityMetadataCache.getDataEntityType((String)this.getTargetEntityNumber());
            if (tgtMainType == null) {
                this.addErrorMessage(baseInfoCheckPoint, checkResult, ResManager.loadKDString((String)"\u8f6c\u6362\u76ee\u6807\u5355\u5df2\u7ecf\u4e0d\u5b58\u5728\u4e86", (String)"ConvertRuleElement_4", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
            }
        }
        if (srcMainType == null || tgtMainType == null) {
            return false;
        }
        ExtControlElement extControlElement = elementMap.get(ExtControlModelEnum.BASE_INFO.getType());
        if (extControlElement != null) {
            for (ExtControlParam.Param param : extControlElement.getExtControlParam().getParams()) {
                switch (param.getKey()) {
                    case "frunconditiondesc": {
                        if (this.runCondition != null) break;
                        this.addErrorMessage(baseInfoCheckPoint, checkResult, ResManager.loadKDString((String)"\u89c4\u5219\u542f\u7528\u6761\u4ef6\u51fa\u5382\u8bbe\u7f6e\u5fc5\u5f55\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ConvertRuleElement_8", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
                        break;
                    }
                    case "fvisibled": {
                        if (this.visibled) break;
                        this.addErrorMessage(baseInfoCheckPoint, checkResult, ResManager.loadKDString((String)"\u8fd0\u884c\u65f6\u53ef\u89c1\u51fa\u5382\u8bbe\u7f6e\u5fc5\u9700\u5f00\u542f\u3002", (String)"ConvertRuleElement_9", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
                        break;
                    }
                    case "fvisibledctrl": {
                        if (this.visibledCtrl) break;
                        this.addErrorMessage(baseInfoCheckPoint, checkResult, ResManager.loadKDString((String)"\u8fd0\u884c\u65f6\u53ef\u89c1\u63a7\u5236\u51fa\u5382\u8bbe\u7f6e\u5fc5\u9700\u5f00\u542f\u3002", (String)"ConvertRuleElement_10", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
                        break;
                    }
                    case "fdrawvisibled": {
                        if (this.drawVisibled) break;
                        this.addErrorMessage(baseInfoCheckPoint, checkResult, ResManager.loadKDString((String)"\u8fd0\u884c\u65f6\u9009\u5355\u53ef\u89c1\u51fa\u5382\u8bbe\u7f6e\u5fc5\u9700\u5f00\u542f\u3002", (String)"ConvertRuleElement_11", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
                        break;
                    }
                    case "fautosave": {
                        if (this.autoSave) break;
                        this.addErrorMessage(baseInfoCheckPoint, checkResult, ResManager.loadKDString((String)"\u4e0b\u63a8\u81ea\u52a8\u4fdd\u5b58\u51fa\u5382\u8bbe\u7f6e\u5fc5\u9700\u5f00\u542f\u3002", (String)"ConvertRuleElement_12", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
                        break;
                    }
                    case "fbillpush": {
                        if (this.billPush) break;
                        this.addErrorMessage(baseInfoCheckPoint, checkResult, ResManager.loadKDString((String)"\u6574\u5355\u4e0b\u63a8\u51fa\u5382\u8bbe\u7f6e\u5fc5\u9700\u5f00\u542f\u3002", (String)"ConvertRuleElement_13", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
                    }
                }
            }
        }
        this.checkMustInput(srcMainType, tgtMainType, baseInfoCheckPoint, checkResult);
        this.checkPolicys(srcMainType, tgtMainType, checkPoint, checkResult, elementMap);
        return checkResult.isPass();
    }

    private void checkMustInput(MainEntityType srcMainType, MainEntityType tgtMainType, CheckPoint checkPoint, CheckResult checkResult) {
        block7: {
            if (StringUtils.isBlank((CharSequence)this.getId())) {
                this.addErrorMessage(checkPoint, checkResult, ResManager.loadKDString((String)"\u89c4\u5219\u6807\u8bc6(id)\u4e0d\u80fd\u4e3a\u7a7a", (String)"ConvertRuleElement_5", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
            }
            if (this.getName() == null || StringUtils.isBlank((CharSequence)this.getName().toString())) {
                this.addErrorMessage(checkPoint, checkResult, ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0(name)\u4e0d\u80fd\u4e3a\u7a7a", (String)"ConvertRuleElement_6", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)this.getSourceEntityNumber())) {
                this.addErrorMessage(checkPoint, checkResult, ResManager.loadKDString((String)"\u8f6c\u6362\u6e90\u5355\u4e0d\u80fd\u4e3a\u7a7a", (String)"ConvertRuleElement_1", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)this.getTargetEntityNumber())) {
                this.addErrorMessage(checkPoint, checkResult, ResManager.loadKDString((String)"\u8f6c\u6362\u76ee\u6807\u5355\u4e0d\u80fd\u4e3a\u7a7a", (String)"ConvertRuleElement_3", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
            }
            if (this.getRunCondition() != null) {
                CheckPoint runCondCheckPoint = new CheckPoint(checkPoint, ResManager.loadKDString((String)"\u4e1a\u52a1\u5206\u7c7b\u6761\u4ef6", (String)"ConvertRuleElement_7", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
                try {
                    this.getRunCondition().check(srcMainType, runCondCheckPoint, checkResult);
                }
                catch (KDBizException exp) {
                    if (!exp.getErrorCode().getCode().equals("bos.fieldNotExist")) break block7;
                    checkResult.addErrorMessage(runCondCheckPoint, String.format(ResManager.loadKDString((String)"\u5b9e\u4f53[%1$s]\u8f6c\u6362\u89c4\u5219[%2$s]\u914d\u7f6e\u6709\u8bef\uff1a[%3$s]\u4e2d\u7684\u5b57\u6bb5[%4$s]\uff0c\u5728\u6e90\u5355\u4e0a\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u8f6c\u6362\u89c4\u5219", (String)"FieldNotExist_0", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), this.getSourceEntityNumber(), this.getName(), runCondCheckPoint.fullPoint, exp.getArgs().length > 1 ? exp.getArgs()[1].toString().split("\uff0c")[0] : ""));
                }
            }
        }
    }

    private void checkPolicys(MainEntityType srcMainType, MainEntityType tgtMainType, CheckPoint checkPoint, CheckResult checkResult, Map<Integer, ExtControlElement> elementMap) {
        this.linkEntityPolicy.check(srcMainType, tgtMainType, this, checkPoint, checkResult, elementMap);
        this.billTypeMapPolicy.check(srcMainType, tgtMainType, this, checkPoint, checkResult, elementMap);
        this.fieldMapPolicy.check(srcMainType, tgtMainType, this, checkPoint, checkResult, elementMap);
        this.attachmentPanelMapPolicy.check(srcMainType, tgtMainType, this, checkPoint, checkResult, elementMap);
        this.filterPolicy.check(srcMainType, tgtMainType, this, checkPoint, checkResult, elementMap);
        this.groupByPolicy.check(srcMainType, tgtMainType, this, checkPoint, checkResult, elementMap);
        this.bizRulePolicy.check(srcMainType, tgtMainType, this, checkPoint, checkResult, elementMap);
        this.plugInPolicy.check(srcMainType, tgtMainType, this, checkPoint, checkResult, elementMap);
        this.optionPolicy.check(srcMainType, tgtMainType, this, checkPoint, checkResult, elementMap);
    }

    private void addErrorMessage(CheckPoint checkPoint, CheckResult checkResult, String errMessage) {
        checkResult.addErrorMessage(checkPoint, errMessage);
    }
}

