/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;

class ConvertRuleLocalCache {
    private static final String TYPE_CR_RULE = "cr_rule_";
    public static final long CHECK_VERSION_TIME_MILLIS = 10000L;
    public static final long TIME_OUT_MILLIS = 600000L;
    private static final CacheConfigInfo info = new CacheConfigInfo();

    ConvertRuleLocalCache() {
    }

    private static LocalMemoryCache getLocalCache() {
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "ConvertRuleLocalCache", info);
    }

    public static void clearAllConvertRuleCache() {
        ConvertRuleLocalCache.getLocalCache().clear();
    }

    public static ConvertRuleElement getConvertRule(String ruleId) {
        String cacheKey = ConvertRuleLocalCache.makeCacheKey(TYPE_CR_RULE, ruleId);
        return (ConvertRuleElement)ConvertRuleLocalCache.getLocalCache().get(cacheKey);
    }

    public static Map<String, ConvertRuleElement> getConvertRules(String ... ruleIds) {
        if (ruleIds.length == 0) {
            return new HashMap<String, ConvertRuleElement>(16);
        }
        ArrayList<String> cacheKeys = new ArrayList<String>(10);
        for (String ruleId : ruleIds) {
            cacheKeys.add(ConvertRuleLocalCache.makeCacheKey(TYPE_CR_RULE, ruleId));
        }
        Map map = ConvertRuleLocalCache.getLocalCache().get(cacheKeys.toArray(new String[0]));
        HashMap<String, ConvertRuleElement> map2 = new HashMap<String, ConvertRuleElement>(16);
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            ConvertRuleElement rule = (ConvertRuleElement)entry.getValue();
            map2.put(rule.getId(), rule);
        }
        return map2;
    }

    public static void putConvertRule(String ruleId, ConvertRuleElement rule) {
        String cacheKey = ConvertRuleLocalCache.makeCacheKey(TYPE_CR_RULE, ruleId);
        ConvertRuleLocalCache.getLocalCache().put(cacheKey, (Object)rule);
    }

    public static void removeConverRule(String ruleId) {
        String cacheKey = ConvertRuleLocalCache.makeCacheKey(TYPE_CR_RULE, ruleId);
        ConvertRuleLocalCache.getLocalCache().remove(new String[]{ruleId});
    }

    private static String makeCacheKey(String type, String key) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        if (StringUtils.isNotBlank((CharSequence)appGroup) && !"defaultGroup".equals(appGroup)) {
            return String.format("%s.%s.%s", appGroup, key, type).toLowerCase();
        }
        return String.format("%s.%s", key, type).toLowerCase();
    }

    static {
        info.setTimeout(43200);
        info.setMaxMemSize(10000);
    }
}

