/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.ISupportInitialize;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.CRValByCondition;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.botp.CheckPoint;
import kd.bos.entity.botp.CheckResult;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.FieldConvertType;
import kd.bos.entity.botp.FieldSumType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class FieldMapItem
implements ISupportInitialize {
    private static final String BOS_ENTITY_CORE = "bos-botp-core";
    private String targetFieldKey;
    private FieldConvertType fieldConvertType = FieldConvertType.SourceField;
    private FieldSumType fieldSumType = FieldSumType.First;
    private String convertType2;
    private transient boolean _isInitialize;
    private String sourceFieldKey;
    private CRFormula formula;
    private CRValByConditions valByConditions;
    private CRFormula constant;
    private String valByCondiionsString;
    private boolean drawFilter;
    private boolean drawAgainFilter;
    private boolean breakForNoDistribute;
    private boolean onlyTakeApprovedData;
    private boolean onlyTakeUsedData;

    public boolean isValid() {
        if (StringUtils.isBlank((CharSequence)this.targetFieldKey)) {
            return false;
        }
        if (this.fieldConvertType == null) {
            return false;
        }
        switch (this.fieldConvertType) {
            case SourceField: {
                return StringUtils.isNotBlank((CharSequence)this.sourceFieldKey);
            }
            case Formula: {
                return this.formula != null && StringUtils.isNotBlank((CharSequence)this.formula.getExpression());
            }
            case CONSTANT: {
                return this.constant != null && StringUtils.isNotBlank((CharSequence)this.constant.getExpression());
            }
            case ByCondition: {
                return this.valByConditions != null && !this.valByConditions.getItems().isEmpty();
            }
        }
        return false;
    }

    @SimplePropertyAttribute(isPrimaryKey=true)
    @KSMethod
    public String getTargetFieldKey() {
        return this.targetFieldKey;
    }

    public void setTargetFieldKey(String targetFieldKey) {
        this.targetFieldKey = targetFieldKey;
    }

    @KSMethod
    public FieldConvertType getFieldConvertType() {
        return this.fieldConvertType;
    }

    public void setFieldConvertType(FieldConvertType fieldConvertType) {
        this.fieldConvertType = fieldConvertType;
    }

    @SimplePropertyAttribute
    public String getConvertType() {
        return this.fieldConvertType.name();
    }

    public void setConvertType(String convertType) {
        this.fieldConvertType = FieldConvertType.valueOf(convertType);
    }

    @SimplePropertyAttribute
    public String getConvertType2() {
        Object[] strs = new String[]{this.getFieldConvertType().toString(), ""};
        switch (this.getFieldConvertType()) {
            case SourceField: {
                if (!StringUtils.isNotBlank((CharSequence)this.getSourceFieldKey())) break;
                strs[1] = this.getSourceFieldKey();
                break;
            }
            case Formula: {
                if (this.getFormula() == null || !StringUtils.isNotBlank((CharSequence)this.getFormula().getExpression())) break;
                strs[1] = this.getFormula().getExpression();
                break;
            }
            case CONSTANT: {
                if (this.getConstant() == null || !StringUtils.isNotBlank((CharSequence)this.getConstant().getExpression())) break;
                strs[1] = this.getConstant().getExpression();
                break;
            }
            case ByCondition: {
                if (this.getValByConditions() == null || this.getValByConditions().getItems().isEmpty()) break;
                ArrayList<CRValByCondition> conObjList = new ArrayList<CRValByCondition>(this.getValByConditions().getItems());
                conObjList.sort(new CRValByConditionComparator());
                ArrayList<String> conStrList = new ArrayList<String>(conObjList.size());
                for (CRValByCondition item : this.getValByConditions().getItems()) {
                    String conStr = String.format("%s_%s_%s_%s_%s_%s", item.getId(), item.getSelect(), item.getCondition() != null ? item.getCondition().getExpression() : "", item.getIfconstant(), item.getFormula() != null ? item.getFormula().getExpression() : "", item.hashCode());
                    conStrList.add(conStr);
                }
                strs[1] = StringUtils.join((Object[])conStrList.toArray(), (String)";");
                break;
            }
        }
        if (StringUtils.isBlank((CharSequence)strs[1])) {
            return null;
        }
        return StringUtils.join((Object[])strs, (String)",");
    }

    public void setConvertType2(String convertType2) {
        this.convertType2 = convertType2;
    }

    @KSMethod
    public FieldSumType getFieldSumType() {
        return this.fieldSumType;
    }

    public void setFieldSumType(FieldSumType fieldSumType) {
        this.fieldSumType = fieldSumType;
    }

    @SimplePropertyAttribute
    public String getSumType() {
        return this.fieldSumType.name();
    }

    public void setSumType(String sumType) {
        this.fieldSumType = FieldSumType.valueOf(sumType);
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getSourceFieldKey() {
        return this.sourceFieldKey;
    }

    public void setSourceFieldKey(String sourceFieldKey) {
        this.sourceFieldKey = sourceFieldKey;
    }

    @ComplexPropertyAttribute
    @KSMethod
    public CRFormula getFormula() {
        return this.formula;
    }

    public void setFormula(CRFormula formula) {
        this.formula = formula;
    }

    @ComplexPropertyAttribute
    @KSMethod
    public CRValByConditions getValByConditions() {
        return this.valByConditions;
    }

    public void setValByConditions(CRValByConditions valByConditions) {
        this.valByConditions = valByConditions;
    }

    @SimplePropertyAttribute
    public String getValByCondiionsString() {
        if (this.getValByConditions() == null) {
            return null;
        }
        return SerializationUtils.toJsonString((Object)this.getValByConditions());
    }

    public void setValByCondiionsString(String valByCondiionsString) {
        this.valByCondiionsString = valByCondiionsString;
    }

    @ComplexPropertyAttribute
    @KSMethod
    public CRFormula getConstant() {
        return this.constant;
    }

    public void setConstant(CRFormula constant) {
        this.constant = constant;
    }

    @SimplePropertyAttribute
    @KSMethod
    public boolean isDrawFilter() {
        return this.drawFilter;
    }

    public void setDrawFilter(boolean drawFilter) {
        this.drawFilter = drawFilter;
    }

    @SimplePropertyAttribute
    @KSMethod
    public boolean isDrawAgainFilter() {
        return this.drawAgainFilter;
    }

    public void setDrawAgainFilter(boolean drawAgainFilter) {
        this.drawAgainFilter = drawAgainFilter;
    }

    @SimplePropertyAttribute
    @KSMethod
    public boolean isBreakForNoDistribute() {
        return this.breakForNoDistribute;
    }

    public void setBreakForNoDistribute(boolean breakForNoDistribute) {
        this.breakForNoDistribute = breakForNoDistribute;
    }

    @SimplePropertyAttribute
    @KSMethod
    public boolean isOnlyTakeApprovedData() {
        return this.onlyTakeApprovedData;
    }

    public void setOnlyTakeApprovedData(boolean onlyTakeApprovedData) {
        this.onlyTakeApprovedData = onlyTakeApprovedData;
    }

    @SimplePropertyAttribute
    @KSMethod
    public boolean isOnlyTakeUsedData() {
        return this.onlyTakeUsedData;
    }

    public void setOnlyTakeUsedData(boolean onlyTakeUsedData) {
        this.onlyTakeUsedData = onlyTakeUsedData;
    }

    public void check(MainEntityType srcMainType, MainEntityType tgtMainType, ConvertRuleElement rule, CheckPoint parentPoint, CheckResult checkResult, Map<String, Boolean> fieldMap) {
        if (StringUtils.isBlank((CharSequence)this.getTargetFieldKey())) {
            return;
        }
        DynamicProperty tgtFieldProp = RowDataModel.findProperty((MainEntityType)tgtMainType, (String)this.getTargetFieldKey());
        if (tgtFieldProp == null) {
            return;
        }
        CheckPoint checkPoint = new CheckPoint(parentPoint, tgtFieldProp.getDisplayName().toString());
        if (fieldMap.get(this.getTargetFieldKey()) != null && fieldMap.get(this.getTargetFieldKey()).booleanValue() && (this.fieldConvertType == FieldConvertType.SourceField && StringUtils.isBlank((CharSequence)this.sourceFieldKey) || this.fieldConvertType == FieldConvertType.Formula && (this.formula == null || StringUtils.isBlank((CharSequence)this.formula.getExpression())) || this.fieldConvertType == FieldConvertType.ByCondition && (this.valByConditions == null || this.valByConditions.getItems().size() == 0) || this.fieldConvertType == FieldConvertType.CONSTANT && (this.constant == null || StringUtils.isBlank((CharSequence)this.constant.getExpression())))) {
            this.addErrorMessage(checkPoint, checkResult, String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u5b57\u6bb5[%s]\u51fa\u5382\u8bbe\u7f6e\u5fc5\u5f55\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FieldMapItem_2", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), this.getTargetFieldKey()));
        }
        if (this.fieldConvertType == FieldConvertType.SourceField) {
            if (StringUtils.isNotBlank((CharSequence)this.getSourceFieldKey()) && RowDataModel.findProperty((MainEntityType)srcMainType, (String)this.getSourceFieldKey()) == null) {
                this.addErrorMessage(checkPoint, checkResult, String.format(ResManager.loadKDString((String)"\u6e90\u5355\u5b57\u6bb5[%s]\u5df2\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u53d6\u503c\u6765\u6e90", (String)"FieldMapItem_1", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), this.getSourceFieldKey()));
            }
        } else if (this.fieldConvertType == FieldConvertType.Formula) {
            if (this.getFormula() != null && StringUtils.isNotBlank((CharSequence)this.getFormula().getExpression())) {
                this.getFormula().check(srcMainType, new CheckPoint(checkPoint, ResManager.loadKDString((String)"\u53d6\u503c\u516c\u5f0f", (String)"FieldMapItem_3", (String)BOS_ENTITY_CORE, (Object[])new Object[0])), checkResult);
            }
        } else if (this.fieldConvertType == FieldConvertType.ByCondition && this.getValByConditions() != null && !this.getValByConditions().getItems().isEmpty()) {
            this.valByConditions.check(srcMainType, checkPoint, checkResult);
        }
    }

    private void addErrorMessage(CheckPoint checkPoint, CheckResult checkResult, String errMessage) {
        checkResult.addErrorMessage(checkPoint, errMessage);
    }

    public void beginInit() {
        this._isInitialize = true;
    }

    public void endInit() {
        if (StringUtils.isNotBlank((CharSequence)this.convertType2)) {
            String[] strs = StringUtils.split((String)this.convertType2, (String)",");
            String fldConvType = strs[0];
            if (StringUtils.equalsIgnoreCase((CharSequence)fldConvType, (CharSequence)FieldConvertType.SourceField.toString())) {
                this.fieldConvertType = FieldConvertType.SourceField;
            } else if (StringUtils.equalsIgnoreCase((CharSequence)fldConvType, (CharSequence)FieldConvertType.Formula.toString())) {
                this.fieldConvertType = FieldConvertType.Formula;
            } else if (StringUtils.equalsIgnoreCase((CharSequence)fldConvType, (CharSequence)FieldConvertType.ByCondition.toString())) {
                this.fieldConvertType = FieldConvertType.ByCondition;
            } else if (StringUtils.equalsIgnoreCase((CharSequence)fldConvType, (CharSequence)FieldConvertType.CONSTANT.toString())) {
                this.fieldConvertType = FieldConvertType.CONSTANT;
            }
        }
        this.convertType2 = null;
        if (StringUtils.isNotBlank((CharSequence)this.valByCondiionsString)) {
            this.valByConditions = (CRValByConditions)SerializationUtils.fromJsonString((String)this.valByCondiionsString, CRValByConditions.class);
        }
        this.valByCondiionsString = null;
        this._isInitialize = false;
    }

    public boolean isInitialized() {
        return this._isInitialize;
    }

    public String toString() {
        return this.targetFieldKey;
    }

    static class CRValByConditionComparator
    implements Comparator<CRValByCondition> {
        CRValByConditionComparator() {
        }

        @Override
        public int compare(CRValByCondition o1, CRValByCondition o2) {
            return o1.getSeq() - o2.getSeq();
        }
    }
}

