/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.CheckPoint;
import kd.bos.entity.botp.CheckResult;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.LinkRecordType;
import kd.bos.entity.botp.extcontrol.ExtControlElement;
import kd.bos.entity.botp.extcontrol.ExtControlParam;
import kd.bos.entity.botp.extcontrol.enums.ExtControlModelEnum;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class LinkEntityPolicy {
    private static final String BOS_ENTITY_CORE = "bos-botp-core";
    private String sourceEntryKey;
    private String sourceSubEntryKey;
    private String sourceLayout;
    private String mobSourceLayout;
    private String targetLayout;
    private String mobTargetLayout;
    private String targetEntryKey;
    private String targetSubEntryKey;
    private LinkRecordType linkRecordType = LinkRecordType.Link;

    @SimplePropertyAttribute
    @KSMethod
    public String getSourceEntryKey() {
        return this.sourceEntryKey;
    }

    public void setSourceEntryKey(String sourceEntryKey) {
        this.sourceEntryKey = sourceEntryKey;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getSourceSubEntryKey() {
        return this.sourceSubEntryKey;
    }

    public void setSourceSubEntryKey(String sourceSubEntryKey) {
        this.sourceSubEntryKey = sourceSubEntryKey;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getSourceLayout() {
        return this.sourceLayout;
    }

    public void setSourceLayout(String sourceLayout) {
        this.sourceLayout = sourceLayout;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getMobSourceLayout() {
        return this.mobSourceLayout;
    }

    public void setMobSourceLayout(String mobSourceLayout) {
        this.mobSourceLayout = mobSourceLayout;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getTargetLayout() {
        return this.targetLayout;
    }

    public void setTargetLayout(String targetLayout) {
        this.targetLayout = targetLayout;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getMobTargetLayout() {
        return this.mobTargetLayout;
    }

    public void setMobTargetLayout(String mobTargetLayout) {
        this.mobTargetLayout = mobTargetLayout;
    }

    @SimplePropertyAttribute(isPrimaryKey=true)
    @KSMethod
    public String getTargetEntryKey() {
        return this.targetEntryKey;
    }

    public void setTargetEntryKey(String targetEntryKey) {
        this.targetEntryKey = targetEntryKey;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getTargetSubEntryKey() {
        return this.targetSubEntryKey;
    }

    public void setTargetSubEntryKey(String targetSubEntryKey) {
        this.targetSubEntryKey = targetSubEntryKey;
    }

    @KSMethod
    public LinkRecordType getLinkRecordType() {
        return this.linkRecordType;
    }

    public void setLinkRecordType(LinkRecordType linkRecordType) {
        this.linkRecordType = linkRecordType;
    }

    @SimplePropertyAttribute
    public String getLinkType() {
        return this.linkRecordType.name();
    }

    public void setLinkType(String linkType) {
        this.linkRecordType = LinkRecordType.valueOf(linkType);
    }

    @KSMethod
    public HashSet<String> getSrcLinkEntitys(MainEntityType srcMainType) {
        HashSet<String> entityKeys = new HashSet<String>();
        entityKeys.add(srcMainType.getName());
        String entryKey = this.sourceEntryKey;
        EntityType entityType = (EntityType)srcMainType.getAllEntities().get(entryKey);
        if (entityType instanceof SubEntryType) {
            entityKeys.add(entityType.getParent().getName());
            entityKeys.add(entryKey);
        } else if (entityType instanceof EntryType) {
            entityKeys.add(entryKey);
        }
        return entityKeys;
    }

    public void check(MainEntityType srcMainType, MainEntityType tgtMainType, ConvertRuleElement rule, CheckPoint parentPoint, CheckResult checkResult, Map<Integer, ExtControlElement> elementMap) {
        if (this.getLinkRecordType() == LinkRecordType.OnlyCopy) {
            return;
        }
        CheckPoint checkPoint = new CheckPoint(parentPoint, ResManager.loadKDString((String)"\u5173\u8054\u5b9e\u4f53", (String)"LinkEntityPolicy_0", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
        ExtControlElement extControlElement = elementMap.get(ExtControlModelEnum.LINK_ENTRY.getType());
        if (extControlElement != null) {
            for (ExtControlParam.Param param : extControlElement.getExtControlParam().getParams()) {
                switch (param.getKey()) {
                    case "ftargetentrykey": {
                        if (!StringUtils.isBlank((CharSequence)this.targetEntryKey)) break;
                        checkResult.addErrorMessage(checkPoint, ResManager.loadKDString((String)"\u76ee\u6807\u5355\u5173\u8054\u5b9e\u4f53\u51fa\u5382\u8bbe\u7f6e\u5fc5\u5f55\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LinkEntityPolicy_5", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
                        break;
                    }
                    case "ftargetsubentrykey": {
                        if (!StringUtils.isBlank((CharSequence)this.targetSubEntryKey)) break;
                        checkResult.addErrorMessage(checkPoint, ResManager.loadKDString((String)"\u76ee\u6807\u5355\u5b50\u5355\u636e\u4f53\u51fa\u5382\u8bbe\u7f6e\u5fc5\u5f55\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LinkEntityPolicy_6", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
                        break;
                    }
                    case "fsourceentrykey": {
                        if (!StringUtils.isBlank((CharSequence)this.sourceEntryKey)) break;
                        checkResult.addErrorMessage(checkPoint, ResManager.loadKDString((String)"\u6e90\u5355\u5173\u8054\u5b9e\u4f53\u51fa\u5382\u8bbe\u7f6e\u5fc5\u5f55\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LinkEntityPolicy_7", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
                        break;
                    }
                    case "fsourcesubentrykey": {
                        if (!StringUtils.isBlank((CharSequence)this.sourceSubEntryKey)) break;
                        checkResult.addErrorMessage(checkPoint, ResManager.loadKDString((String)"\u6e90\u5355\u5b50\u5355\u636e\u4f53\u51fa\u5382\u8bbe\u7f6e\u5fc5\u5f55\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LinkEntityPolicy_8", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
                        break;
                    }
                    case "fsourcelayout": {
                        if (!StringUtils.isBlank((CharSequence)this.sourceLayout)) break;
                        checkResult.addErrorMessage(checkPoint, ResManager.loadKDString((String)"PC\u7aef\u6e90\u5355\u9009\u5355\u5e03\u5c40\u51fa\u5382\u8bbe\u7f6e\u5fc5\u5f55\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LinkEntityPolicy_9", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
                        break;
                    }
                    case "flinkrecord": {
                        if (this.linkRecordType.getValue() == 0) break;
                        checkResult.addErrorMessage(checkPoint, ResManager.loadKDString((String)"\u8bb0\u5f55\u5173\u8054\u5173\u7cfb\u51fa\u5382\u8bbe\u7f6e\u5fc5\u9700\u5f00\u542f\u3002", (String)"LinkEntityPolicy_10", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
                    }
                }
            }
        }
        MainEntityType srcEntityType = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)srcMainType.getName(), (CharSequence)this.getSourceEntryKey())) {
            srcEntityType = srcMainType;
        } else if (StringUtils.isNotBlank((CharSequence)this.getSourceEntryKey())) {
            srcEntityType = (EntityType)srcMainType.getAllEntities().get(this.getSourceEntryKey());
        }
        if (srcEntityType == null) {
            checkResult.addErrorMessage(checkPoint, ResManager.loadKDString((String)"\u52fe\u9009\u4e86\u8bb0\u5f55\u5173\u8054\u5173\u7cfb\uff0c\u6e90\u5355\u4e3b\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (String)"LinkEntityPolicy_1", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
        }
        MainEntityType tgtEntityType = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)tgtMainType.getName(), (CharSequence)this.getTargetEntryKey())) {
            tgtEntityType = tgtMainType;
        } else if (StringUtils.isNotBlank((CharSequence)this.getTargetEntryKey())) {
            tgtEntityType = (EntityType)tgtMainType.getAllEntities().get(this.getTargetEntryKey());
        }
        if (tgtEntityType == null) {
            checkResult.addErrorMessage(checkPoint, ResManager.loadKDString((String)"\u52fe\u9009\u4e86\u8bb0\u5f55\u5173\u8054\u5173\u7cfb\uff0c\u76ee\u6807\u5355\u4e3b\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (String)"LinkEntityPolicy_2", (String)BOS_ENTITY_CORE, (Object[])new Object[0]));
            return;
        }
        LinkSetItemElement linkSetItem = null;
        LinkSetElement tgtLinkSet = EntityMetadataCache.getLinkSet((String)tgtMainType.getName());
        if (tgtLinkSet != null) {
            for (LinkSetItemElement item : tgtLinkSet.getItems()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)item.getParentEntityKey(), (CharSequence)this.getTargetEntryKey())) continue;
                linkSetItem = item;
                break;
            }
        }
        if (linkSetItem == null || StringUtils.isBlank((CharSequence)linkSetItem.getTableName())) {
            String msg = String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u7684%s\uff0c\u672a\u914d\u7f6e\u5173\u8054\u5b50\u8868\uff0c\u65e0\u6cd5\u8bb0\u5f55\u5173\u8054\u5173\u7cfb\uff1a\u8bf7\u6253\u5f00\u76ee\u6807\u5355\u8bbe\u8ba1\u5668\uff0c\u8bbe\u7f6e\u5173\u8054\u914d\u7f6e", (String)"LinkEntityPolicy_3", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), tgtEntityType instanceof MainEntityType ? ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"LinkEntityPolicy_4", (String)BOS_ENTITY_CORE, (Object[])new Object[0]) : tgtEntityType.getDisplayName().toString());
            checkResult.addErrorMessage(checkPoint, msg);
        }
    }
}

