/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.ShowFormHelper;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;

public class PushAndDrawUtil {
    private static final String BOS_ENTITY_CORE = "bos-botp-core";

    public static ListShowParameter tryCreateShowListForm(String sourceFormId, String sourceEntityNumber) {
        ListShowParameter listShowParameter;
        try {
            listShowParameter = ShowFormHelper.createShowListForm((String)sourceFormId, (boolean)true);
        }
        catch (KDException e) {
            PushAndDrawUtil.nonMetaNotFound(e);
            if (sourceFormId.equals(sourceEntityNumber)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"number\u4e3a%s\uff08\u6e90\u5355\u6807\u8bc6\uff09\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"PushAndDrawUtil_0", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), sourceFormId));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"number\u4e3a%s\uff08\u5e03\u5c40\u6807\u8bc6\uff09\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"PushAndDrawUtil_1", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), sourceFormId));
        }
        return listShowParameter;
    }

    public static void nonMetaNotFound(KDException e) {
        ErrorCode errorCode = e.getErrorCode();
        if (errorCode == null || !"bos.metaNotFound".equalsIgnoreCase(errorCode.getCode())) {
            throw e;
        }
    }

    public static boolean isMetadataExist(String number) {
        if (StringUtils.isNotBlank((CharSequence)number)) {
            String id = MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Form);
            if (id != null) {
                return true;
            }
            if (number.endsWith("_mob")) {
                number = number.substring(0, number.length() - 4);
                return PushAndDrawUtil.isMetadataExist(number);
            }
        }
        return false;
    }
}

