/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.WriteBackRuleElement;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;

class WriteBackRuleLocalCache {
    private static final String TYPE_WR_RULE = "wr_rule_";
    private static final String TYPE_WR_VERID = "wr_verid_";
    private static final String TYPE_WR_VER = "wr_ver_";
    public static final long CHECK_VERSION_TIME_MILLIS = 10000L;
    public static final long TIME_OUT_MILLIS = 600000L;
    private static final CacheConfigInfo info = new CacheConfigInfo();

    WriteBackRuleLocalCache() {
    }

    private static LocalMemoryCache getLocalCache() {
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "WriteBackRuleLocalCache", info);
    }

    public static void clearAllRuleCache() {
        WriteBackRuleLocalCache.getLocalCache().clear();
    }

    private static String makeCacheKey(String type, String key) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        if (StringUtils.isNotBlank((CharSequence)appGroup) && !"defaultGroup".equals(appGroup)) {
            return String.format("%s.%s.%s", appGroup, key, type).toLowerCase();
        }
        return String.format("%s.%s", key, type).toLowerCase();
    }

    public static WriteBackRuleElement getRule(String ruleId) {
        String cacheKey = WriteBackRuleLocalCache.makeCacheKey(TYPE_WR_RULE, ruleId);
        return (WriteBackRuleElement)WriteBackRuleLocalCache.getLocalCache().get(cacheKey);
    }

    public static void putRule(String ruleId, WriteBackRuleElement rule) {
        String cacheKey = WriteBackRuleLocalCache.makeCacheKey(TYPE_WR_RULE, ruleId);
        WriteBackRuleLocalCache.getLocalCache().put(cacheKey, (Object)rule);
    }

    public static Long loadRuleVerId(String ruleId, long oriVersion, long extVersion) {
        String cacheKey = WriteBackRuleLocalCache.makeCacheKey(TYPE_WR_VERID, String.format("%s_%s_%s", ruleId, oriVersion, extVersion));
        return (Long)WriteBackRuleLocalCache.getLocalCache().get(cacheKey);
    }

    public static void putRuleVerId(String ruleId, long oriVersion, long extVersion, Long verId) {
        String cacheKey = WriteBackRuleLocalCache.makeCacheKey(TYPE_WR_VERID, String.format("%s_%s_%s", ruleId, oriVersion, extVersion));
        WriteBackRuleLocalCache.getLocalCache().put(cacheKey, (Object)verId);
    }

    public static WriteBackRuleElement getRuleVer(long verId) {
        String cacheKey = WriteBackRuleLocalCache.makeCacheKey(TYPE_WR_VER, String.valueOf(verId));
        return (WriteBackRuleElement)WriteBackRuleLocalCache.getLocalCache().get(cacheKey);
    }

    public static void putRuleVer(long verId, WriteBackRuleElement rule) {
        String cacheKey = WriteBackRuleLocalCache.makeCacheKey(TYPE_WR_VER, String.valueOf(verId));
        WriteBackRuleLocalCache.getLocalCache().put(cacheKey, (Object)rule);
    }

    static {
        info.setTimeout(43200);
        info.setMaxMemSize(10000);
    }
}

