/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp.extcontrol;

import com.fasterxml.jackson.annotation.JsonProperty;
import dm.jdbc.util.IDGenerator;
import java.io.Serializable;
import java.util.Objects;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.entity.botp.extcontrol.ExtControlParam;
import kd.bos.entity.botp.helper.MultiLangEnumBridge;

public class ExtControlElement
implements Serializable {
    private static final String BOS_ENTITY_CORE = "bos-botp-core";
    private static final long serialVersionUID = -2736723024860797886L;
    private long id;
    private int type;
    private int modelType;
    private ExtControlParam extControlParam = new ExtControlParam();

    public static ExtControlElement createNewInstanceByGlobalCondition(int modelType) {
        ExtControlElement element = new ExtControlElement();
        element.type = TypeEnum.GLOBAL_CONDITION.type;
        element.modelType = modelType;
        return element;
    }

    public static ExtControlElement createNewInstanceByMultiSelect(int modelType) {
        ExtControlElement element = new ExtControlElement();
        element.type = TypeEnum.MULTISELECT_CONDITION.type;
        element.modelType = modelType;
        return element;
    }

    @JsonProperty(value="Id")
    @SimplePropertyAttribute(isPrimaryKey=true, name="Id")
    public long getId() {
        if (this.id == 0L) {
            this.id = IDGenerator.generate();
        }
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @JsonProperty(value="Type")
    @SimplePropertyAttribute(name="Type")
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @JsonProperty(value="ModelType")
    @SimplePropertyAttribute(name="ModelType")
    public int getModelType() {
        return this.modelType;
    }

    public void setModelType(int modelType) {
        this.modelType = modelType;
    }

    @JsonProperty(value="ExtControlParam")
    @ComplexPropertyAttribute(name="ExtControlParam")
    public ExtControlParam getExtControlParam() {
        return this.extControlParam;
    }

    public void setExtControlParam(ExtControlParam extControlParam) {
        this.extControlParam = extControlParam;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtControlElement element = (ExtControlElement)o;
        return Objects.equals(this.type, element.type) && Objects.equals(this.modelType, element.modelType);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.modelType);
    }

    public static enum TypeEnum {
        GLOBAL_CONDITION(1, new MultiLangEnumBridge("\u5168\u5c40\u6761\u4ef6", "ExtControlElement_0", "bos-botp-core")),
        MULTISELECT_CONDITION(2, new MultiLangEnumBridge("\u590d\u6570\u884c\u6761\u4ef6", "ExtControlElement_1", "bos-botp-core"));

        private int type;
        private MultiLangEnumBridge bridge = null;

        private TypeEnum(int type, MultiLangEnumBridge bridge) {
            this.type = type;
            this.bridge = bridge;
        }

        public int getType() {
            return this.type;
        }

        public String getDesc() {
            return this.bridge.loadKDString();
        }
    }
}

