/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp.helper;

import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.AttachmentItemInfo;
import kd.bos.entity.botp.runtime.AttachmentPanelMap;
import kd.bos.form.control.UrlUtil;
import kd.bos.mservice.attachment.AttachmentInfo;
import kd.bos.mservice.attachment.AttachmentType;
import kd.bos.mservice.attachment.FieldType;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.url.UrlService;
import org.apache.log4j.Logger;

public class AttachmentPanelConvertHelper {
    private static Logger log = Logger.getLogger(AttachmentPanelConvertHelper.class);

    public static Map<String, List<AttachmentItemInfo>> loadAttachInfoMap(MainEntityType sourceEntityType, Map<String, AttachmentPanelMap> attachmentPanelMaps, List<Object> sourceBillIds, List<Object> pushedTargetBillSourceIds) {
        HashMap<String, List<AttachmentItemInfo>> attachmentInfos = new HashMap<String, List<AttachmentItemInfo>>(attachmentPanelMaps.size());
        if (sourceBillIds.isEmpty()) {
            return attachmentInfos;
        }
        for (Map.Entry<String, AttachmentPanelMap> entry : attachmentPanelMaps.entrySet()) {
            String targetAttachmentPanelKey = entry.getKey();
            AttachmentPanelMap attachmentPanelMap = entry.getValue();
            if (attachmentPanelMap.isMergeAttachments()) {
                ArrayList<Object> sourceIdsNotPush = new ArrayList<Object>(sourceBillIds);
                if (pushedTargetBillSourceIds != null) {
                    sourceIdsNotPush.removeAll(pushedTargetBillSourceIds);
                }
                attachmentInfos.put(targetAttachmentPanelKey, AttachmentPanelConvertHelper.loadAttachmentInfos(sourceEntityType, sourceIdsNotPush, attachmentPanelMap));
                continue;
            }
            attachmentInfos.put(targetAttachmentPanelKey, AttachmentPanelConvertHelper.loadAttachmentInfos(sourceEntityType, sourceBillIds, attachmentPanelMap));
        }
        return attachmentInfos;
    }

    private static List<AttachmentItemInfo> loadAttachmentInfos(MainEntityType sourceEntityType, List<Object> sourceBillIds, AttachmentPanelMap attachmentPanelMap) {
        Object[] objectArray;
        if (attachmentPanelMap.isMergeAttachments()) {
            objectArray = sourceBillIds.toArray();
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = sourceBillIds.get(0);
        }
        Object[] sourceBillIdArray = objectArray;
        Map sourceAttachments = AttachmentServiceHelper.getAttachments((String)sourceEntityType.getName(), (Object[])sourceBillIdArray, (String)attachmentPanelMap.getSourceAttachmentPanelKey(), (boolean)true);
        ArrayList<AttachmentItemInfo> mergedAttachments = new ArrayList<AttachmentItemInfo>(sourceAttachments.size());
        for (List attachments : sourceAttachments.values()) {
            int i = 0;
            for (Map att : attachments) {
                att.put("tempBotpAttachment", true);
                att.put("uid", "rc-botp-" + UUID.randomUUID() + i);
                att.put("attKey", attachmentPanelMap.getTargetAttachmentPanelKey());
                AttachmentPanelConvertHelper.decodeAndReplaceUrlWithPath(att, "url");
                AttachmentPanelConvertHelper.decodeAndReplaceUrlWithPath(att, "previewurl");
                att.remove("lastModified");
                att.remove("uploadTime");
                ++i;
            }
            mergedAttachments.addAll(AttachmentPanelConvertHelper.convertAttachmentInfoMapsToAttachmentInfos(AttachmentPanelConvertHelper.convertBindAttachmentsToAttachmentInfoMaps(attachments)));
        }
        log.info((Object)String.format("\u6839\u636e\u6e90\u5355id\u67e5\u8be2\u5230%d\u4e2a\u9644\u4ef6\uff0c\u6e90\u5355\uff1a%s", mergedAttachments.size(), sourceBillIds));
        AttachmentPanelConvertHelper.distinctTempAttachments(mergedAttachments);
        return mergedAttachments;
    }

    private static void distinctTempAttachments(List<AttachmentItemInfo> attachs) {
        AttachmentPanelConvertHelper.distinctAttachments(attachs, AttachmentInfo::getDownloadUrl, AttachmentInfo::getFileName, AttachmentItemInfo::getUid);
        HashMap<String, Integer> nameCountMap = new HashMap<String, Integer>();
        for (AttachmentItemInfo att : attachs) {
            AttachmentPanelConvertHelper.renameAttachName(nameCountMap, att, AttachmentInfo::getFileName, AttachmentInfo::setFileName);
        }
    }

    private static <T> void distinctAttachments(List<T> attachs, Function<T, String> getUrl, Function<T, String> getName, Function<T, String> getUid) {
        List computeAttachs = attachs.stream().filter(att -> StringUtils.isNotBlank((CharSequence)((CharSequence)getUrl.apply(att)))).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Object>(Comparator.comparing(att -> (String)getName.apply(att) + ";" + (String)getUrl.apply(att)))), ArrayList::new));
        attachs.removeIf(att -> !computeAttachs.contains(att));
    }

    private static <T> void renameAttachName(Map<String, Integer> nameCountMap, T att, Function<T, String> getName, BiConsumer<T, String> setName) {
        String name = getName.apply(att);
        Integer nameCount = nameCountMap.get(name);
        nameCount = nameCount == null ? 1 : nameCount + 1;
        nameCountMap.put(name, nameCount);
        if (nameCount > 1) {
            String realName = name.substring(0, name.lastIndexOf(46));
            String newName = String.format("%s\uff08%s\uff09%s", realName, nameCount, name.substring(realName.length()));
            while (nameCountMap.containsKey(newName)) {
                nameCount = nameCount + 1;
                nameCountMap.put(name, nameCount);
                newName = String.format("%s\uff08%s\uff09%s", realName, nameCount, name.substring(realName.length()));
            }
            setName.accept(att, newName);
            nameCountMap.put(newName, 1);
        }
    }

    public static void distinctTempAttachmentsForDraw(List<Map<String, Object>> attachs) {
        AttachmentPanelConvertHelper.distinctAttachments(attachs, att -> (String)att.get("url"), att -> (String)att.get("name"), att -> (String)att.get("uid"));
        HashMap<String, Integer> nameCountMap = new HashMap<String, Integer>();
        for (Map<String, Object> att2 : attachs) {
            AttachmentPanelConvertHelper.renameAttachName(nameCountMap, att2, attach -> (String)attach.get("name"), (attach, name) -> attach.put("name", name));
        }
    }

    public static void distinctTempAttachmentsForDraw(List<Map<String, Object>> bindAttachs, List<Map<String, Object>> tempAtts) {
        bindAttachs.addAll(AttachmentPanelConvertHelper.convertAttachmentInfoMapToBindAttachmentList(tempAtts));
        AttachmentPanelConvertHelper.distinctAttachments(bindAttachs, att -> {
            String url = AttachmentPanelConvertHelper.getDecodePath(att, "url");
            if (url.contains("://") && url.startsWith("/")) {
                url = url.substring(1);
            }
            return url;
        }, att -> (String)att.get("name"), att -> (String)att.get("uid"));
        HashMap<String, Integer> nameCountMap = new HashMap<String, Integer>();
        for (Map<String, Object> att2 : bindAttachs) {
            AttachmentPanelConvertHelper.renameAttachName(nameCountMap, att2, attach -> (String)attach.get("name"), (attach, name) -> attach.put("name", name));
        }
        Map<String, String> bindUidNames = bindAttachs.stream().collect(Collectors.toMap(att -> (String)att.get("uid"), att -> (String)att.get("name"), (v1, v2) -> v1));
        tempAtts.removeIf(att -> !bindUidNames.containsKey(att.get("uid")));
        for (Map<String, Object> att3 : tempAtts) {
            String name2 = bindUidNames.get(att3.get("uid"));
            if (!StringUtils.isNotBlank((CharSequence)name2)) continue;
            att3.put("name", name2);
        }
    }

    private static void decodeAndReplaceUrlWithPath(Map<String, Object> att, String urlKey) {
        att.put(urlKey, AttachmentPanelConvertHelper.getDecodePath(att, urlKey));
    }

    private static String getDecodePath(Map<String, Object> att, String urlKey) {
        String path;
        String url = (String)att.getOrDefault(urlKey, "");
        if (StringUtils.isNotBlank((CharSequence)url) && (path = UrlUtil.getParam((String)url, (String)"path")) != null) {
            url = path;
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)url)) {
                url = URLDecoder.decode(url, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("error decode url:" + url), (Throwable)e);
        }
        url = AttachmentPanelConvertHelper.trimPath(url);
        return url;
    }

    public static List<AttachmentItemInfo> convertAttachmentInfoMapsToAttachmentInfos(List<Map<String, Object>> attachments) {
        ArrayList<AttachmentItemInfo> list = new ArrayList<AttachmentItemInfo>(attachments.size());
        for (Map<String, Object> item : attachments) {
            AttachmentItemInfo attachmentInfo = new AttachmentItemInfo();
            attachmentInfo.setUid((String)item.get("uid"));
            attachmentInfo.setTempBotpAttachment((Boolean)item.get("tempBotpAttachment"));
            attachmentInfo.setAttSourceType(AttachmentType.attachmentpanel);
            attachmentInfo.setAttKey((String)item.get("attKey"));
            attachmentInfo.setEntityNum((String)item.get("entityNum"));
            attachmentInfo.setBillPkId((String)item.get("billPkId"));
            attachmentInfo.setAttPkId(Long.valueOf(item.getOrDefault("attPkId", 0L).toString()));
            attachmentInfo.setExt((String)item.get("ext"));
            attachmentInfo.setFileName((String)item.get("fileName"));
            attachmentInfo.setFileSize(Long.valueOf(item.getOrDefault("fileSize", 0L).toString()));
            attachmentInfo.setDownloadUrl((String)item.get("downloadUrl"));
            attachmentInfo.setPreviewUrl((String)item.get("previewUrl"));
            attachmentInfo.setMark(item.get("mark") == null ? "" : (String)item.get("mark"));
            attachmentInfo.setFieldType(FieldType.AttachmentPanel);
            attachmentInfo.setFieldKey((String)item.get("attKey"));
            attachmentInfo.setCreateUserId(String.valueOf(item.get("createUserId")));
            attachmentInfo.setModifyTime((Date)item.get("modifyTime"));
            attachmentInfo.setBillno((String)item.get("billno"));
            attachmentInfo.setClient((String)item.get("client"));
            list.add(attachmentInfo);
        }
        return list;
    }

    public static List<Map<String, Object>> convertAttachmentInfoMapForTempCache(List<Map<String, Object>> attachmentInfoMap) {
        ArrayList<Map<String, Object>> itemMaps = new ArrayList<Map<String, Object>>(attachmentInfoMap.size());
        for (Map<String, Object> item : attachmentInfoMap) {
            HashMap<String, Object> itemMap = new HashMap<String, Object>(item);
            itemMap.put("type", itemMap.remove("ext"));
            itemMap.put("name", itemMap.remove("fileName"));
            itemMap.put("size", itemMap.remove("fileSize"));
            itemMap.put("url", itemMap.remove("downloadUrl"));
            itemMap.put("previewurl", itemMap.remove("previewUrl"));
            itemMap.put("description", itemMap.remove("mark"));
            itemMap.put("createdate", itemMap.remove("createTime"));
            itemMap.put("status", "success");
            itemMaps.add(itemMap);
        }
        return itemMaps;
    }

    public static List<Map<String, Object>> convertAttachmentInfoMapToBindAttachmentList(List<Map<String, Object>> attachmentInfoMap) {
        ArrayList<Map<String, Object>> itemMaps = new ArrayList<Map<String, Object>>(attachmentInfoMap.size());
        for (Map<String, Object> item : attachmentInfoMap) {
            String previewurl;
            HashMap<String, Object> itemMap = new HashMap<String, Object>(item);
            String url = (String)itemMap.remove("url");
            if (StringUtils.isNotBlank((CharSequence)url)) {
                itemMap.put("url", UrlService.getAttachmentFullUrl((String)AttachmentPanelConvertHelper.encodeAttUrl(url)));
            }
            if (StringUtils.isNotBlank((CharSequence)(previewurl = (String)itemMap.remove("previewurl")))) {
                itemMap.put("previewurl", UrlService.getAttachmentPreviewUrl((String)AttachmentPanelConvertHelper.encodeAttUrl(previewurl)));
            }
            itemMaps.add(itemMap);
        }
        return itemMaps;
    }

    private static String encodeAttUrl(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("error encode url:" + url), (Throwable)e);
            return url;
        }
    }

    public static List<Map<String, Object>> convertBindAttachmentsToAttachmentInfoMaps(List<Map<String, Object>> bindAttachmentInfoMap) {
        ArrayList<Map<String, Object>> itemMaps = new ArrayList<Map<String, Object>>(bindAttachmentInfoMap.size());
        for (Map<String, Object> item : bindAttachmentInfoMap) {
            HashMap<String, Object> itemMap = new HashMap<String, Object>(item);
            itemMap.put("ext", itemMap.remove("type"));
            itemMap.put("fileName", itemMap.remove("name"));
            itemMap.put("fileSize", itemMap.remove("size"));
            itemMap.put("downloadUrl", itemMap.remove("url"));
            itemMap.put("previewUrl", itemMap.remove("previewurl"));
            itemMap.put("mark", itemMap.remove("description"));
            itemMap.put("status", "success");
            itemMaps.add(itemMap);
        }
        return itemMaps;
    }

    public static Map<String, Object> convertToSaveTempAttachments(Map<String, List<AttachmentItemInfo>> attachmentInfo) {
        HashMap<String, Object> realAttachmentMap = new HashMap<String, Object>(attachmentInfo.size());
        for (Map.Entry<String, List<AttachmentItemInfo>> entry : attachmentInfo.entrySet()) {
            realAttachmentMap.put(entry.getKey(), AttachmentPanelConvertHelper.convertSaveTempAttachmentInfoList(entry.getValue()));
        }
        return realAttachmentMap;
    }

    public static List<Map<String, Object>> convertSaveTempAttachmentInfoList(List<AttachmentItemInfo> attachmentInfo) {
        ArrayList<Map<String, Object>> itemMaps = new ArrayList<Map<String, Object>>(attachmentInfo.size());
        int attSeq = 0;
        for (AttachmentItemInfo item : attachmentInfo) {
            ++attSeq;
            if (item == null || item.getTempBotpAttachment() != null && !item.getTempBotpAttachment().booleanValue()) continue;
            String url = item.getDownloadUrl();
            if (StringUtils.isBlank((CharSequence)url)) {
                log.info((Object)("\u7b2c" + attSeq + "\u4e2a\u5f02\u5e38\u9644\u4ef6\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)((Object)item))));
                continue;
            }
            HashMap<String, Object> itemMap = new HashMap<String, Object>(32);
            itemMap.put("uid", item.getUid());
            itemMap.put("tempBotpAttachment", item.getTempBotpAttachment());
            itemMap.put("attSourceType", item.getAttSourceType());
            itemMap.put("attKey", item.getAttKey());
            itemMap.put("entityNum", item.getEntityNum());
            itemMap.put("billPkId", item.getBillPkId());
            itemMap.put("attPkId", item.getAttPkId());
            itemMap.put("type", item.getExt());
            itemMap.put("name", item.getFileName());
            itemMap.put("size", item.getFileSize());
            itemMap.put("url", url);
            itemMap.put("previewurl", item.getPreviewUrl());
            itemMap.put("description", item.getMark());
            itemMap.put("client", item.getClient());
            itemMap.put("status", "success");
            itemMap.put("createUserId", String.valueOf(item.getCreateUserId()));
            itemMaps.add(itemMap);
        }
        return itemMaps;
    }

    public static String trimPath(String sourceStr) {
        if (StringUtils.isBlank((CharSequence)sourceStr)) {
            return sourceStr;
        }
        if (sourceStr.contains(".")) {
            while (sourceStr.startsWith("//")) {
                sourceStr = sourceStr.substring(1);
            }
            return sourceStr;
        }
        while (sourceStr.startsWith("/")) {
            sourceStr = sourceStr.substring(1);
        }
        return sourceStr;
    }

    public static Map<String, List<Map<String, Object>>> convertBillAttachmentInfosToBillAttachmentInfoMaps(Map<String, List<AttachmentItemInfo>> billAttachmentInfos) {
        HashMap<String, List<Map<String, Object>>> billAttachmentInfoMaps = new HashMap<String, List<Map<String, Object>>>(billAttachmentInfos.size());
        for (Map.Entry<String, List<AttachmentItemInfo>> entry : billAttachmentInfos.entrySet()) {
            ArrayList<Map<String, Object>> attachMaps = new ArrayList<Map<String, Object>>(entry.getValue().size());
            for (AttachmentItemInfo item : entry.getValue()) {
                attachMaps.add(item.toMap());
            }
            billAttachmentInfoMaps.put(entry.getKey(), attachMaps);
        }
        return billAttachmentInfoMaps;
    }
}

