/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp.mc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.botp.mc.BotpMCConstants;

public class BotpMCParam {
    private static Map<String, String> defaultData = new HashMap<String, String>(1);
    private static Set<String> typeIntegers = new HashSet<String>(1);
    private static Set<String> typeLongs = new HashSet<String>(1);
    private static Set<String> typeStrings = new HashSet<String>(1);
    private static Set<String> typeBooleans = new HashSet<String>(1);

    public static int getIntValue(String key) {
        BotpMCParam.checkType(typeIntegers, key);
        return Integer.parseInt(BotpMCParam.getValue(key));
    }

    public static long getLongValue(String key) {
        BotpMCParam.checkType(typeLongs, key);
        return Long.parseLong(BotpMCParam.getValue(key));
    }

    public static String getStrValue(String key) {
        BotpMCParam.checkType(typeStrings, key);
        return BotpMCParam.getValue(key);
    }

    public static boolean getBolValue(String key) {
        BotpMCParam.checkType(typeBooleans, key);
        return Boolean.parseBoolean(BotpMCParam.getValue(key));
    }

    private static void checkType(Set<String> types, String key) {
        if (!types.contains(key)) {
            throw new RuntimeException("MC param type errpr, key:" + key);
        }
    }

    public static void register(String key, String defaultValue, Class type) {
        if (Integer.class.equals((Object)type)) {
            typeIntegers.add(key);
        }
        if (Long.class.equals((Object)type)) {
            typeLongs.add(key);
        }
        if (String.class.equals((Object)type)) {
            typeStrings.add(key);
        }
        if (Boolean.class.equals((Object)type)) {
            typeBooleans.add(key);
        }
        defaultData.put(key, defaultValue);
    }

    private static String getValue(String key) {
        return System.getProperty(key, defaultData.get(key));
    }

    static {
        BotpMCConstants.init();
    }
}

