/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp.plugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.TypesContainer;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRPlugin;
import kd.bos.entity.botp.plugin.IConvertRuleSetPlugIn;
import kd.bos.entity.botp.plugin.KDConvertRuleSetPlugIn;
import kd.bos.entity.botp.plugin.args.LoadFuncTypesEventArgs;
import kd.bos.script.ScriptExecutor;

public class ConvertRuleSetPlugInProxy {
    ScriptExecutor scriptExecutor;
    protected List<IConvertRuleSetPlugIn> plugIns = new ArrayList<IConvertRuleSetPlugIn>();

    public ConvertRuleSetPlugInProxy() {
    }

    public ConvertRuleSetPlugInProxy(List<CRPlugin> plugins) {
        this.scriptExecutor = ScriptExecutor.getOrCreate();
        HashSet<String> plugClasses = new HashSet<String>();
        for (CRPlugin plugin : plugins) {
            if (!plugin.isEnabled()) continue;
            int type = plugin.getType();
            String className = plugin.getClassName();
            String scriptId = plugin.getScriptId();
            if (0 == type && plugClasses.add(className)) {
                this.plugIns.add((IConvertRuleSetPlugIn)TypesContainer.createInstance((String)className));
                continue;
            }
            if (1 != type || !plugClasses.add(scriptId)) continue;
            try {
                IConvertRuleSetPlugIn splugin = this.createScriptPlugin1(scriptId);
                this.plugIns.add(splugin);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public IConvertRuleSetPlugIn createScriptPlugin(String scriptId) {
        return this.createScriptPlugin1(scriptId);
    }

    private IConvertRuleSetPlugIn createScriptPlugin1(String scriptId) {
        String script = EntityMetadataCache.getPluginScripts((String)scriptId);
        this.scriptExecutor.init(ctx -> ctx.require(new String[]{KDConvertRuleSetPlugIn.class.getName()}));
        this.scriptExecutor.begin();
        this.scriptExecutor.exec(new String[]{script});
        return (IConvertRuleSetPlugIn)this.scriptExecutor.getContext().get("plugin");
    }

    public final List<IConvertRuleSetPlugIn> getPlugIns() {
        return this.plugIns;
    }

    public final void registerPlugins(List<IConvertRuleSetPlugIn> list) {
        this.plugIns.addAll(list);
    }

    public final void registerPlugin(IConvertRuleSetPlugIn plugin) {
        this.plugIns.add(plugin);
    }

    public final void removePlugIn(IConvertRuleSetPlugIn plugIn) {
        this.plugIns.remove(plugIn);
    }

    public void destory() {
        if (this.scriptExecutor != null) {
            this.scriptExecutor.end();
        }
    }

    public void setContext(BillEntityType srcMainType, BillEntityType tgtMainType) {
        for (IConvertRuleSetPlugIn plugIn : this.plugIns) {
            plugIn.setContext(srcMainType, tgtMainType);
        }
    }

    public void fireLoadFuncTypes(LoadFuncTypesEventArgs e) {
        for (IConvertRuleSetPlugIn plugIn : this.plugIns) {
            plugIn.loadFuncTypes(e);
        }
    }
}

