/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;

public class BFRowComparator
implements Comparator<BFRow> {
    private Map<String, Set<String>> childBills = new HashMap<String, Set<String>>(8);
    private static final int MAX_SIZE_SORT = 100;

    public BFRowComparator(List<BFRow> rows) {
        String tBill;
        if (rows.size() > 100) {
            return;
        }
        LinkedHashMap<String, Set<String>> parentBills = new LinkedHashMap<String, Set<String>>(rows.size());
        for (BFRow row : rows) {
            String sBill = this.billIdToString(row.getSId());
            if (this.isCircle(parentBills, sBill, tBill = this.billIdToString(row.getId()))) continue;
            if (!parentBills.containsKey(tBill)) {
                parentBills.put(tBill, new HashSet(1));
            }
            ((Set)parentBills.get(tBill)).add(sBill);
            Set<String> set = this.childBills.get(sBill);
            if (set == null) {
                set = new HashSet<String>(8);
                this.childBills.put(sBill, set);
            }
            set.add(tBill);
        }
        for (int i = 0; i < parentBills.size() - 1; ++i) {
            for (Map.Entry item : parentBills.entrySet()) {
                tBill = (String)item.getKey();
                for (String sBill : (Set)item.getValue()) {
                    Set<String> parentSet = this.childBills.get(sBill);
                    Set<String> childSet = this.childBills.get(tBill);
                    if (childSet == null || childSet.contains(sBill)) continue;
                    if (parentSet == null) {
                        parentSet = new HashSet<String>(8);
                        this.childBills.put(sBill, parentSet);
                    }
                    parentSet.addAll(childSet);
                }
            }
        }
    }

    @Override
    public int compare(BFRow row1, BFRow row2) {
        String bill1 = this.billIdToString(row1.getSId());
        String bill2 = this.billIdToString(row2.getSId());
        Set<String> bill1Childs = this.childBills.get(bill1);
        Set<String> bill2Childs = this.childBills.get(bill2);
        if (bill1Childs != null && bill1Childs.contains(bill2) && bill2Childs != null && bill2Childs.contains(bill1)) {
            return 0;
        }
        if (bill1Childs != null && bill1Childs.contains(bill2)) {
            return -1;
        }
        if (bill2Childs != null && bill2Childs.contains(bill1)) {
            return 1;
        }
        return 0;
    }

    public static List<BFRow> compareLinkUpNodes(List<BFRowLinkUpNode> linkUpNodes) {
        ArrayList<BFRowLinkUpNode> parentNodes = new ArrayList<BFRowLinkUpNode>();
        for (BFRowLinkUpNode bFRowLinkUpNode : linkUpNodes) {
            parentNodes.add(bFRowLinkUpNode);
            parentNodes.addAll(bFRowLinkUpNode.findAllSourceNodes());
        }
        Collections.reverse(parentNodes);
        ArrayList<BFRow> rows = new ArrayList<BFRow>(parentNodes.size());
        for (BFRowLinkUpNode node : parentNodes) {
            if (node.getSNodes() == null || node.getSNodes().isEmpty()) continue;
            for (Map.Entry<BFRowId, BFRowLinkUpNode> entry : node.getSNodes().entrySet()) {
                BFRow row = new BFRow();
                row.setSId(entry.getKey());
                row.setId(node.getRowId());
                rows.add(row);
            }
        }
        try {
            BFRowComparator bFRowComparator = new BFRowComparator(rows);
            rows.sort(bFRowComparator);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return rows;
    }

    public static List<BFRow> compareLinkDownNodes(List<BFRowLinkDownNode> linkDownNodes) {
        ArrayList<BFRowLinkDownNode> childNodes = new ArrayList<BFRowLinkDownNode>();
        for (BFRowLinkDownNode bFRowLinkDownNode : linkDownNodes) {
            childNodes.add(bFRowLinkDownNode);
            childNodes.addAll(bFRowLinkDownNode.findAllChildNodes());
        }
        ArrayList<BFRow> rows = new ArrayList<BFRow>(childNodes.size());
        for (BFRowLinkDownNode node : childNodes) {
            if (node.getTNodes() == null || node.getTNodes().isEmpty()) continue;
            for (Map.Entry<BFRowId, BFRowLinkDownNode> entry : node.getTNodes().entrySet()) {
                BFRow row = new BFRow();
                row.setSId(node.getRowId());
                row.setId(entry.getKey());
                rows.add(row);
            }
        }
        try {
            BFRowComparator bFRowComparator = new BFRowComparator(rows);
            rows.sort(bFRowComparator);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return rows;
    }

    private String billIdToString(BFRowId rowId) {
        return String.format("%s,%s", rowId.getMainTableId(), rowId.getBillId());
    }

    private boolean isCircle(Map<String, Set<String>> parentBills, String sBillId, String tBillId) {
        Set<String> sBillId2s = parentBills.get(sBillId);
        if (sBillId2s == null) {
            return false;
        }
        if (sBillId2s.contains(tBillId)) {
            return true;
        }
        for (String sBillId2 : sBillId2s) {
            boolean circle2 = this.isCircle(parentBills, sBillId2, tBillId);
            if (!circle2) continue;
            return true;
        }
        return false;
    }
}

