/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp.runtime;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRBizRuleElement;
import kd.bos.entity.botp.runtime.CRBizRuleContext;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;

public abstract class CRBizRuleAction {
    private CRBizRuleContext bizRuleContext;
    private BillEntityType mainType;
    private CRBizRuleElement bizRule;
    private String preCondition;
    private ExpressionParameter preConditionParam;
    private Map<String, IDataEntityProperty> fieldProps = new HashMap<String, IDataEntityProperty>();

    public CRBizRuleContext getBizRuleContext() {
        return this.bizRuleContext;
    }

    public BillEntityType getMainType() {
        return this.mainType;
    }

    public CRBizRuleElement getBizRule() {
        return this.bizRule;
    }

    public String getPreCondition() {
        return this.preCondition;
    }

    public Map<String, IDataEntityProperty> getFieldProps() {
        return this.fieldProps;
    }

    public void setContext(CRBizRuleContext bizRuleContext) {
        this.bizRuleContext = bizRuleContext;
        this.mainType = bizRuleContext.getMainType();
        this.bizRule = bizRuleContext.getBizRule();
        if (this.bizRule.getPreCondition() != null) {
            this.preCondition = this.bizRule.getPreCondition().buildFullFormula((MainEntityType)this.mainType);
        }
    }

    public abstract String getEntityKey();

    public boolean checkPreCondition(RowDataModel rowDataModel, DynamicObject activeRow) {
        if (StringUtils.isBlank((CharSequence)this.preCondition)) {
            return true;
        }
        if (this.preConditionParam == null) {
            this.preConditionParam = new ExpressionParameter(this.preCondition, rowDataModel);
            this.preConditionParam.setFcunLib(this.bizRuleContext.getFuncLib());
        }
        this.preConditionParam.setActiveRow((Object)activeRow);
        boolean pass = (Boolean)CalcExprParser.getExpressionValue((ExpressionParameter)this.preConditionParam);
        return pass;
    }

    public final void doAction(ExtendedDataEntitySet extDataSet, RowDataModel rowDataModel, ExtendedDataEntity[] extDataEntities) {
        this.doConvert(extDataSet, rowDataModel, extDataEntities);
    }

    protected void doConvert(ExtendedDataEntitySet extDataSet, RowDataModel rowDataModel, ExtendedDataEntity[] extDataEntities) {
    }

    public final void doAction(RowDataModel rowDataModel, DynamicObject activeRow) {
        this.doWriteBack(rowDataModel, activeRow);
    }

    protected void doWriteBack(RowDataModel rowDataModel, DynamicObject activeRow) {
    }
}

