/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class SourceRowReport
implements Serializable {
    private static final long serialVersionUID = -951599353266206735L;
    private static final String BOS_ENTITY_CORE = "bos-botp-core";
    private Object entryId;
    private int entrySeq;
    private Object subEntryId;
    private int subEntrySeq;
    private List<String> failMessages = new ArrayList<String>(1);

    @KSMethod
    public Object getEntryId() {
        return this.entryId;
    }

    @KSMethod
    public void setEntryId(Object entryId) {
        this.entryId = entryId;
    }

    @KSMethod
    public int getEntrySeq() {
        return this.entrySeq;
    }

    @KSMethod
    public void setEntrySeq(int entrySeq) {
        this.entrySeq = entrySeq;
    }

    @KSMethod
    public Object getSubEntryId() {
        return this.subEntryId;
    }

    @KSMethod
    public void setSubEntryId(Object subEntryId) {
        this.subEntryId = subEntryId;
    }

    @KSMethod
    public int getSubEntrySeq() {
        return this.subEntrySeq;
    }

    @KSMethod
    public void setSubEntrySeq(int subEntrySeq) {
        this.subEntrySeq = subEntrySeq;
    }

    @KSMethod
    public List<String> getFailMessages() {
        return this.failMessages;
    }

    @KSMethod
    public String getRowInfo(SourceBillReport billReport) {
        Object billId = billReport == null ? null : billReport.getBillId();
        String billNo = billReport == null || StringUtils.isBlank((CharSequence)billReport.getBillNo()) ? String.valueOf(billId) : billReport.getBillNo();
        String entryName = billReport == null ? null : billReport.getEntryName();
        String subEntryName = billReport == null ? null : billReport.getSubEntryName();
        return this.getRowInfo(billNo, entryName, subEntryName);
    }

    @KSMethod
    public String getRowInfo(String billNo, String entryName, String subEntryName) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(String.format(ResManager.loadKDString((String)"\u5355\u636e(%s)", (String)"SourceRowReport_0", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), billNo));
        if (StringUtils.isNotBlank((CharSequence)entryName)) {
            if (this.entrySeq != 0) {
                sBuilder.append(", ").append(String.format(ResManager.loadKDString((String)"%1$s\u7b2c %2$d \u884c", (String)"SourceRowReport_5", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), entryName, this.entrySeq));
            } else {
                sBuilder.append(", ").append(String.format(ResManager.loadKDString((String)"%1$s\u6570\u636e\u884c(%2$s)", (String)"SourceRowReport_6", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), entryName, this.entryId));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)subEntryName)) {
            if (this.subEntrySeq != 0) {
                sBuilder.append(", ").append(String.format(ResManager.loadKDString((String)"%1$s\u7b2c %2$d \u884c", (String)"SourceRowReport_5", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), subEntryName, this.subEntrySeq));
            } else {
                sBuilder.append(", ").append(String.format(ResManager.loadKDString((String)"%1$s\u6570\u636e\u884c(%2$d)", (String)"SourceRowReport_7", (String)BOS_ENTITY_CORE, (Object[])new Object[0]), subEntryName, this.subEntrySeq));
            }
        }
        return sBuilder.toString();
    }

    public String getFailMessage() {
        if (this.failMessages.isEmpty()) {
            return ResManager.loadKDString((String)"\u8f6c\u6362\u6210\u529f", (String)"SourceRowReport_4", (String)BOS_ENTITY_CORE, (Object[])new Object[0]);
        }
        return this.failMessages.get(0);
    }

    @SdkInternal
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.entryId == null ? 0 : this.entryId.hashCode());
        result = 31 * result + this.entrySeq;
        result = 31 * result + (this.subEntryId == null ? 0 : this.subEntryId.hashCode());
        result = 31 * result + this.subEntrySeq;
        return result;
    }

    @SdkInternal
    public boolean equals(Object obj) {
        if (!(obj instanceof SourceRowReport)) {
            return false;
        }
        SourceRowReport other = (SourceRowReport)obj;
        return this.equalsValue(this.entryId, other.getEntryId()) && this.entrySeq == other.getEntrySeq() && this.equalsValue(this.subEntryId, other.getSubEntryId()) && this.subEntrySeq == other.getSubEntrySeq();
    }

    private boolean equalsValue(Object v1, Object v2) {
        if (v1 == null) {
            return v2 == null;
        }
        return v1.equals(v2);
    }
}

