/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.link.CtBillLinkService;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.CtTenantData;
import kd.bos.entity.ctbotp.constants.SourceOperateEnum;
import kd.bos.entity.ctbotp.constants.SyncTypeEnum;
import kd.bos.entity.ctbotp.link.CtLkUpQueryArgs;
import kd.bos.entity.ctbotp.runtime.AbstractCtConvertServiceArgs;
import kd.bos.entity.ctbotp.runtime.CtConvertOpParameter;
import kd.bos.entity.ctbotp.runtime.CtConvertOperationResult;
import kd.bos.entity.ctbotp.runtime.CtOpInfo;
import kd.bos.entity.ctbotp.runtime.CtPushArgs;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.LongProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.CtConvertMetaServiceHelper;
import kd.bos.servicehelper.CtConvertServiceHelper;

public class CtPush
extends DefaultDynamicFormOperate {
    public static final String AllRule = "@all";
    private MainEntityType srcMainType;
    private CtConvertOpParameter opParameter;
    private String tTenantCode = "";
    private String tAccountId = "";
    private String syncType = "";
    private boolean hidePushForm = false;
    private String defTargetBill = "";
    private String defRuleId = "";
    private String defRuleIdPara = "";
    private boolean hasNewRight = false;
    private boolean mustSelectRule = false;
    private static final String BOS_FORM_BUSINESS = "bos-botp-business";
    private static final Log LOG = LogFactory.getLog(CtPush.class);

    public void initialize(Map<String, Object> arg0) {
        super.initialize(arg0);
        Map parameters = (Map)arg0.get("parameter");
        if (parameters != null) {
            if (parameters.containsKey("ttenantcode")) {
                this.tTenantCode = (String)parameters.get("ttenantcode");
            }
            if (parameters.containsKey("taccountid")) {
                this.tAccountId = (String)parameters.get("taccountid");
            }
            if (parameters.containsKey("synctype")) {
                this.syncType = (String)parameters.get("synctype");
            }
            if (parameters.containsKey("hidepushform")) {
                this.hidePushForm = (Boolean)parameters.get("hidepushform");
            }
            if (parameters.containsKey("targetbill")) {
                this.defTargetBill = (String)parameters.get("targetbill");
                if (StringUtils.isBlank((CharSequence)this.defTargetBill)) {
                    this.hidePushForm = false;
                }
            }
            if (parameters.containsKey("ruleid")) {
                this.defRuleId = (String)parameters.get("ruleid");
                this.defRuleIdPara = (String)parameters.get("ruleid");
                if (StringUtils.isBlank((CharSequence)this.defRuleId)) {
                    this.defRuleId = AllRule;
                }
            }
            if (parameters.containsKey("ishasright")) {
                this.hasNewRight = (Boolean)parameters.get("ishasright");
            }
            if (parameters.containsKey("mustselectrule")) {
                this.mustSelectRule = (Boolean)parameters.get("mustselectrule");
            }
        }
    }

    public MainEntityType getSrcMainType() {
        if (this.srcMainType == null) {
            this.srcMainType = EntityMetadataCache.getDataEntityType((String)this.getEntityId());
        }
        return this.srcMainType;
    }

    protected boolean beforeInvokeOperation(OperationResult result) {
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        if (this.getView() instanceof IBillView) {
            String pkValue;
            IBillModel billModel = (IBillModel)this.getView().getModel();
            String string = pkValue = billModel.getPKValue() == null ? "" : billModel.getPKValue().toString();
            if (StringUtils.isBlank((CharSequence)pkValue) || pkValue.equals("0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"Push_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                return false;
            }
        }
        this.opParameter = this.buildParameter();
        List<CtTenantData> ctTenantData = CtConvertMetaServiceHelper.loadTenantDatas(RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), this.getEntityId());
        if (ctTenantData == null || ctTenantData.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6b63\u5e38\u542f\u7528\u7684\u8f6c\u6362\u8def\u7ebf\u3002", (String)"Draw_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected OperationResult invokeOperation() {
        if (this.opParameter.getSelectedRows() == null || this.opParameter.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u9700\u8981\u4e0b\u63a8\u7684\u6570\u636e", (String)"Push_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return null;
        }
        if (!this.hidePushForm) {
            this.showPushForm();
            return null;
        }
        this.doPush();
        return null;
    }

    protected void afterInvokeOperation(OperationResult opResult) {
    }

    protected CtConvertOpParameter buildParameter() {
        CtConvertOpParameter opParameter = new CtConvertOpParameter();
        String appId = this.getOption().getVariableValue("checkRightAppId", "");
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            opParameter.setAppId(appId);
        }
        String entityNumber = this.getEntityId();
        opParameter.setEntityNumber(entityNumber);
        if (this.getView() instanceof IListView) {
            IListView listView = (IListView)this.getView();
            opParameter.setSelectedRows(listView.getSelectedRows());
        } else if (this.getView() instanceof IBillView) {
            IBillView billView = (IBillView)this.getView();
            IBillModel billModel = (IBillModel)billView.getModel();
            ListSelectedRow row = new ListSelectedRow(billModel.getPKValue(), Boolean.valueOf(billModel.getDataEntityType().getPrimaryKey() instanceof LongProp));
            this.getAndSetBillNo(billModel, row);
            opParameter.setSelectedRows(new ListSelectedRowCollection());
            opParameter.getSelectedRows().add((Object)row);
            opParameter.getCustomParams().put("ctbotp_isstrict", String.valueOf(false));
        }
        opParameter.settTenantCode(this.tTenantCode);
        opParameter.settAccountId(this.tAccountId);
        opParameter.setDefTargetBill(this.defTargetBill);
        opParameter.setDefRuleId(this.defRuleId);
        opParameter.setHasRight(this.hasNewRight);
        opParameter.setMustSelectRule(this.mustSelectRule);
        opParameter.setDefRuleIdPara(this.defRuleIdPara);
        if (this.getOption() != null) {
            opParameter.getCustomParams().putAll(this.getOption().getVariables());
        }
        return opParameter;
    }

    private void getAndSetBillNo(IBillModel billModel, ListSelectedRow row) {
        MainEntityType entityType = billModel.getDataEntityType();
        if (entityType instanceof BillEntityType) {
            BillEntityType billEntityType = (BillEntityType)entityType;
            if (StringUtils.isEmpty((CharSequence)billEntityType.getBillNo())) {
                return;
            }
            String billNoValue = (String)billModel.getValue(billEntityType.getBillNo());
            if (StringUtils.isEmpty((CharSequence)billNoValue)) {
                return;
            }
            row.setBillNo(billNoValue);
        }
    }

    private void showPushForm() {
        String opParameterJson = SerializationUtils.toJsonString((Object)this.opParameter);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ctbotp_convertop");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("opinfo", SerializationUtils.toJsonString((Object)this.getOpInfo()));
        showParameter.getCustomParams().put("opparam", opParameterJson);
        showParameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u534f\u540c", (String)"CtPush_4", (String)"bos-ctbotp-business", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private CtOpInfo getOpInfo() {
        CtOpInfo opInfo = new CtOpInfo();
        opInfo.setOpKey(this.getOperateKey());
        opInfo.setOpName(this.getOperateName());
        opInfo.setOpType(this.getType());
        return opInfo;
    }

    private void doPush() {
        CtPushArgs pushArgs = new CtPushArgs();
        pushArgs.setHasRight(this.opParameter.isHasRight());
        pushArgs.setSourceEntityNumber(this.opParameter.getEntityNumber());
        pushArgs.setTargetEntityNumber(this.defTargetBill);
        pushArgs.setAutoSave(true);
        pushArgs.settTenantCode(this.tTenantCode);
        pushArgs.settAccountId(this.tAccountId);
        pushArgs.setSyncType(this.syncType);
        pushArgs.setSourceOperate(SourceOperateEnum.OPERATE.getValue());
        pushArgs.setRuleId(this.defRuleId);
        pushArgs.setSelectedRows((List)this.opParameter.getSelectedRows());
        pushArgs.setBuildConvReport(true);
        pushArgs.getCustomParams().putAll(this.opParameter.getCustomParams());
        pushArgs.setOpInfo(this.getOpInfo());
        CtPush.addPushByBillOption(this.getView(), (AbstractCtConvertServiceArgs)pushArgs);
        if (SyncTypeEnum.REVERSE.getValue().equals(this.syncType)) {
            List ids = pushArgs.getSelectedRows().stream().map(a -> Long.parseLong(a.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            CtLkUpQueryArgs ctLkUpQueryArgs = new CtLkUpQueryArgs();
            ctLkUpQueryArgs.settTenantCode(RequestContext.get().getTenantCode());
            ctLkUpQueryArgs.settAccountId(RequestContext.get().getAccountId());
            ctLkUpQueryArgs.settEntityKey(pushArgs.getSourceEntityNumber());
            ctLkUpQueryArgs.settBillIds(ids);
            List ctBillLks = CtBillLinkService.getCtDirtBillLkUp((CtLkUpQueryArgs)ctLkUpQueryArgs);
            pushArgs.setCtBillLks(ctBillLks);
        }
        CtConvertOperationResult ctConvertOperationResult = CtConvertServiceHelper.ctPush(pushArgs);
        CtPush.showReport(this.getView(), (AbstractCtConvertServiceArgs)pushArgs, ctConvertOperationResult);
    }

    public static void addPushByBillOption(IFormView view, AbstractCtConvertServiceArgs args) {
        ListShowParameter showParameter;
        if (view instanceof IListView && (showParameter = (ListShowParameter)view.getFormShowParameter()).getListUserOption() != null && showParameter.getListUserOption().isMergeRow()) {
            args.addCustomParam("botp_pushByBill", String.valueOf(true));
        }
    }

    public static void showReport(IFormView view, AbstractCtConvertServiceArgs convertArgs, CtConvertOperationResult convertResult) {
        if (convertResult == null || convertResult.getReporter() == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u4e0b\u63a8\u7ed3\u679c\u4e3a\u7a7a", (String)"CtPush_5", (String)"bos-ctbotp-business", (Object[])new Object[0]));
            return;
        }
        String resultJson = SerializationUtils.toJsonString((Object)convertResult);
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        pageCache.put("CtConvertOperationResult", resultJson);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ctbotp_convertreport");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getOpenStyle().setInlineStyleCss(new StyleCss());
        showParameter.getOpenStyle().getInlineStyleCss().setHeight("410px");
        showParameter.getOpenStyle().getInlineStyleCss().setWidth("850px");
        showParameter.setShowTitle(true);
        showParameter.getCustomParams().put("ctconvertresultpageid", view.getPageId());
        showParameter.getCustomParams().put("cttargetentitynumber", convertArgs.getTargetEntityNumber());
        showParameter.getCustomParams().put("ctreleaseresult", String.valueOf(true));
        view.showForm(showParameter);
    }
}

