/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ctbotp.CtSearchLinkBill;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;

public class TenantTrackUp
extends DefaultDynamicFormOperate
implements Serializable {
    private static final String BOS_CTBOTP_BUSINESS = "bos-ctbotp-business";
    private static final long serialVersionUID = -6823672297718780978L;
    private static final String TRACKUP_SRCBILLIDS = "Track_Up_SrcBillIds";
    private static final String TRACKUP_SRCENTITYNUMBER = "Track_Up_SrcEntityNumber";
    private static final String TRACKUP_SRCTENANTCODES = "Track_Down_SrcTenantCodes";
    private static final String TRACKUP_SRCACCOUNTIDS = "Track_Down_SrcAccountIds";

    protected OperationResult invokeOperation() {
        CtSearchLinkBill ctSearchLinkBill = this.getSelectedBillIds(true);
        this.showSourceBillList(ctSearchLinkBill);
        return null;
    }

    private void showSourceBillList(CtSearchLinkBill ctSearchLinkBill) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setBillFormId("bos_ctbotp_trackup");
        listShowParameter.getCustomParams().put("bos_call_source_type", "ct_botp_track_up");
        listShowParameter.getCustomParams().put(TRACKUP_SRCBILLIDS, ctSearchLinkBill.getSrcBillIds());
        listShowParameter.getCustomParams().put(TRACKUP_SRCENTITYNUMBER, ctSearchLinkBill.getSrcEntityNumber());
        listShowParameter.getCustomParams().put(TRACKUP_SRCTENANTCODES, ctSearchLinkBill.getsTenantCodes());
        listShowParameter.getCustomParams().put(TRACKUP_SRCACCOUNTIDS, ctSearchLinkBill.getsAccountId());
        Set srcBillIds = ctSearchLinkBill.getSrcBillIds().keySet();
        if (CollectionUtils.isEmpty(srcBillIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u5173\u7cfb\u3002", (String)"TenantTrackUp_0", (String)BOS_CTBOTP_BUSINESS, (Object[])new Object[0]));
        } else {
            for (Long billId : srcBillIds) {
                listShowParameter.addLinkQueryPkId((Object)billId);
            }
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    protected CtSearchLinkBill getSelectedBillIds(boolean isTenantTrackUp) {
        IBillView billView;
        IBillModel billModel;
        HashSet<Long> billIds = new HashSet<Long>(8);
        if (this.getView() instanceof IListView) {
            IListView listView = (IListView)this.getView();
            for (ListSelectedRow row : listView.getSelectedRows()) {
                Long billId;
                if (!(row.getPrimaryKeyValue() instanceof Long) || billIds.contains(billId = (Long)row.getPrimaryKeyValue())) continue;
                billIds.add(billId);
            }
        } else if (this.getView() instanceof IBillView && (billModel = (IBillModel)(billView = (IBillView)this.getView()).getModel()).getPKValue() instanceof Long) {
            Long billId = (Long)billModel.getPKValue();
            billIds.add(billId);
        }
        RequestContext ctx = RequestContext.get();
        String tenantId = ctx.getTenantId();
        String accountId = ctx.getAccountId();
        String formId = null;
        QFilter qFilter = null;
        if (isTenantTrackUp) {
            formId = "bos_ctbotp_synclog_t";
            qFilter = new QFilter("tbillid", "in", billIds).and(new QFilter("ttenantcode", "=", (Object)tenantId)).and(new QFilter("taccountid", "=", (Object)accountId));
        } else {
            formId = "bos_ctbotp_synclog_t";
            qFilter = new QFilter("sbillid", "in", billIds).and(new QFilter("stenantcode", "=", (Object)tenantId)).and(new QFilter("saccountid", "=", (Object)accountId));
        }
        String selectPropStr = "id,sentitykey,tentitykey,sbillid,tbillid,stenantcode,saccountid,ttenantcode,taccountid";
        DynamicObject[] billLinks = BusinessDataServiceHelper.load((String)formId, (String)selectPropStr, (QFilter[])new QFilter[]{qFilter});
        CtSearchLinkBill ctSearchLinkBill = new CtSearchLinkBill();
        HashMap<Long, Long> tarBillIds = new HashMap<Long, Long>(billLinks.length);
        HashMap<Long, Long> srcBillIds = new HashMap<Long, Long>(billLinks.length);
        HashMap<Long, String> sTenantCodes = new HashMap<Long, String>(billLinks.length);
        HashMap<Long, String> sAccountId = new HashMap<Long, String>(billLinks.length);
        HashMap<Long, String> tTenantCode = new HashMap<Long, String>(billLinks.length);
        HashMap<Long, String> tAccountId = new HashMap<Long, String>(billLinks.length);
        for (DynamicObject billdata : billLinks) {
            ctSearchLinkBill.setSrcEntityNumber(billdata.getString("sentitykey"));
            ctSearchLinkBill.setTarEntityNumber(billdata.getString("tentitykey"));
            tarBillIds.put(billdata.getLong("id"), billdata.getLong("tbillid"));
            srcBillIds.put(billdata.getLong("id"), billdata.getLong("sbillid"));
            sTenantCodes.put(billdata.getLong("id"), billdata.getString("stenantcode"));
            sAccountId.put(billdata.getLong("id"), billdata.getString("saccountid"));
            tTenantCode.put(billdata.getLong("id"), billdata.getString("ttenantcode"));
            tAccountId.put(billdata.getLong("id"), billdata.getString("taccountid"));
        }
        ctSearchLinkBill.setTarBillIds(tarBillIds);
        ctSearchLinkBill.setSrcBillIds(srcBillIds);
        ctSearchLinkBill.setsTenantCodes(sTenantCodes);
        ctSearchLinkBill.setsAccountId(sAccountId);
        ctSearchLinkBill.settTenantCode(tTenantCode);
        ctSearchLinkBill.settAccountId(tAccountId);
        return ctSearchLinkBill;
    }
}

