/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ctbotp;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ctbotp.dto.DistributionSchemeDto;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CtBillInfoListPlugin
extends AbstractListPlugin {
    private static Log log = LogFactory.getLog(CtBillInfoListPlugin.class);
    private static final String MAINDATA_CHECK = "maindatacheck";
    private static final String FORMID_MAINDATACHECK = "ct_botp_maindatacheck";
    private static final String LISTHYPERLINK_SELECT_FIELDS = "id,tenantcode,accountnumber,acccountid,billnumber,checkdate,modifier";
    private static final String BOS_CTBOTP_FORMPLUGIN = "bos-ctbotp-formplugin";

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String barItemKey = evt.getItemKey();
        if (barItemKey.equalsIgnoreCase(MAINDATA_CHECK)) {
            if (this.getSelectedRows().size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"CtConvertRuleListPlugin_2", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", this.getSelectedRows().get(0).getPrimaryKeyValue())};
            DynamicObjectCollection collection = ORM.create().query("ct_botp_billinfos", LISTHYPERLINK_SELECT_FIELDS, filters);
            ArrayList<DistributionSchemeDto> dtoList = new ArrayList<DistributionSchemeDto>(collection.size());
            for (DynamicObject dynamicObject : collection) {
                DistributionSchemeDto dto = new DistributionSchemeDto();
                String tenantCode = dynamicObject.getString("tenantcode");
                String accountNumber = dynamicObject.getString("accountnumber");
                String acccountId = dynamicObject.getString("acccountid");
                String billNumber = dynamicObject.getString("billnumber");
                dto.setTenantCode(tenantCode);
                dto.setAccountNumber(accountNumber);
                dto.setAcccountId(acccountId);
                dto.setEntityId(billNumber);
                dtoList.add(dto);
                dynamicObject.set("checkdate", (Object)new Date());
                dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
                SaveServiceHelper.update((DynamicObject)dynamicObject);
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(FORMID_MAINDATACHECK);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.getCustomParams().put("dtoList", SerializationUtils.toJsonString(dtoList));
            this.getView().showForm(showParameter);
        }
    }
}

