/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ctbotp;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.ctbotp.CtBizAppTreeBuilder;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;

public class CtConvertRuleTreeListPlugin
extends AbstractTreeListPlugin {
    private static final String KEY_SOURCEBIZAPPID = "sourcebizappid";
    private static final String KEY_TARGETBIZAPPID = "targetbizappid";
    private static final String PNL_TREEBTNLIST = "flexpanel_treebtn";
    private static final String CACHE_APPNODES = "appnodes";
    private String currNodeId;

    public void initTreeToolbar(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PNL_TREEBTNLIST});
    }

    public void refreshNode(RefreshNodeEvent e) {
        CtBizAppTreeBuilder bizAppTreeBuilder = this.getBizAppTreeBuilder((AbstractFormPlugin)this, CACHE_APPNODES);
        List nodes = bizAppTreeBuilder.getRootNode().getChildren();
        TreeNode currNode = null;
        String nodeId = (String)e.getNodeId();
        if (StringUtils.isNotBlank((CharSequence)nodeId)) {
            for (TreeNode node : nodes) {
                if (StringUtils.equals((CharSequence)node.getId(), (CharSequence)nodeId)) {
                    currNode = node;
                    break;
                }
                TreeNode childNode = node.getTreeNode(nodeId, 5);
                if (childNode == null) continue;
                currNode = childNode;
                break;
            }
        }
        if (currNode != null) {
            e.setChildNodes(currNode.getChildren());
        } else {
            e.setChildNodes(nodes);
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        this.currNodeId = String.valueOf(e.getNodeId());
        super.treeNodeClick(e);
    }

    protected QFilter nodeClickFilter() {
        return this.buildAppQFilter(this.currNodeId, CACHE_APPNODES);
    }

    private CtBizAppTreeBuilder getBizAppTreeBuilder(AbstractFormPlugin plugin, String cacheKey) {
        String json = plugin.getPageCache().get(cacheKey);
        CtBizAppTreeBuilder bizAppTreeBuilder = null;
        if (StringUtils.isBlank((CharSequence)json)) {
            bizAppTreeBuilder = new CtBizAppTreeBuilder();
            bizAppTreeBuilder.setRuntime(true);
            bizAppTreeBuilder.buildTree();
            json = SerializationUtils.toJsonString((Object)bizAppTreeBuilder);
            plugin.getPageCache().put(cacheKey, json);
        } else {
            bizAppTreeBuilder = (CtBizAppTreeBuilder)SerializationUtils.fromJsonString((String)json, CtBizAppTreeBuilder.class);
        }
        return bizAppTreeBuilder;
    }

    public QFilter buildAppQFilter(String nodeId, String nodesCacheKey) {
        HashSet<String> appIds = new HashSet<String>();
        CtBizAppTreeBuilder bizAppTreeBuilder = this.getBizAppTreeBuilder((AbstractFormPlugin)this, nodesCacheKey);
        List currNodes = bizAppTreeBuilder.getRootNode().getChildPathNodes(nodeId);
        if (currNodes.isEmpty()) {
            return null;
        }
        if (currNodes.size() == 1) {
            return null;
        }
        if (currNodes.size() == 2) {
            TreeNode bizCloudNode = (TreeNode)currNodes.get(1);
            if (bizCloudNode.getChildren() == null || bizCloudNode.getChildren().isEmpty()) {
                appIds.add(bizCloudNode.getId());
            } else {
                for (TreeNode bizAppNode : bizCloudNode.getChildren()) {
                    appIds.add(bizAppNode.getId());
                    appIds.addAll((Collection)bizAppTreeBuilder.getAppExtIds().get(bizAppNode.getId()));
                }
            }
        } else if (currNodes.size() > 2) {
            TreeNode bizAppNode = (TreeNode)currNodes.get(2);
            appIds.add(bizAppNode.getId());
            appIds.addAll((Collection)bizAppTreeBuilder.getAppExtIds().get(bizAppNode.getId()));
        }
        if (appIds.isEmpty()) {
            return null;
        }
        if (appIds.size() == 0) {
            return new QFilter(KEY_SOURCEBIZAPPID, "=", appIds.iterator().next()).or(KEY_TARGETBIZAPPID, "=", appIds.iterator().next());
        }
        return new QFilter(KEY_SOURCEBIZAPPID, "in", (Object)appIds.toArray(new String[appIds.size()])).or(KEY_TARGETBIZAPPID, "in", (Object)appIds.toArray(new String[appIds.size()]));
    }
}

