/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ctbotp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.ctbotp.CtRuleCacheHelper;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.CRPlugin;
import kd.bos.entity.ctbotp.CtAttachmentPanelMapItem;
import kd.bos.entity.ctbotp.CtAttachmentPanelMapPolicy;
import kd.bos.entity.ctbotp.CtBillTypeMapItem;
import kd.bos.entity.ctbotp.CtBillTypeMapPolicy;
import kd.bos.entity.ctbotp.CtCRCondition;
import kd.bos.entity.ctbotp.CtCRValByConditions;
import kd.bos.entity.ctbotp.CtConvertRuleElement;
import kd.bos.entity.ctbotp.CtFieldConvertType;
import kd.bos.entity.ctbotp.CtFieldMapItem;
import kd.bos.entity.ctbotp.CtFieldMapPolicy;
import kd.bos.entity.ctbotp.CtFieldSumType;
import kd.bos.entity.ctbotp.CtFilterPolicy;
import kd.bos.entity.ctbotp.CtGroupByMode;
import kd.bos.entity.ctbotp.CtGroupByPolicy;
import kd.bos.entity.ctbotp.CtLinkEntityPolicy;
import kd.bos.entity.ctbotp.CtPlugInPolicy;
import kd.bos.entity.ctbotp.apiparam.CtAutoMatchFieldsReq;
import kd.bos.entity.ctbotp.apiparam.CtFieldCaptionReq;
import kd.bos.entity.ctbotp.apiparam.CtMainEntityTypeReq;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.dto.DynamicPropertyDto;
import kd.bos.entity.ctbotp.dto.MainEntityTypeDto;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;

public class CtGetRuleHelper {
    private static final String BOS_CTBOTP_PLUGIN = "bos-ctbotp-formplugin";
    private IFormView view;
    private AbstractFormPlugin plugin;

    public CtGetRuleHelper(IFormView view, AbstractFormPlugin plugin) {
        this.view = view;
        this.plugin = plugin;
    }

    private IFormView getView() {
        return this.view;
    }

    private IDataModel getModel() {
        return this.view.getModel();
    }

    private IPageCache getPageCache() {
        return this.view.getPageCache();
    }

    public CtConvertRuleElement getRule(CtConvertRuleElement rule) {
        this.getModel().getDataEntity(true);
        this.getBaseInfo(rule);
        if (StringUtils.isBlank((CharSequence)rule.getSourceEntityNumber()) || StringUtils.isBlank((CharSequence)rule.getTargetEntityNumber())) {
            return rule;
        }
        this.getLinkEntryPolicy(rule);
        this.getBillTypeMapPolicy(rule);
        this.getFieldMapPolicy(rule);
        this.getAttachmentPanelMapPolicy(rule);
        this.getGroupByPolicy(rule);
        this.getFilterPolicyPolicy(rule);
        this.getPluginPolicy(rule);
        this.getOptionPolicy(rule);
        return rule;
    }

    private void getBaseInfo(CtConvertRuleElement rule) {
        String localeId = RequestContext.get().getLang().toString();
        if (rule.getName() == null) {
            rule.setName(new LocaleString());
        }
        rule.getName().setItem(localeId, (Object)((String)this.getModel().getValue("fname")));
        rule.getsBizAppName().setItem(localeId, (Object)((String)this.getModel().getValue("fsbizappname")));
        rule.getSourceEntityName().setItem(localeId, (Object)((String)this.getModel().getValue("fsourceentityname")));
        rule.gettBizAppName().setItem(localeId, (Object)((String)this.getModel().getValue("ftbizappname")));
        rule.getTargetEntityName().setItem(localeId, (Object)((String)this.getModel().getValue("ftargetentityname")));
        rule.setEnabled(((Boolean)this.getModel().getValue("fenabled")).booleanValue());
        boolean mirrorsync = (Boolean)this.getModel().getValue("fmirrorsync");
        rule.setMirrorSync(mirrorsync);
        if (!mirrorsync) {
            rule.setMirrorUpdate(false);
        } else {
            rule.setMirrorUpdate(((Boolean)this.getModel().getValue("fmirrorupdate")).booleanValue());
        }
        rule.setSyncType((String)this.getModel().getValue("synctype"));
        DynamicObject tenantPath = (DynamicObject)this.getModel().getValue("tenantpath");
        if (tenantPath == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6807\u8bc6\u4e3a:%s\u7684\u89c4\u5219\u672a\u7ed1\u5b9a\u79df\u6237\u8def\u7ebf\u3002", (String)"CtConvertRuleEdit_59", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]), rule.getId()));
        }
        rule.setTenantPath(tenantPath.getString("number"));
        String runConditionJson = (String)this.getModel().getValue("fruncondition");
        if (StringUtils.isBlank((CharSequence)runConditionJson)) {
            rule.setCtCRCondition(null);
        } else {
            CtCRCondition condition = (CtCRCondition)SerializationUtils.fromJsonString((String)runConditionJson, CtCRCondition.class);
            rule.setCtCRCondition(condition);
        }
        CtRuleCacheHelper.setTenantInfo(rule);
    }

    private void getLinkEntryPolicy(CtConvertRuleElement rule) {
        CtLinkEntityPolicy policy = rule.getCtLinkEntityPolicy();
        if (rule.isMirrorSync()) {
            String targetLinkEntry = (String)this.getModel().getValue("ftargetentrykey");
            String targetLinkEntityKeys = (String)this.getModel().getValue("ftargetlkentitykeys");
            String sourceLinkEntityKeys = (String)this.getModel().getValue("fsourcelkentitykeys");
            String sourceLinkEntry = (String)this.getModel().getValue("fsourceentrykey");
            policy.setTargetEntryKey(targetLinkEntry);
            policy.setTargetEntityKeys(targetLinkEntityKeys);
            policy.setSourceEntryKey(sourceLinkEntry);
            policy.setSourceEntityKeys(sourceLinkEntityKeys);
        } else {
            String targetLinkEntry = (String)this.getModel().getValue("ftargetentrykey");
            String targetLinkEntityKeys = (String)this.getModel().getValue("ftargetlkentitykeys");
            String targetLinkSubEntry = (String)this.getModel().getValue("ftargetsubentrykey");
            String sourceLinkEntry = (String)this.getModel().getValue("fsourceentrykey");
            String sourceLinkEntityKeys = (String)this.getModel().getValue("fsourcelkentitykeys");
            String sourceLinkSubEntry = (String)this.getModel().getValue("fsourcesubentrykey");
            policy.setTargetEntryKey(targetLinkEntry);
            policy.setTargetEntityKeys(targetLinkEntityKeys);
            policy.setTargetSubEntryKey(targetLinkSubEntry);
            policy.setSourceEntryKey(sourceLinkEntry);
            policy.setSourceEntityKeys(sourceLinkEntityKeys);
            policy.setSourceSubEntryKey(sourceLinkSubEntry);
        }
    }

    public void getBillTypeMapPolicy(CtConvertRuleElement rule) {
        CtBillTypeMapPolicy policy = rule.getCtBillTypeMapPolicy();
        policy.getItems().clear();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("billtypemappolicy");
        int seq = 1;
        for (DynamicObject row : rows) {
            CtBillTypeMapItem mapItem = new CtBillTypeMapItem();
            mapItem.setId(row.getString("billtypemapitemid"));
            mapItem.setSeq(seq);
            String sourceType = row.getString("sourcebilltype");
            if (StringUtils.equalsIgnoreCase((CharSequence)sourceType, (CharSequence)"All")) {
                mapItem.setSourceType("All");
                mapItem.setSourceBillTypeId(0L);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)sourceType, (CharSequence)"Others")) {
                mapItem.setSourceType("Others");
                mapItem.setSourceBillTypeId(0L);
            } else if (StringUtils.isNotBlank((CharSequence)sourceType)) {
                mapItem.setSourceType("Spec");
                mapItem.setSourceBillTypeId(Long.parseLong(sourceType));
            } else {
                mapItem.setSourceType("Spec");
                mapItem.setSourceBillTypeId(0L);
            }
            String pushType = row.getString("pushtype");
            String targetBillTypeId = row.getString("targetbilltype");
            mapItem.setPushType(pushType);
            if (StringUtils.isBlank((CharSequence)targetBillTypeId)) {
                mapItem.setTargetBillTypeId(0L);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)pushType, (CharSequence)"Spec") || StringUtils.equalsIgnoreCase((CharSequence)pushType, (CharSequence)"NoSpec")) {
                mapItem.setTargetBillTypeId(Long.parseLong(targetBillTypeId));
            } else {
                mapItem.setTargetBillTypeId(0L);
            }
            policy.getItems().add(mapItem);
            ++seq;
        }
    }

    public void getAttachmentPanelMapPolicy(CtConvertRuleElement rule) {
        CtAttachmentPanelMapPolicy policy = rule.getCtAttachmentPanelMapPolicy();
        policy.getItems().clear();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("attachmentpanelmappolicy");
        int seq = 1;
        for (DynamicObject row : rows) {
            CtAttachmentPanelMapItem mapItem = new CtAttachmentPanelMapItem();
            mapItem.setId(row.getString("attachmentpanelmapitemid"));
            mapItem.setSeq(seq);
            String sourceAttachmentPanel = row.getString("sourceattachmentpanel");
            mapItem.setSourceAttachmentPanel(sourceAttachmentPanel);
            String targetAttachmentPanel = row.getString("targetattachmentpanel");
            mapItem.setTargetAttachmentPanel(targetAttachmentPanel);
            String attachmentPanelMergeType = row.getString("attachmentmergetype");
            mapItem.setAttachmentPanelMergeType(attachmentPanelMergeType);
            policy.getItems().add(mapItem);
            ++seq;
        }
    }

    private void getFieldMapPolicy(CtConvertRuleElement rule) {
        String localeId = RequestContext.get().getLang().toString();
        CtFieldMapPolicy policy = rule.getCtFieldMapPolicy();
        policy.getCtFieldMapItems().clear();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("fieldmappolicy");
        for (DynamicObject row : rows) {
            CtFieldMapItem item = new CtFieldMapItem();
            String targetFieldKey = row.getString("ftargetfield");
            String targetentitykeys = row.getString("ftargetentitykeys");
            String targetFieldType = row.getString("ftargetfieldtype");
            if (StringUtils.isBlank((CharSequence)targetFieldKey)) continue;
            String tFieldBaseDataNumber = row.getString("ftbasedataentitytype");
            item.setTargetFieldKey(targetFieldKey);
            item.setTargetEntityKeys(targetentitykeys);
            item.setTargetFieldType(targetFieldType);
            item.setTargetFieldBaseDataNumber(tFieldBaseDataNumber);
            String convertTypeFldValue = row.getString("fconverttype");
            int convertType = StringUtils.isBlank((CharSequence)convertTypeFldValue) ? CtFieldConvertType.SourceField.getValue() : Integer.parseInt(convertTypeFldValue);
            String sourceFieldKey = row.getString("fsourcefield");
            String formula = row.getString("ffieldformula");
            if (CtFieldConvertType.SourceField.getValue() == convertType) {
                item.setCtFieldConvertType(CtFieldConvertType.SourceField);
                item.setSourceFieldKey(sourceFieldKey);
            } else if (CtFieldConvertType.Formula.getValue() == convertType) {
                item.setCtFieldConvertType(CtFieldConvertType.Formula);
                if (StringUtils.isNotBlank((CharSequence)formula)) {
                    CRFormula crFormula = (CRFormula)SerializationUtils.fromJsonString((String)formula, CRFormula.class);
                    item.setFormula(crFormula);
                }
            } else if (CtFieldConvertType.ByCondition.getValue() == convertType) {
                item.setCtFieldConvertType(CtFieldConvertType.ByCondition);
                if (StringUtils.isNotBlank((CharSequence)formula)) {
                    CtCRValByConditions valByConditions = (CtCRValByConditions)SerializationUtils.fromJsonString((String)formula, CtCRValByConditions.class);
                    item.setValByConditions(valByConditions);
                }
            } else if (CtFieldConvertType.CONSTANT.getValue() == convertType) {
                item.setCtFieldConvertType(CtFieldConvertType.CONSTANT);
                if (StringUtils.isNotBlank((CharSequence)formula)) {
                    CRFormula constant = (CRFormula)SerializationUtils.fromJsonString((String)formula, CRFormula.class);
                    item.setConstant(constant);
                }
            }
            String sumTypeFldValue = row.getString("fsumtype");
            int sumType = StringUtils.isBlank((CharSequence)sumTypeFldValue) ? CtFieldSumType.First.getValue() : Integer.parseInt(sumTypeFldValue);
            item.setCtFieldSumType(CtFieldSumType.valueOf((int)sumType));
            policy.getCtFieldMapItems().add(item);
        }
    }

    private void getGroupByPolicy(CtConvertRuleElement rule) {
        IDataModel model = this.getModel();
        CtGroupByPolicy policy = rule.getCtGroupByPolicy();
        int comboInt = Integer.parseInt((String)this.getModel().getValue("g_billcombo"));
        policy.setGroupByMode(CtGroupByMode.valueOf((int)comboInt));
        int comboInt2 = Integer.parseInt((String)this.getModel().getValue("g_entrycombo"));
        policy.setCtGroupByMode2(CtGroupByMode.valueOf((int)comboInt2));
        int comboInt3 = Integer.parseInt((String)this.getModel().getValue("g_subentrycombo"));
        policy.setCtGroupByMode3(CtGroupByMode.valueOf((int)comboInt3));
        String groupByField = this.getGroupByField("g_billentry", "g_billentrykey");
        String groupByField2 = this.getGroupByField("g_entry", "g_entrykey");
        String groupByField3 = this.getGroupByField("g_subentry", "g_subentrykey");
        policy.setGroupByField(groupByField);
        policy.setGroupByField2(groupByField2);
        policy.setGroupByField3(groupByField3);
    }

    public String getGroupByField(String entryKey, String key) {
        ArrayList<String> list = new ArrayList<String>(10);
        int count = this.getModel().getEntryRowCount(entryKey);
        for (int i = 0; i < count; ++i) {
            String fieldKey = (String)this.getModel().getValue(key, i);
            list.add(fieldKey);
        }
        String groupByField = StringUtils.join((Object[])list.toArray(), (String)",");
        return groupByField;
    }

    private void getFilterPolicyPolicy(CtConvertRuleElement rule) {
        CtFilterPolicy filterPolicy = rule.getCtFilterPolicy();
        if (filterPolicy == null) {
            filterPolicy = new CtFilterPolicy();
        }
        String localeId = RequestContext.get().getLang().toString();
        filterPolicy.getConditionList().clear();
        int rowCount = this.getModel().getEntryRowCount("adv_filter");
        for (int row = 0; row < rowCount; ++row) {
            CtCRCondition condition = null;
            String runConditionJson = (String)this.getModel().getValue("advfilterjson", row);
            if (StringUtils.isBlank((CharSequence)runConditionJson)) continue;
            condition = (CtCRCondition)SerializationUtils.fromJsonString((String)runConditionJson, CtCRCondition.class);
            condition.setEnabled(((Boolean)this.getModel().getValue("advfilterenable", row)).booleanValue());
            condition.setSeq(row + 1);
            condition.setId((String)this.getModel().getValue("ft_id", row));
            condition.getDescription().setItem(localeId, (Object)((OrmLocaleValue)this.getModel().getValue("advfilterdesc", row)).getLocaleValue());
            filterPolicy.getConditionList().add(condition);
        }
        String dataRangeMode = (String)this.getModel().getValue("datarangemode");
        filterPolicy.setDataRangeMode(dataRangeMode);
    }

    private void getPluginPolicy(CtConvertRuleElement rule) {
        String entityKey = "pluginpolicy";
        int rowCount = this.getModel().getEntryRowCount(entityKey);
        CtPlugInPolicy policy = rule.getCtPlugInPolicy();
        policy.getPlugins().clear();
        for (int row = 0; row < rowCount; ++row) {
            String crplugJson = (String)this.getModel().getValue("f_pl_plugin", row);
            if (StringUtils.isBlank((CharSequence)crplugJson)) continue;
            CRPlugin crPlugin = (CRPlugin)SerializationUtils.fromJsonString((String)crplugJson, CRPlugin.class);
            crPlugin.setSeq(row + 1);
            crPlugin.setEnabled(((Boolean)this.getModel().getValue("f_pl_enabled", row)).booleanValue());
            policy.getPlugins().add(crPlugin);
        }
    }

    private void getOptionPolicy(CtConvertRuleElement rule) {
        rule.getCtOptionPolicy().setBatchPush(((Boolean)this.getModel().getValue("batchpush")).booleanValue());
        rule.getCtOptionPolicy().setPushOneTime(((Boolean)this.getModel().getValue("pushonetime")).booleanValue());
        rule.getCtOptionPolicy().setTargetBillOp((String)this.getModel().getValue("targetbillopcombo"));
        rule.getCtOptionPolicy().setChecknewright(((Boolean)this.getModel().getValue("checknewright")).booleanValue());
        rule.getCtOptionPolicy().setChecksubmitright(((Boolean)this.getModel().getValue("checksubmitright")).booleanValue());
        rule.getCtOptionPolicy().setCheckauditright(((Boolean)this.getModel().getValue("checkauditright")).booleanValue());
    }

    public HashSet<String> getTargetLinkEntitys() {
        HashSet<String> linkEntitys = new HashSet<String>();
        String entityNumber = CtRuleCacheHelper.getTargetEntityNumber(this.getView());
        linkEntitys.add(entityNumber);
        String linkEntry = (String)this.getModel().getValue("ftargetentrykey");
        String linkSubEntry = (String)this.getModel().getValue("ftargetsubentrykey");
        if (StringUtils.isNotBlank((CharSequence)linkEntry) && !linkEntitys.contains(linkEntry)) {
            linkEntitys.add(linkEntry);
            if (StringUtils.isNotBlank((CharSequence)linkSubEntry) && !linkEntitys.contains(linkSubEntry)) {
                linkEntitys.add(linkSubEntry);
            }
        }
        return linkEntitys;
    }

    public HashSet<String> getSourceLinkEntitys() {
        HashSet<String> linkEntitys = new HashSet<String>();
        String entityNumber = CtRuleCacheHelper.getSourceEntityNumber(this.getView());
        linkEntitys.add(entityNumber);
        String linkEntry = (String)this.getModel().getValue("fsourceentrykey");
        String linkSubEntry = (String)this.getModel().getValue("fsourcesubentrykey");
        if (StringUtils.isNotBlank((CharSequence)linkEntry) && !linkEntitys.contains(linkEntry)) {
            linkEntitys.add(linkEntry);
            if (StringUtils.isNotBlank((CharSequence)linkSubEntry) && !linkEntitys.contains(linkSubEntry)) {
                linkEntitys.add(linkSubEntry);
            }
        }
        return linkEntitys;
    }

    public MainEntityTypeDto getMainEntityType(String tenant, String accountId, String entityNumber, Boolean isTargetBill, CtConvertRuleElement ruleElement) {
        MainEntityTypeDto mainEntityTypeDto = null;
        String key = this.getKey(tenant, accountId, entityNumber, isTargetBill);
        String mainEntityTypeJson = this.getPageCache().get(key);
        if (StringUtils.isBlank((CharSequence)mainEntityTypeJson)) {
            String localeId = RequestContext.get().getLang().toString();
            CtMainEntityTypeReq mainEntityTypeReq = new CtMainEntityTypeReq(entityNumber, isTargetBill, Boolean.valueOf(ruleElement.isMirrorSync()), localeId);
            if (!isTargetBill.booleanValue()) {
                CtFieldMapPolicy policy = ruleElement.getCtFieldMapPolicy();
                ArrayList<String> sourceFieldKeyList = new ArrayList<String>(16);
                for (CtFieldMapItem item : policy.getCtFieldMapItems()) {
                    String sourceFieldKey = item.getSourceFieldKey();
                    if (item.getCtFieldConvertType() != CtFieldConvertType.SourceField || !StringUtils.isNotBlank((CharSequence)sourceFieldKey)) continue;
                    sourceFieldKeyList.add(sourceFieldKey);
                }
                mainEntityTypeReq.setSourceFieldKeys(sourceFieldKeyList);
            }
            String result = CtBotpApiUtils.post((String)tenant, (String)accountId, (CtApiUrlEnum)CtApiUrlEnum.GETMAINENTITYINFO, (String)SerializationUtils.toJsonString((Object)mainEntityTypeReq));
            Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
            this.getPageCache().put(key, SerializationUtils.toJsonString(openApiResult.get("data")));
            mainEntityTypeDto = (MainEntityTypeDto)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(openApiResult.get("data")), MainEntityTypeDto.class);
        } else {
            mainEntityTypeDto = (MainEntityTypeDto)SerializationUtils.fromJsonString((String)mainEntityTypeJson, MainEntityTypeDto.class);
        }
        return mainEntityTypeDto;
    }

    public MainEntityTypeDto getMainEntityTypeFromCache(String tenant, String accountId, String entityNumber, Boolean isTargetBill) {
        MainEntityTypeDto mainEntityTypeDto = null;
        String key = this.getKey(tenant, accountId, entityNumber, isTargetBill);
        String mainEntityTypeJson = this.getPageCache().get(key);
        if (StringUtils.isNotBlank((CharSequence)mainEntityTypeJson)) {
            mainEntityTypeDto = (MainEntityTypeDto)SerializationUtils.fromJsonString((String)mainEntityTypeJson, MainEntityTypeDto.class);
        }
        return mainEntityTypeDto;
    }

    private String getKey(String tenant, String accountId, String entityNumber, Boolean isTargetBill) {
        String key = tenant + "_" + accountId + "_" + entityNumber + "_ManinDto";
        key = isTargetBill != false ? key + "_T" : key + "_S";
        return key;
    }

    public void clearManEntityTypeCache(String tenant, String accountId, String entityNumber, Boolean isTargetBill) {
        String key = this.getKey(tenant, accountId, entityNumber, isTargetBill);
        this.getPageCache().remove(key);
    }

    public Map<String, DynamicPropertyDto> autoMatchFieldsProperty(String tenant, String accountId, String entityNumber, List<String> fields) {
        Map<String, Object> targetField = new HashMap<String, DynamicPropertyDto>(16);
        CtAutoMatchFieldsReq req = new CtAutoMatchFieldsReq();
        req.setEntityNumber(entityNumber);
        req.setFieldKeys(fields);
        String result = CtBotpApiUtils.post((String)tenant, (String)accountId, (CtApiUrlEnum)CtApiUrlEnum.GETAUTOMATCHFIELDS, (String)SerializationUtils.toJsonString((Object)req));
        Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        if (Boolean.parseBoolean(openApiResult.get("status").toString())) {
            targetField = (Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(openApiResult.get("data")), Map.class);
        }
        return targetField;
    }

    public String getFieldCaption(String tenant, String accountId, String sourceEntityNumber, String fieldPropName) {
        CtFieldCaptionReq param = new CtFieldCaptionReq();
        param.setSourceEntityNumber(sourceEntityNumber);
        param.setFieldPropName(fieldPropName);
        param.setLocalId(RequestContext.get().getLang().toString());
        String result = CtBotpApiUtils.post((String)tenant, (String)accountId, (CtApiUrlEnum)CtApiUrlEnum.GETFIELDCAPTION, (String)SerializationUtils.toJsonString((Object)param));
        if (StringUtils.isNotBlank((CharSequence)result)) {
            Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
            String data = String.valueOf(openApiResult.get("data"));
            return data;
        }
        return "";
    }

    public String buildEntityKeys(String tenant, String accountId, String entityNumber, String entryEntity) {
        Map openApiResult;
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("entityNumber", entityNumber);
        param.put("entryEntity", entryEntity);
        String result = CtBotpApiUtils.get((String)tenant, (String)accountId, (CtApiUrlEnum)CtApiUrlEnum.BUILDENTITYKEYS, param);
        if (StringUtils.isNotBlank((CharSequence)result) && Boolean.parseBoolean((openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class)).get("status").toString()) && openApiResult.get("errorCode").equals("0")) {
            return openApiResult.get("data").toString();
        }
        return "";
    }
}

