/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ctbotp;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.dto.DistributionSchemeDto;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.CtsyBaseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class CtMainDataCheck
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String BOS_CTBOTP_PLUGIN = "bos-ctbotp-formplugin";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String KEY_PROGRESSAP = "progressap";
    private static final String KEY_RESULTAP = "resultap";
    private static final String KEY_LBLPROGRESS = "labelap";
    private static final String KEY_TIPAP = "tipap";
    private static final String KEY_ENTRY_ENTITY = "resultentryentity";
    protected static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"CtBotpThreadPool", (int)2, (int)12);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.start();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_RESULTAP});
        final ArrayList noDistributionScheme = new ArrayList(16);
        String dtoLis = (String)this.getView().getFormShowParameter().getCustomParam("dtoList");
        List dtos = SerializationUtils.fromJsonStringToList((String)dtoLis, DistributionSchemeDto.class);
        for (DistributionSchemeDto dto : dtos) {
            String billNumber = dto.getEntityId();
            final String tenantCode = dto.getTenantCode();
            final String accountId = dto.getAcccountId();
            final String accountnumber = dto.getAccountNumber();
            HashMap<String, String> param = new HashMap<String, String>(1);
            param.put("entity", billNumber);
            String result = CtBotpApiUtils.post((String)tenantCode, (String)accountId, (CtApiUrlEnum)CtApiUrlEnum.GETOBJECTTYPEREFS, (String)SerializationUtils.toJsonString(param));
            Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
            final List entityIds = SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString(openApiResult.get("data")), String.class);
            final Map distributionSchemeMap = CtsyBaseServiceHelper.hasDistributionScheme((String)tenantCode, (List)entityIds);
            final IPageCache iPageCache = this.getPageCache();
            threadPool.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    iPageCache.put("resultSize", String.valueOf(entityIds.size()));
                    ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                    qFilters.add(new QFilter("number", "in", (Object)entityIds));
                    DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_billmainentity", (String)"number,name", (QFilter[])qFilters.toArray(new QFilter[0]));
                    ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(dynamicObjects.length);
                    QFilter[] filter = new QFilter[3];
                    filter[0] = new QFilter("tenantcode", "=", (Object)tenantCode);
                    filter[1] = new QFilter("acccountid", "=", (Object)accountId);
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        filter[2] = new QFilter("entityid", "=", (Object)String.valueOf(dynamicObject.get("number")));
                        DynamicObject distributionScheme = BusinessDataServiceHelper.loadSingleFromCache((String)"ct_botp_scheme_rec", (QFilter[])filter);
                        int processed = Integer.parseInt(iPageCache.get("processed") == null ? "0" : iPageCache.get("processed"));
                        int progress = processed + 1;
                        iPageCache.put("processed", String.valueOf(progress));
                        String entityId = (String)dynamicObject.get("number");
                        if (distributionScheme != null) {
                            distributionScheme.set("hasdistributionscheme", distributionSchemeMap.get(entityId));
                            if (!((Boolean)distributionSchemeMap.get(entityId)).booleanValue()) {
                                DistributionSchemeDto schemeDto = CtMainDataCheck.this.getSchemeDto(tenantCode, accountnumber, dynamicObject);
                                noDistributionScheme.add(schemeDto);
                            }
                            SaveServiceHelper.update((DynamicObject)distributionScheme);
                            continue;
                        }
                        DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)"ct_botp_scheme_rec");
                        newObj.set("tenantcode", (Object)tenantCode);
                        newObj.set("accountnumber", (Object)accountnumber);
                        newObj.set("acccountid", (Object)accountId);
                        newObj.set("entityid", (Object)entityId);
                        newObj.set("entityname", dynamicObject.get("name"));
                        newObj.set("createdate", (Object)new Date());
                        if (((Boolean)distributionSchemeMap.get(entityId)).booleanValue()) {
                            newObj.set("hasdistributionscheme", (Object)true);
                        } else {
                            DistributionSchemeDto schemeDto = CtMainDataCheck.this.getSchemeDto(tenantCode, accountnumber, dynamicObject);
                            noDistributionScheme.add(schemeDto);
                            newObj.set("hasdistributionscheme", (Object)false);
                        }
                        list.add(newObj);
                    }
                    iPageCache.put("noDistributionScheme", SerializationUtils.toJsonString((Object)noDistributionScheme));
                    SaveServiceHelper.save((DynamicObject[])list.toArray(list.toArray(new DynamicObject[0])));
                    return null;
                }
            });
        }
    }

    public void onProgress(ProgressEvent e) {
        int resultSize = Integer.parseInt(this.getView().getPageCache().get("resultSize") == null ? "0" : this.getView().getPageCache().get("resultSize"));
        int processed = Integer.parseInt(this.getView().getPageCache().get("processed") == null ? "0" : this.getView().getPageCache().get("processed"));
        double progress = (double)processed * 100.0 / (double)resultSize;
        e.setProgress((int)progress);
        if (progress >= 100.0) {
            List noDistributionScheme = SerializationUtils.fromJsonStringToList((String)this.getView().getPageCache().get("noDistributionScheme"), DistributionSchemeDto.class);
            if (noDistributionScheme.size() > 0) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_PROGRESSAP});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_RESULTAP});
                this.complete(noDistributionScheme);
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_PROGRESSBAR});
                String tip = String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5b8c\u6210\uff0c\u6240\u6709\u68c0\u6d4b\u57fa\u7840\u8d44\u6599\u90fd\u5b58\u5728\u5206\u53d1\u65b9\u6848", (String)"CtMainDataCheck_1", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]), new Object[0]);
                this.setProgressTip(tip);
            }
            ProgressBar bar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
            bar.stop();
        } else {
            String tip = String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u4e2d\uff0c\u5171%1$s/%2$s", (String)"CtMainDataCheck_0", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]), processed, resultSize);
            this.setProgressTip(tip);
        }
    }

    private void complete(List<DistributionSchemeDto> noDistributionScheme) {
        this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRY_ENTITY);
        rows.clear();
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRY_ENTITY);
        int seq = 1;
        for (DistributionSchemeDto schemeDto : noDistributionScheme) {
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            row.set("seq", (Object)seq);
            row.set("tenantcode", (Object)schemeDto.getTenantCode());
            row.set("accountnumber", (Object)schemeDto.getAccountNumber());
            row.set("entityid", (Object)schemeDto.getEntityId());
            row.set("entityname", (Object)schemeDto.getEntityName());
            rows.add((Object)row);
            ++seq;
        }
        this.getView().updateView(KEY_ENTRY_ENTITY);
    }

    private void setProgressTip(String tip) {
        Label lblTip = (Label)this.getControl(KEY_LBLPROGRESS);
        lblTip.setText(tip);
    }

    private DistributionSchemeDto getSchemeDto(String tenantCode, String accountnumber, DynamicObject dynamicObject) {
        DistributionSchemeDto schemeDto = new DistributionSchemeDto();
        schemeDto.setTenantCode(tenantCode);
        schemeDto.setAccountNumber(accountnumber);
        schemeDto.setEntityId((String)dynamicObject.get("number"));
        schemeDto.setEntityName(((OrmLocaleValue)dynamicObject.get("name")).getLocaleValue());
        return schemeDto;
    }
}

