/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ctbotp;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.dto.CtBotpEntityDto;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.service.ctbotp.utils.CtTenantPathUtils;

public class CtNewConvertPathEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BOS_CTBOTP_PLUGIN = "bos-ctbotp-formplugin";
    private static final String KEY_OK = "btnok";
    private static final String KEY_TENANTPATH = "ftenantpath";
    private static final String KEY_SOURCE_BILL = "fsourcebill";
    private static final String KEY_TARGET_BILL = "ftargetbill";
    private static final String FORMID_ENTITY_LIST = "ct_botp_tenant_entity";
    private static final String FORMID_SOURCEBILLDTO = "SourceBillDto";
    private static final String FORMID_TARGETBILLDTO = "TargetBillDto";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit sbill = (TextEdit)this.getView().getControl(KEY_SOURCE_BILL);
        sbill.addClickListener((ClickListener)this);
        TextEdit tbill = (TextEdit)this.getView().getControl(KEY_TARGET_BILL);
        tbill.addClickListener((ClickListener)this);
        Button button = (Button)this.getView().getControl(KEY_OK);
        button.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        DynamicObject tenantPath = (DynamicObject)this.getModel().getValue(KEY_TENANTPATH);
        if (tenantPath != null) {
            tenantPath = CtTenantPathUtils.getTenantPath((String)tenantPath.getString("number"));
        }
        if (key.equalsIgnoreCase(KEY_SOURCE_BILL)) {
            String sourceTenantCode = null;
            String sourceAccountId = null;
            if (tenantPath != null) {
                DynamicObject sourceTenant = (DynamicObject)tenantPath.get("sourcetenant");
                sourceTenantCode = sourceTenant.getString("tenantid");
                sourceAccountId = sourceTenant.getString("accountid");
            }
            this.showTenantEntityObjList(sourceTenantCode, sourceAccountId, KEY_SOURCE_BILL);
        } else if (key.equalsIgnoreCase(KEY_TARGET_BILL)) {
            String targetTenantCode = null;
            String targetAccountId = null;
            if (tenantPath != null) {
                DynamicObject targetTenant = (DynamicObject)tenantPath.get("targettenant");
                targetTenantCode = targetTenant.getString("tenantid");
                targetAccountId = targetTenant.getString("accountid");
            }
            this.showTenantEntityObjList(targetTenantCode, targetAccountId, KEY_TARGET_BILL);
        } else if (key.equalsIgnoreCase(KEY_OK)) {
            this.returnToParent();
        }
    }

    private void showTenantEntityObjList(String tenant, String accountId, String actionId) {
        if (StringUtils.isBlank((CharSequence)tenant) || StringUtils.isBlank((CharSequence)accountId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u79df\u6237\u8def\u7ebf\u3002", (String)"CtNewConvertPathEdit_0", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_ENTITY_LIST);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("tenant", (Object)tenant);
        showParameter.setCustomParam("accountId", (Object)accountId);
        showParameter.getCustomParams().put("checkRightAppId", this.getView().getFormShowParameter().getAppId());
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, actionId);
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    private void returnToParent() {
        String targetDto;
        DynamicObject tenantPath = (DynamicObject)this.getModel().getValue(KEY_TENANTPATH);
        if (tenantPath == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79df\u6237\u8def\u7ebf\u3002", (String)"CtNewConvertPathEdit_1", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String srcBill = (String)this.getModel().getValue(KEY_SOURCE_BILL);
        if (StringUtils.isBlank((CharSequence)srcBill)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u5355\u3002", (String)"CtNewConvertPathEdit_2", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String tgtBill = (String)this.getModel().getValue(KEY_TARGET_BILL);
        if (StringUtils.isBlank((CharSequence)tgtBill)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u5355\u3002", (String)"CtNewConvertPathEdit_4", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
            return;
        }
        CtBotpEntityDto sourceBillDto = null;
        CtBotpEntityDto targetBillDto = null;
        String sourceDto = this.getPageCache().get(FORMID_SOURCEBILLDTO);
        if (StringUtils.isNotBlank((CharSequence)sourceDto)) {
            sourceBillDto = (CtBotpEntityDto)SerializationUtils.fromJsonString((String)sourceDto, CtBotpEntityDto.class);
        }
        if (StringUtils.isNotBlank((CharSequence)(targetDto = this.getPageCache().get(FORMID_TARGETBILLDTO)))) {
            targetBillDto = (CtBotpEntityDto)SerializationUtils.fromJsonString((String)targetDto, CtBotpEntityDto.class);
        }
        HashMap<String, Object> returnParams = new HashMap<String, Object>();
        returnParams.put(FORMID_SOURCEBILLDTO, sourceBillDto);
        returnParams.put("TenantPath", tenantPath);
        returnParams.put(FORMID_TARGETBILLDTO, targetBillDto);
        this.getView().returnDataToParent(returnParams);
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        CtBotpEntityDto dto = (CtBotpEntityDto)closedCallBackEvent.getReturnData();
        if (actionId.equalsIgnoreCase(KEY_SOURCE_BILL) && dto != null) {
            this.getPageCache().put(FORMID_SOURCEBILLDTO, SerializationUtils.toJsonString((Object)dto));
            this.getModel().setValue(KEY_SOURCE_BILL, (Object)dto.getName());
        } else if (actionId.equalsIgnoreCase(KEY_TARGET_BILL) && dto != null) {
            this.getPageCache().put(FORMID_TARGETBILLDTO, SerializationUtils.toJsonString((Object)dto));
            this.getModel().setValue(KEY_TARGET_BILL, (Object)dto.getName());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (KEY_TENANTPATH.equalsIgnoreCase(key)) {
            this.getModel().setValue(KEY_SOURCE_BILL, (Object)"");
            this.getModel().setValue(KEY_TARGET_BILL, (Object)"");
        }
    }
}

