/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ctbotp;

import java.util.EventObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CheckMessage;
import kd.bos.entity.botp.CheckResult;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;

public class CtRuleCheckReportEdit
extends AbstractFormPlugin {
    public static final String FormId_RuleCheckReport = "botp_rulecheckreport";
    public static final String CustParamKey_CheckResult = "checkresult";
    private static final String KEY_REPORT_ENTRY = "report";
    private static final String KEY_CHECK_POINT = "checkpoint";
    private static final String KEY_MESSAGE_TYPE = "messagetype";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_BTN_OK = "btnok";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        if (this.getView().getParentView() == null) {
            return;
        }
        CheckResult checkResult = this.getCheckResult();
        this.fillReportEntry(checkResult);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)KEY_BTN_OK)) {
            this.getView().close();
        }
    }

    private void fillReportEntry(CheckResult checkResult) {
        int defRowCount;
        int rowCount = checkResult.getMessages().size();
        if (rowCount > (defRowCount = this.getModel().getEntryRowCount(KEY_REPORT_ENTRY))) {
            this.getModel().batchCreateNewEntryRow(KEY_REPORT_ENTRY, rowCount - defRowCount);
        } else {
            for (int i = defRowCount - 1; i >= rowCount; --i) {
                this.getModel().deleteEntryRow(KEY_REPORT_ENTRY, i);
            }
        }
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            CheckMessage msg = (CheckMessage)checkResult.getMessages().get(rowIndex);
            this.getModel().setValue(KEY_CHECK_POINT, (Object)msg.getCheckPoint().getFullPoint(), rowIndex);
            this.getModel().setValue(KEY_MESSAGE_TYPE, (Object)msg.getMsgType().getValue(), rowIndex);
            this.getModel().setValue(KEY_MESSAGE, (Object)msg.getMessage(), rowIndex);
        }
    }

    private CheckResult getCheckResult() {
        Object paramValue = this.getView().getFormShowParameter().getCustomParam(CustParamKey_CheckResult);
        if (paramValue == null) {
            return new CheckResult();
        }
        String strCheckResult = String.valueOf(paramValue);
        if (StringUtils.isBlank((CharSequence)strCheckResult)) {
            return new CheckResult();
        }
        CheckResult checkResult = (CheckResult)SerializationUtils.fromJsonString((String)strCheckResult, CheckResult.class);
        return checkResult;
    }
}

