/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ctbotp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.ctbotp.CtFieldEventHandler;
import kd.bos.designer.ctbotp.CtGetRuleHelper;
import kd.bos.designer.ctbotp.CtRuleCacheHelper;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRPlugin;
import kd.bos.entity.ctbotp.CtAttachmentPanelMapItem;
import kd.bos.entity.ctbotp.CtAttachmentPanelMapPolicy;
import kd.bos.entity.ctbotp.CtBillTypeMapItem;
import kd.bos.entity.ctbotp.CtBillTypeMapPolicy;
import kd.bos.entity.ctbotp.CtCRCondition;
import kd.bos.entity.ctbotp.CtConvertRuleElement;
import kd.bos.entity.ctbotp.CtFieldConvertType;
import kd.bos.entity.ctbotp.CtFieldMapItem;
import kd.bos.entity.ctbotp.CtFieldMapPolicy;
import kd.bos.entity.ctbotp.CtFilterPolicy;
import kd.bos.entity.ctbotp.CtGroupByMode;
import kd.bos.entity.ctbotp.CtGroupByPolicy;
import kd.bos.entity.ctbotp.CtLinkEntityPolicy;
import kd.bos.entity.ctbotp.CtPlugInPolicy;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.dto.CtAttachmentPanelApDto;
import kd.bos.entity.ctbotp.dto.DynamicPropertyDto;
import kd.bos.entity.ctbotp.dto.MainEntityTypeDto;
import kd.bos.entity.ctbotp.dto.TargetFieldInfo;
import kd.bos.entity.ctbotp.syncdata.SyncRuleRecord;
import kd.bos.entity.ctbotp.tenant.TenantInfo;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.PictureProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.SyncCtConvertRule;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;
import kd.bos.service.ctbotp.utils.CtBotpTenantUtils;
import org.apache.commons.collections4.CollectionUtils;

public class CtSetRuleHelper {
    private static final String BOS_CTBOTP_FORMPLUGIN = "bos-ctbotp-formplugin";
    private static final Log logger = LogFactory.getLog(CtSetRuleHelper.class);
    private IFormView view;
    private AbstractFormPlugin plugin;
    private CtGetRuleHelper getRuleHelper;

    public CtSetRuleHelper(IFormView view, AbstractFormPlugin plugin) {
        this.view = view;
        this.plugin = plugin;
        this.getRuleHelper = new CtGetRuleHelper(view, plugin);
    }

    private IFormView getView() {
        return this.view;
    }

    private IDataModel getModel() {
        return this.view.getModel();
    }

    private IPageCache getPageCache() {
        return this.view.getPageCache();
    }

    public void setRule(CtConvertRuleElement rule) {
        this.getRuleHelper.getMainEntityType(rule.getSourceTenant(), rule.getSourceDataCenter(), rule.getSourceEntityNumber(), false, rule);
        this.getRuleHelper.getMainEntityType(rule.getTargetTenant(), rule.getTargetDataCenter(), rule.getTargetEntityNumber(), true, rule);
        this.getModel().getDataEntity(true);
        this.setBaseInfo(rule);
        this.setLinkEntryPolicy(rule, false);
        this.setBillTypeMapPolicy(rule);
        this.setFieldMapPolicy(rule);
        this.setAttachmentPanelMapPolicy(rule);
        this.setGroupBy(rule);
        this.setFilterPolicy(rule);
        this.setPluginPolicy(rule);
        this.setOptionPolicy(rule);
    }

    public void setBaseInfo(CtConvertRuleElement rule) {
        SyncRuleRecord record;
        String localeId = RequestContext.get().getLang().toString();
        this.getModel().setValue("fid", (Object)rule.getId());
        if (rule.getExtVerId() == 0L) {
            this.getModel().setValue("fextversion", (Object)"-");
        } else {
            this.getModel().setValue("fextversion", (Object)rule.getExtVerId());
        }
        this.getModel().setValue("fcurrentverid", (Object)rule.getCurrentVerId());
        this.getModel().setValue("fname", rule.getName() == null ? "" : rule.getName().get((Object)localeId));
        this.getModel().setValue("fenabled", (Object)rule.isEnabled());
        this.getModel().setValue("synctype", (Object)rule.getSyncType());
        this.getModel().setValue("sysstatus", (Object)rule.getSysStatus());
        this.getModel().setValue("fmirrorsync", (Object)rule.isMirrorSync());
        if (rule.isMirrorSync()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"fmirrorupdate"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fmirrorupdate"});
        }
        this.getModel().setValue("fmirrorupdate", (Object)rule.isMirrorUpdate());
        String runConditionJson = "";
        String runConditionDesc = "";
        if (rule.getCtCRCondition() != null) {
            runConditionJson = SerializationUtils.toJsonString((Object)rule.getCtCRCondition());
            runConditionDesc = rule.getCtCRCondition().getExprDesc();
        }
        this.getModel().setValue("fruncondition", (Object)runConditionJson);
        this.getModel().setValue("frunconditiondesc", (Object)runConditionDesc);
        SyncCtConvertRule syncCtConvertRule = new SyncCtConvertRule();
        Long verId = rule.getCurrentVerId();
        if (rule.getExtVerId() != 0L) {
            verId = rule.getExtVerId();
        }
        if ((record = syncCtConvertRule.getSyncRec(verId)) == null || !record.getSourceStatus().equals("S") || !record.getTargetStatus().equals("S")) {
            this.getModel().setValue("syncstatus", (Object)"0");
        } else {
            this.getModel().setValue("syncstatus", (Object)"1");
        }
        TenantInfo tenantInfo = CtBotpTenantUtils.getGroupTenantInfo();
        if (tenantInfo.getTenantId().equals(RequestContext.get().getTenantId()) && tenantInfo.getAccountId().equals(RequestContext.get().getAccountId())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"syncstatus"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"syncstatus"});
        }
    }

    public void setLinkEntryPolicy(CtConvertRuleElement rule, Boolean propertyChanged) {
        CtLinkEntityPolicy policy = rule.getCtLinkEntityPolicy();
        if (rule.isMirrorSync()) {
            this.view.setVisible(Boolean.valueOf(false), new String[]{"fs_mirrorlink"});
            this.view.setVisible(Boolean.valueOf(true), new String[]{"fs_link"});
            this.getModel().setValue("ftargetentrykey", (Object)rule.getTargetEntityNumber());
            this.getModel().setValue("ftargetlkentitykeys", (Object)"billhead");
            this.view.setEnable(Boolean.valueOf(false), new String[]{"ftargetentrykey"});
            this.changeTgtLinkEntity(rule.getTargetTenant(), rule.getTargetDataCenter(), rule.getTargetEntityNumber(), rule.getTargetEntityNumber(), false);
            this.getModel().setValue("ftargetsubentrykey", (Object)policy.getTargetSubEntryKey());
            this.getModel().setValue("fsourceentrykey", (Object)rule.getSourceEntityNumber());
            this.view.setEnable(Boolean.valueOf(false), new String[]{"fsourceentrykey"});
            this.getModel().setValue("fsourcelkentitykeys", (Object)"billhead");
            this.changeSrcLinkEntity(rule.getSourceTenant(), rule.getSourceDataCenter(), rule.getSourceEntityNumber(), rule.getSourceEntityNumber(), rule.isMirrorSync());
            this.getModel().setValue("fsourcesubentrykey", (Object)policy.getSourceSubEntryKey());
        } else {
            this.view.setVisible(Boolean.valueOf(false), new String[]{"fs_mirrorlink"});
            this.view.setVisible(Boolean.valueOf(true), new String[]{"fs_link"});
            this.getModel().setValue("ftargetentrykey", (Object)policy.getTargetEntryKey());
            if (propertyChanged.booleanValue()) {
                String tgtEntityKeys = this.getRuleHelper.buildEntityKeys(rule.getTargetTenant(), rule.getTargetDataCenter(), rule.getTargetEntityNumber(), policy.getTargetEntryKey());
                this.getModel().setValue("ftargetlkentitykeys", (Object)tgtEntityKeys);
            } else {
                this.getModel().setValue("ftargetlkentitykeys", (Object)policy.getTargetEntityKeys());
            }
            this.view.setEnable(Boolean.valueOf(true), new String[]{"ftargetentrykey"});
            this.changeTgtLinkEntity(rule.getTargetTenant(), rule.getTargetDataCenter(), rule.getTargetEntityNumber(), policy.getTargetEntryKey(), rule.isMirrorSync());
            this.getModel().setValue("ftargetsubentrykey", (Object)policy.getTargetSubEntryKey());
            this.getModel().setValue("fsourceentrykey", (Object)policy.getSourceEntryKey());
            this.view.setEnable(Boolean.valueOf(true), new String[]{"fsourceentrykey"});
            if (propertyChanged.booleanValue()) {
                String srcEntityKeys = this.getRuleHelper.buildEntityKeys(rule.getSourceTenant(), rule.getSourceDataCenter(), rule.getSourceEntityNumber(), policy.getSourceEntryKey());
                this.getModel().setValue("fsourcelkentitykeys", (Object)srcEntityKeys);
            } else {
                this.getModel().setValue("fsourcelkentitykeys", (Object)policy.getSourceEntityKeys());
            }
            this.changeSrcLinkEntity(rule.getSourceTenant(), rule.getSourceDataCenter(), rule.getSourceEntityNumber(), policy.getSourceEntryKey(), rule.isMirrorSync());
            this.getModel().setValue("fsourcesubentrykey", (Object)policy.getSourceSubEntryKey());
        }
    }

    public void setBillTypeMapPolicy(CtConvertRuleElement rule) {
        MainEntityTypeDto sourceDto = this.getRuleHelper.getMainEntityTypeFromCache(rule.getSourceTenant(), rule.getSourceDataCenter(), rule.getSourceEntityNumber(), false);
        MainEntityTypeDto targetDto = this.getRuleHelper.getMainEntityTypeFromCache(rule.getTargetTenant(), rule.getTargetDataCenter(), rule.getTargetEntityNumber(), true);
        boolean enableAddRow = sourceDto.isExistBillTypeField() && targetDto.isExistBillTypeField();
        this.getView().setEnable(Boolean.valueOf(enableAddRow), new String[]{"bar_billtype_newentry", "bar_billtype_delentry", "bar_billtype_upentry", "bar_billtype_downentry", "bar_billtype_test"});
        if (!enableAddRow) {
            return;
        }
        CtBillTypeMapPolicy policy = rule.getCtBillTypeMapPolicy();
        int mapItemCount = policy.getItems().size();
        int rowCount = this.getModel().getEntryRowCount("billtypemappolicy");
        if (rowCount < mapItemCount) {
            this.getModel().batchCreateNewEntryRow("billtypemappolicy", mapItemCount - rowCount);
        }
        if (rowCount > mapItemCount) {
            for (int rowIndex = rowCount - 1; rowIndex >= mapItemCount; --rowIndex) {
                this.getModel().deleteEntryRow("billtypemappolicy", rowIndex);
            }
        }
        Map<String, ComboItem> sourceBillTypeItems = this.buildSourceBillTypeItems(sourceDto.getBillTypes());
        Map<String, ComboItem> targetBillTypeItems = this.buildTargetBillTypeItems(targetDto.getBillTypes());
        for (int rowIndex = 0; rowIndex < mapItemCount; ++rowIndex) {
            ComboItem item;
            CtBillTypeMapItem mapItem = (CtBillTypeMapItem)policy.getItems().get(rowIndex);
            this.getModel().setValue("billtypemapitemid", (Object)mapItem.getId(), rowIndex);
            if (StringUtils.equalsIgnoreCase((CharSequence)mapItem.getSourceType(), (CharSequence)"All")) {
                this.getModel().setValue("sourcebilltype", (Object)"All", rowIndex);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)mapItem.getSourceType(), (CharSequence)"Others")) {
                this.getModel().setValue("sourcebilltype", (Object)"Others", rowIndex);
            } else {
                String srcId = String.valueOf(mapItem.getSourceBillTypeId());
                this.getModel().setValue("sourcebilltype", (Object)srcId, rowIndex);
                if (sourceBillTypeItems.containsKey(srcId)) {
                    mapItem.setSourceBillTypeName(sourceBillTypeItems.get(srcId).getCaption().toString());
                } else {
                    String srcName = String.format(ResManager.loadKDString((String)"%s(\u672a\u77e5\u7c7b\u578b)", (String)"CtConvertRuleEdit_12", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]), String.valueOf(mapItem.getSourceBillTypeId()));
                    mapItem.setSourceBillTypeName(srcName);
                    item = new ComboItem(new LocaleString(srcName), srcId);
                    sourceBillTypeItems.put(item.getId(), item);
                }
            }
            this.getModel().setValue("pushtype", (Object)mapItem.getPushType(), rowIndex);
            if (Long.compare(0L, mapItem.getTargetBillTypeId()) == 0) {
                this.getModel().setValue("targetbilltype", (Object)"", rowIndex);
            } else {
                String targetId = String.valueOf(mapItem.getTargetBillTypeId());
                if (targetBillTypeItems.containsKey(targetId)) {
                    mapItem.setTargetBillTypeName(targetBillTypeItems.get(targetId).getCaption().toString());
                } else {
                    String targetName = String.format(ResManager.loadKDString((String)"%s(\u672a\u77e5\u7c7b\u578b)", (String)"CtConvertRuleEdit_12", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]), mapItem.getTargetBillTypeId());
                    mapItem.setTargetBillTypeName(targetName);
                    item = new ComboItem(new LocaleString(targetName), targetId);
                    targetBillTypeItems.put(item.getId(), item);
                }
                this.getModel().setValue("targetbilltype", (Object)String.valueOf(mapItem.getTargetBillTypeId()), rowIndex);
            }
            this.getModel().setValue("billtypemapitemdesc", (Object)mapItem.toString(), rowIndex);
        }
        ComboEdit edit1 = (ComboEdit)this.getView().getControl("sourcebilltype");
        edit1.setComboItems(new ArrayList<ComboItem>(sourceBillTypeItems.values()));
        ComboEdit edit2 = (ComboEdit)this.getView().getControl("targetbilltype");
        edit2.setComboItems(new ArrayList<ComboItem>(targetBillTypeItems.values()));
    }

    public void setAttachmentPanelMapPolicy(CtConvertRuleElement rule) {
        int rowIndex;
        MainEntityTypeDto sourceDto = this.getRuleHelper.getMainEntityTypeFromCache(rule.getSourceTenant(), rule.getSourceDataCenter(), rule.getSourceEntityNumber(), false);
        MainEntityTypeDto targetDto = this.getRuleHelper.getMainEntityTypeFromCache(rule.getTargetTenant(), rule.getTargetDataCenter(), rule.getTargetEntityNumber(), true);
        List tgtAttPanelApList = targetDto.getAttachmentPanelApDtos();
        List srcAttPanelApList = sourceDto.getAttachmentPanelApDtos();
        if (CollectionUtils.isEmpty((Collection)tgtAttPanelApList) || CollectionUtils.isEmpty((Collection)srcAttPanelApList)) {
            this.getModel().deleteEntryData("attachmentpanelmappolicy");
            return;
        }
        this.initAttachmentPanelComboItems("sourceattachmentpanel", srcAttPanelApList);
        this.initAttachmentPanelComboItems("targetattachmentpanel", tgtAttPanelApList);
        CtAttachmentPanelMapPolicy policy = rule.getCtAttachmentPanelMapPolicy();
        HashMap<String, CtAttachmentPanelMapItem> attachMaps = new HashMap<String, CtAttachmentPanelMapItem>(16);
        for (CtAttachmentPanelMapItem item : policy.getItems()) {
            attachMaps.put(item.getTargetAttachmentPanel(), item);
        }
        int allAttachsCount = tgtAttPanelApList.size();
        int rowCount = this.getModel().getEntryRowCount("attachmentpanelmappolicy");
        if (rowCount < allAttachsCount) {
            this.getModel().batchCreateNewEntryRow("attachmentpanelmappolicy", allAttachsCount - rowCount);
        }
        if (rowCount > allAttachsCount) {
            for (rowIndex = rowCount - 1; rowIndex >= allAttachsCount; --rowIndex) {
                this.getModel().deleteEntryRow("attachmentpanelmappolicy", rowIndex);
            }
        }
        rowIndex = 0;
        for (CtAttachmentPanelApDto attachmentPanelAp : tgtAttPanelApList) {
            String targetKey = attachmentPanelAp.getKey();
            this.getModel().setValue("targetattachmentpanel", (Object)targetKey, rowIndex);
            CtAttachmentPanelMapItem item = (CtAttachmentPanelMapItem)attachMaps.get(targetKey);
            if (item != null) {
                this.fillAttachmentPanelMapRow(item, rowIndex);
            } else {
                CtAttachmentPanelMapItem blankItem = new CtAttachmentPanelMapItem();
                this.fillAttachmentPanelMapRow(blankItem, rowIndex);
            }
            ++rowIndex;
        }
    }

    private void initAttachmentPanelComboItems(String comboKey, List<CtAttachmentPanelApDto> comboPanels) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(comboPanels.size());
        for (CtAttachmentPanelApDto attachmentPanelAp : comboPanels) {
            ComboItem item = new ComboItem(new LocaleString(attachmentPanelAp.getName()), attachmentPanelAp.getKey());
            items.add(item);
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(comboKey);
        comboEdit.setComboItems(items);
    }

    private void fillAttachmentPanelMapRow(CtAttachmentPanelMapItem attachMapItem, int rowIndex) {
        this.getModel().setValue("attachmentpanelmapitemid", (Object)attachMapItem.getId(), rowIndex);
        this.getModel().setValue("sourceattachmentpanel", (Object)attachMapItem.getSourceAttachmentPanel(), rowIndex);
        this.getModel().setValue("attachmentmergetype", (Object)attachMapItem.getAttachmentPanelMergeType(), rowIndex);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"attachmentmergetype"});
    }

    private List<CtAttachmentPanelApDto> getAttachmentPanelApList(String tenantCode, String accountId, String entityNumber) {
        String key = tenantCode + "_" + accountId + "_" + entityNumber + "_AttPanelApList";
        String attachmentPanelApListJson = this.getPageCache().get(key);
        if (StringUtils.isBlank((CharSequence)attachmentPanelApListJson)) {
            HashMap<String, String> param = new HashMap<String, String>(1);
            param.put("entityNumber", entityNumber);
            param.put("localId", RequestContext.get().getLang().toString());
            String result = CtBotpApiUtils.get((String)tenantCode, (String)accountId, (CtApiUrlEnum)CtApiUrlEnum.GETATTACHMENTPANELAPLIST, param);
            Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
            attachmentPanelApListJson = SerializationUtils.toJsonString(openApiResult.get("data"));
            this.getPageCache().put(key, attachmentPanelApListJson);
        }
        List attachmentPanelApList = SerializationUtils.fromJsonStringToList((String)attachmentPanelApListJson, CtAttachmentPanelApDto.class);
        return attachmentPanelApList;
    }

    public void setFieldMapPolicy(CtConvertRuleElement rule) {
        int rowIndex;
        MainEntityTypeDto sourceDto = this.getRuleHelper.getMainEntityTypeFromCache(rule.getSourceTenant(), rule.getSourceDataCenter(), rule.getSourceEntityNumber(), false);
        MainEntityTypeDto targetDto = this.getRuleHelper.getMainEntityTypeFromCache(rule.getTargetTenant(), rule.getTargetDataCenter(), rule.getTargetEntityNumber(), true);
        String srcEntityNumber = CtRuleCacheHelper.getSourceEntityNumber(this.view);
        String tgtEntityNumber = CtRuleCacheHelper.getTargetEntityNumber(this.view);
        if (tgtEntityNumber == null || srcEntityNumber == null) {
            this.getModel().deleteEntryData("fieldmappolicy");
            return;
        }
        CtFieldMapPolicy policy = rule.getCtFieldMapPolicy();
        HashMap<String, CtFieldMapItem> fieldMaps = new HashMap<String, CtFieldMapItem>(16);
        for (CtFieldMapItem item : policy.getCtFieldMapItems()) {
            fieldMaps.put(item.getTargetFieldKey(), item);
        }
        Map sourceFieldNameMap = sourceDto.getSourceFieldNames();
        List list = targetDto.getTargetConvertFields();
        if ("1".equals(rule.getSyncType())) {
            list = list.stream().filter(n -> "billhead".equals(n.getTargetEntityKeys())).collect(Collectors.toList());
        }
        int allFieldCount = list.size();
        DynamicObjectCollection rows = this.getModel().getEntryEntity("fieldmappolicy");
        rows.clear();
        this.getModel().updateCache();
        int rowCount = this.getModel().getEntryRowCount("fieldmappolicy");
        if (rowCount < allFieldCount) {
            this.getModel().batchCreateNewEntryRow("fieldmappolicy", allFieldCount - rowCount);
        }
        if (rowCount > allFieldCount) {
            for (rowIndex = rowCount - 1; rowIndex >= allFieldCount; --rowIndex) {
                this.getModel().deleteEntryRow("fieldmappolicy", rowIndex);
            }
        }
        rowIndex = 0;
        for (TargetFieldInfo fieldInfo : list) {
            CtFieldMapItem item;
            this.getModel().setValue("ftargetfield", (Object)fieldInfo.getTargetFieldKey(), rowIndex);
            this.getModel().setValue("ftargetfieldname", (Object)fieldInfo.getTargetFieldName(), rowIndex);
            this.getModel().setValue("ftargetentitykeys", (Object)fieldInfo.getTargetEntityKeys(), rowIndex);
            this.getModel().setValue("ftargetfieldtype", (Object)fieldInfo.getTargetFieldType(), rowIndex);
            this.getModel().setValue("ftbasedataentitytype", (Object)fieldInfo.getTargetBaseDataNumber(), rowIndex);
            if (fieldInfo.getTargetFieldType().equals("kd.bos.entity.property.BillTypeProp")) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"fsourcefieldname", "ffieldformuladesc"});
            }
            if ((item = (CtFieldMapItem)fieldMaps.get(fieldInfo.getTargetFieldKey())) != null) {
                this.fillFieldMapRow(sourceFieldNameMap, item, rowIndex);
            } else {
                CtFieldMapItem blankItem = new CtFieldMapItem();
                this.fillFieldMapRow(sourceFieldNameMap, blankItem, rowIndex);
            }
            ++rowIndex;
        }
        this.getView().updateView("fieldmappolicy");
    }

    public void setFilterPolicy(CtConvertRuleElement rule) {
        CtFilterPolicy filterPolicy = rule.getCtFilterPolicy();
        if (filterPolicy == null) {
            return;
        }
        this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = this.getModel().getEntryEntity("adv_filter");
        rows.clear();
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get("adv_filter");
        ArrayList<CtCRCondition> crConditions = new ArrayList<CtCRCondition>();
        crConditions.addAll(filterPolicy.getConditionList());
        crConditions.sort(new Comparator<CtCRCondition>(){

            @Override
            public int compare(CtCRCondition o1, CtCRCondition o2) {
                if (o1.getSeq() < o2.getSeq()) {
                    return -1;
                }
                if (o1.getSeq() > o2.getSeq()) {
                    return 1;
                }
                return 0;
            }
        });
        int seq = 1;
        for (CtCRCondition condition : crConditions) {
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            row.set("seq", (Object)seq);
            row.set("ft_id", (Object)condition.getId());
            row.set("advfilterenable", (Object)condition.isEnabled());
            row.set("advfilterjson", (Object)SerializationUtils.toJsonString((Object)condition));
            row.set("filterexprdesc", (Object)condition.getExprTran());
            row.set("advfilterdesc", (Object)condition.getDescription());
            rows.add((Object)row);
            ++seq;
        }
        this.getModel().setValue("datarangemode", (Object)(StringUtils.isBlank((CharSequence)filterPolicy.getDataRangeMode()) ? "0" : filterPolicy.getDataRangeMode()));
        this.getView().updateView("adv_filter");
    }

    public void setGroupBy(CtConvertRuleElement rule) {
        if (StringUtils.isBlank((CharSequence)rule.getSourceEntityNumber())) {
            return;
        }
        CtGroupByPolicy byPolicy = rule.getCtGroupByPolicy();
        this.fillGroupBillCombo(StringUtils.isBlank((Object)byPolicy.getGroupByMode()) ? String.valueOf(CtGroupByMode.OneToOne.getValue()) : String.valueOf(byPolicy.getGroupByMode().getValue()));
        this.fillGroupEntryCombo(StringUtils.isBlank((Object)byPolicy.getCtGroupByMode2()) ? String.valueOf(CtGroupByMode.OneToOne.getValue()) : String.valueOf(byPolicy.getCtGroupByMode2().getValue()));
        this.fillGroupSubEntryCombo(StringUtils.isBlank((Object)byPolicy.getCtGroupByMode3()) ? String.valueOf(CtGroupByMode.OneToOne.getValue()) : String.valueOf(byPolicy.getCtGroupByMode3().getValue()));
        this.fillGroupEntry("g_billentry", "g_billentrykey", "g_billentryname", byPolicy.getGroupByField());
        this.fillGroupEntry("g_entry", "g_entrykey", "g_entryname", byPolicy.getGroupByField2());
        this.fillGroupEntry("g_subentry", "g_subentrykey", "g_subentryname", byPolicy.getGroupByField3());
    }

    public void fillGroupEntry(String entryKey, String fieldKey, String fieldName, String groupByField) {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(entryKey);
        String[] keys = groupByField == null ? new String[]{} : groupByField.split(",");
        ArrayList<String> keyList = new ArrayList<String>();
        for (String key : keys) {
            if (!StringUtils.isNotBlank((CharSequence)key)) continue;
            keyList.add(key);
        }
        if (rowCount < keyList.size()) {
            model.batchCreateNewEntryRow(entryKey, keys.length - rowCount);
        } else {
            for (int row = rowCount - 1; row >= keyList.size(); --row) {
                model.deleteEntryRow(entryKey, row);
            }
        }
        for (int i = 0; i < keyList.size(); ++i) {
            String key = (String)keyList.get(i);
            String srcEntityNumber = CtRuleCacheHelper.getSourceEntityNumber(this.view);
            String fieldCaption = this.getRuleHelper.getFieldCaption(CtRuleCacheHelper.getSourceTenant(this.view), CtRuleCacheHelper.getSourceDataCenter(this.view), srcEntityNumber, key);
            if (StringUtils.isBlank((CharSequence)fieldCaption)) {
                fieldCaption = key;
            }
            model.setValue(fieldKey, (Object)key, i);
            model.setValue(fieldName, (Object)fieldCaption, i);
        }
    }

    public void fillGroupBillCombo(String value) {
        this.getModel().setValue("g_billcombo", (Object)value);
        CtFieldEventHandler eventHandler = new CtFieldEventHandler(this.view, this.plugin);
        eventHandler.groupByChanged("g_billcombo");
    }

    public void fillGroupEntryCombo(String value) {
        this.getModel().setValue("g_entrycombo", (Object)value);
        CtFieldEventHandler eventHandler = new CtFieldEventHandler(this.view, this.plugin);
        eventHandler.groupByChanged("g_entrycombo");
    }

    public void fillGroupSubEntryCombo(String value) {
        this.getModel().setValue("g_subentrycombo", (Object)value);
        CtFieldEventHandler eventHandler = new CtFieldEventHandler(this.view, this.plugin);
        eventHandler.groupByChanged("g_subentrycombo");
    }

    private void setPluginPolicy(CtConvertRuleElement rule) {
        String entityKey = "pluginpolicy";
        int rowCount = this.getModel().getEntryRowCount(entityKey);
        CtPlugInPolicy policy = rule.getCtPlugInPolicy();
        int plugCount = policy.getPlugins().size();
        if (plugCount == 0) {
            this.getModel().deleteEntryData(entityKey);
        } else if (plugCount > rowCount) {
            this.getModel().batchCreateNewEntryRow(entityKey, plugCount - rowCount);
        } else {
            for (int i = rowCount; i > plugCount; --i) {
                this.getModel().deleteEntryRow(entityKey, i - 1);
            }
        }
        ArrayList<CRPlugin> crPlugins = new ArrayList<CRPlugin>();
        crPlugins.addAll(policy.getPlugins());
        crPlugins.sort(new Comparator<CRPlugin>(){

            @Override
            public int compare(CRPlugin o1, CRPlugin o2) {
                if (o1.getSeq() < o2.getSeq()) {
                    return -1;
                }
                if (o1.getSeq() > o2.getSeq()) {
                    return 1;
                }
                return 0;
            }
        });
        int i = 0;
        for (CRPlugin crPlugin : crPlugins) {
            this.getModel().setValue("f_pl_enabled", (Object)crPlugin.isEnabled(), i);
            this.getModel().setValue("f_pl_type", (Object)String.valueOf(crPlugin.getType()), i);
            this.getModel().setValue("f_pl_classname", (Object)crPlugin.getClassName(), i);
            this.getModel().setValue("f_pl_displayname", (Object)crPlugin.getDisplayName(), i);
            this.getModel().setValue("f_pl_description", (Object)crPlugin.getDescription(), i);
            this.getModel().setValue("f_pl_plugin", (Object)SerializationUtils.toJsonString((Object)crPlugin), i);
            ++i;
        }
    }

    private void setOptionPolicy(CtConvertRuleElement rule) {
        this.getModel().setValue("batchpush", (Object)rule.getCtOptionPolicy().isBatchPush());
        this.getModel().setValue("pushonetime", (Object)rule.getCtOptionPolicy().isPushOneTime());
        this.getModel().setValue("targetbillopcombo", (Object)rule.getCtOptionPolicy().getTargetBillOp());
        this.getModel().setValue("checknewright", (Object)rule.getCtOptionPolicy().isChecknewright());
        this.getModel().setValue("checksubmitright", (Object)rule.getCtOptionPolicy().isChecksubmitright());
        this.getModel().setValue("checkauditright", (Object)rule.getCtOptionPolicy().isCheckauditright());
    }

    public void changeTgtLinkEntity(String tenant, String accountId, String entityNumber, String entityKey, Boolean mirrorSync) {
        MainEntityTypeDto dto;
        this.getModel().setValue("ftargetsubentrykey", (Object)"");
        if (StringUtils.isBlank((CharSequence)entityKey)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ftargetsubentrykey"});
            return;
        }
        List<Object> subEntryItems = new ArrayList<ComboItem>();
        if (StringUtils.isNotBlank((CharSequence)entityNumber) && (dto = this.getRuleHelper.getMainEntityTypeFromCache(tenant, accountId, entityNumber, true)) != null && dto.getSubComboItems().size() > 0) {
            subEntryItems = (List)dto.getSubComboItems().get(entityKey);
        }
        if (subEntryItems == null || subEntryItems.size() == 0) {
            this.view.setVisible(Boolean.valueOf(false), new String[]{"ftargetsubentrykey"});
        } else {
            this.view.setVisible(Boolean.valueOf(true), new String[]{"ftargetsubentrykey"});
        }
        this.fillLinkSubEntityCombo("ftargetsubentrykey", subEntryItems);
    }

    public void changeSrcLinkEntity(String tenant, String accountId, String entityNumber, String entityKey, Boolean mirrorSync) {
        MainEntityTypeDto dto;
        this.getModel().setValue("fsourcesubentrykey", (Object)"");
        if (StringUtils.isBlank((CharSequence)entityKey)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fsourcesubentrykey"});
            return;
        }
        List<Object> subEntryItems = new ArrayList<ComboItem>();
        if (StringUtils.isNotBlank((CharSequence)entityNumber) && (dto = this.getRuleHelper.getMainEntityTypeFromCache(tenant, accountId, entityNumber, false)) != null && dto.getSubComboItems().size() > 0) {
            subEntryItems = (List)dto.getSubComboItems().get(entityKey);
        }
        if (subEntryItems == null || subEntryItems.size() == 0) {
            this.view.setVisible(Boolean.valueOf(false), new String[]{"fsourcesubentrykey"});
        } else {
            this.view.setVisible(Boolean.valueOf(true), new String[]{"fsourcesubentrykey"});
        }
        this.fillLinkSubEntityCombo("fsourcesubentrykey", subEntryItems);
    }

    public void fillLinkEntityCombo(CtConvertRuleElement ruleElement) {
        this.fillTgtLinkEntityCombo(ruleElement);
        this.fillSrcLinkEntityCombo(ruleElement);
    }

    private void fillSrcLinkEntityCombo(CtConvertRuleElement ruleElement) {
        List<ComboItem> entryItems = this.buildEntryComboItems(CtRuleCacheHelper.getSourceTenant(this.getView()), CtRuleCacheHelper.getSourceDataCenter(this.getView()), CtRuleCacheHelper.getSourceEntityNumber(this.getView()), false, ruleElement);
        ComboEdit entryEditor = (ComboEdit)this.getView().getControl("fsourceentrykey");
        entryEditor.setComboItems(entryItems);
        ComboEdit mirrorEntryEditor = (ComboEdit)this.getView().getControl("mirrorsourceentrykey");
        mirrorEntryEditor.setComboItems(entryItems);
        this.getModel().setValue("mirrorsourceentrykey", (Object)CtRuleCacheHelper.getSourceEntityNumber(this.getView()), 0);
        this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"mirrorsourceentrykey"});
    }

    private void fillTgtLinkEntityCombo(CtConvertRuleElement ruleElement) {
        List<ComboItem> entryItems = this.buildEntryComboItems(CtRuleCacheHelper.getTargetTenant(this.getView()), CtRuleCacheHelper.getTargetDataCenter(this.getView()), CtRuleCacheHelper.getTargetEntityNumber(this.getView()), true, ruleElement);
        ComboEdit entryEditor = (ComboEdit)this.getView().getControl("ftargetentrykey");
        entryEditor.setComboItems(entryItems);
        this.getModel().batchCreateNewEntryRow("mirrorlinkpolicy", entryItems.size());
        for (int i = 0; i < entryItems.size(); ++i) {
            this.getModel().setValue("mirrortargetentrykey", (Object)entryItems.get(i).getValue(), i);
            this.getModel().setValue("mirrortargetentryname", (Object)entryItems.get(i).getCaption().getLocaleValue(), i);
        }
    }

    private void fillLinkSubEntityCombo(String comboFldKey, List<ComboItem> subEntryItems) {
        ComboEdit subEntryEditor = (ComboEdit)this.getView().getControl(comboFldKey);
        subEntryEditor.setComboItems(subEntryItems);
    }

    private List<ComboItem> buildEntryComboItems(String tenant, String accountId, String entityNumber, Boolean isTargetBill, CtConvertRuleElement ruleElement) {
        MainEntityTypeDto mainEntityTypeDto;
        List<Object> entryItems = new ArrayList<ComboItem>();
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        entryItems.add(blankItem);
        if (StringUtils.isNotBlank((CharSequence)entityNumber) && (mainEntityTypeDto = this.getRuleHelper.getMainEntityType(tenant, accountId, entityNumber, isTargetBill, ruleElement)) != null) {
            entryItems = mainEntityTypeDto.getComboItems();
        }
        return entryItems;
    }

    public Map<String, ComboItem> buildSourceBillTypeItems(Map<String, String> map) {
        LinkedHashMap<String, ComboItem> items = new LinkedHashMap<String, ComboItem>(16);
        ComboItem all = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8\u7c7b\u578b", (String)"CtConvertRuleEdit_15", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0])), "All");
        items.put(all.getValue(), all);
        ComboItem other = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0a\u8ff0\u7c7b\u578b\u4e4b\u5916", (String)"CtConvertRuleEdit_16", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0])), "Others");
        items.put(other.getValue(), other);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ComboItem comboItem = new ComboItem(new LocaleString(entry.getValue()), entry.getKey());
            items.put(entry.getKey(), comboItem);
        }
        return items;
    }

    public Map<String, ComboItem> buildTargetBillTypeItems(Map<String, String> map) {
        LinkedHashMap<String, ComboItem> items = new LinkedHashMap<String, ComboItem>(16);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ComboItem comboItem = new ComboItem(new LocaleString(entry.getValue()), entry.getKey());
            items.put(entry.getKey(), comboItem);
        }
        return items;
    }

    private void removeInvalidFilterColumns(MainEntityType entityType, List<Map<String, Object>> cols) {
        Map fields = entityType.getAllFields();
        Iterator<Map<String, Object>> iterator = cols.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> col = iterator.next();
            if (col != null && col.get("fieldName") != null && !(fields.get((String)col.get("fieldName")) instanceof PictureProp)) continue;
            iterator.remove();
        }
    }

    private void fillFieldMapRow(Map<String, String> sourceFieldNameMap, CtFieldMapItem fieldMapItem, int rowIndex) {
        String localeId = RequestContext.get().getLang().toString();
        this.getModel().setValue("fconverttype", (Object)String.valueOf(fieldMapItem.getCtFieldConvertType().getValue()), rowIndex);
        this.getModel().setValue("fsumtype", (Object)String.valueOf(fieldMapItem.getCtFieldSumType().getValue()), rowIndex);
        if (fieldMapItem.getCtFieldConvertType() == CtFieldConvertType.SourceField) {
            String sourceFieldKey = fieldMapItem.getSourceFieldKey();
            String sourceFieldName = sourceFieldNameMap == null ? "" : sourceFieldNameMap.get(sourceFieldKey);
            this.getModel().setValue("fsourcefield", (Object)sourceFieldKey, rowIndex);
            this.getModel().setValue("fsourcefieldname", (Object)sourceFieldName, rowIndex);
            this.getModel().setValue("ffieldformula", (Object)"", rowIndex);
            this.getModel().setValue("ffieldformuladesc", (Object)"", rowIndex);
        } else {
            this.getModel().setValue("fsourcefield", (Object)"", rowIndex);
            this.getModel().setValue("fsourcefieldname", (Object)"", rowIndex);
            if (fieldMapItem.getCtFieldConvertType() == CtFieldConvertType.Formula) {
                if (fieldMapItem.getFormula() == null) {
                    this.getModel().setValue("ffieldformula", (Object)"", rowIndex);
                    this.getModel().setValue("ffieldformuladesc", (Object)"", rowIndex);
                } else {
                    String formula = SerializationUtils.toJsonString((Object)fieldMapItem.getFormula());
                    this.getModel().setValue("ffieldformula", (Object)formula, rowIndex);
                    this.getModel().setValue("ffieldformuladesc", (Object)fieldMapItem.getFormula().getExprDesc(), rowIndex);
                }
            } else if (fieldMapItem.getCtFieldConvertType() == CtFieldConvertType.ByCondition) {
                if (fieldMapItem.getValByConditions() == null) {
                    this.getModel().setValue("ffieldformula", (Object)"", rowIndex);
                    this.getModel().setValue("ffieldformuladesc", (Object)"", rowIndex);
                } else {
                    String formula = SerializationUtils.toJsonString((Object)fieldMapItem.getValByConditions());
                    this.getModel().setValue("ffieldformula", (Object)formula, rowIndex);
                    this.getModel().setValue("ffieldformuladesc", (Object)fieldMapItem.getValByConditions().getDescription(), rowIndex);
                }
            } else if (fieldMapItem.getCtFieldConvertType() == CtFieldConvertType.CONSTANT) {
                if (fieldMapItem.getConstant() == null) {
                    this.getModel().setValue("ffieldformula", (Object)"", rowIndex);
                    this.getModel().setValue("ffieldformuladesc", (Object)"", rowIndex);
                } else {
                    String constant = SerializationUtils.toJsonString((Object)fieldMapItem.getConstant());
                    this.getModel().setValue("ffieldformula", (Object)constant, rowIndex);
                    this.getModel().setValue("ffieldformuladesc", (Object)fieldMapItem.getConstant().getExprTran(), rowIndex);
                }
            }
        }
    }

    public void autoMatchFields(boolean mirrorsync) {
        CtGetRuleHelper getRuleHelper = new CtGetRuleHelper(this.getView(), this.plugin);
        String sourceEntityNumber = CtRuleCacheHelper.getSourceEntityNumber(this.getView());
        String sourceTenant = CtRuleCacheHelper.getSourceTenant(this.getView());
        String sourceAccountId = CtRuleCacheHelper.getSourceDataCenter(this.getView());
        String targetEntityNumber = CtRuleCacheHelper.getTargetEntityNumber(this.getView());
        String targetTenant = CtRuleCacheHelper.getTargetTenant(this.getView());
        String targetAccountId = CtRuleCacheHelper.getTargetDataCenter(this.getView());
        HashSet<String> tgtLinkEntitys = getRuleHelper.getTargetLinkEntitys();
        int rowCount = this.getModel().getEntryRowCount("fieldmappolicy");
        ArrayList<String> fields = new ArrayList<String>(16);
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            int convertType;
            String sourceFieldKey = (String)this.getModel().getValue("fsourcefield", rowIndex);
            if (StringUtils.isNotBlank((CharSequence)sourceFieldKey) || (convertType = Integer.parseInt((String)this.getModel().getValue("fconverttype", rowIndex))) != CtFieldConvertType.SourceField.getValue()) continue;
            String targetFieldKey = (String)this.getModel().getValue("ftargetfield", rowIndex);
            fields.add(targetFieldKey);
        }
        Map<String, DynamicPropertyDto> targetFields = getRuleHelper.autoMatchFieldsProperty(targetTenant, targetAccountId, targetEntityNumber, fields);
        Map<String, DynamicPropertyDto> sourceFields = getRuleHelper.autoMatchFieldsProperty(sourceTenant, sourceAccountId, sourceEntityNumber, fields);
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            DynamicPropertyDto sourceField;
            Boolean isSupportAutoBatch;
            String targetFieldKey;
            DynamicPropertyDto targetField;
            int convertType;
            String sourceFieldKey = (String)this.getModel().getValue("fsourcefield", rowIndex);
            if (StringUtils.isNotBlank((CharSequence)sourceFieldKey) || (convertType = Integer.parseInt((String)this.getModel().getValue("fconverttype", rowIndex))) != CtFieldConvertType.SourceField.getValue() || StringUtils.isBlank((CharSequence)(targetField = (DynamicPropertyDto)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)targetFields.get(targetFieldKey = (String)this.getModel().getValue("ftargetfield", rowIndex))), DynamicPropertyDto.class)).getClassName()) || !mirrorsync && !tgtLinkEntitys.contains(targetField.getParentName()) || !mirrorsync && !(isSupportAutoBatch = targetField.getSupportAutoBatch()).booleanValue() || (sourceField = (DynamicPropertyDto)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)sourceFields.get(targetFieldKey)), DynamicPropertyDto.class)) == null || !targetField.getClassName().equals(sourceField.getClassName()) || !StringUtils.isNotBlank((CharSequence)sourceField.getAlias())) continue;
            String sourceFieldName = sourceField.getFieldName();
            this.getModel().setValue("fsourcefield", (Object)sourceField.getDisplayName(), rowIndex);
            this.getModel().setValue("fsourcefieldname", (Object)sourceFieldName, rowIndex);
        }
    }

    public void clearSourceField(int row) {
        this.getModel().setValue("fsourcefield", (Object)"", row);
        this.getModel().setValue("fsourcefieldname", (Object)"", row);
    }
}

