/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin.ctbotp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.ctbotp.CtCRValByCondition;
import kd.bos.entity.ctbotp.CtCRValByConditions;
import kd.bos.entity.ctbotp.CtFieldConvertType;
import kd.bos.entity.ctbotp.CtRuleBaseDataItem;
import kd.bos.entity.ctbotp.constants.CtRuleModuleEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.dom4j.Element;
import org.dom4j.Node;

public class CtRuleCompatibleAbstract {
    private static final Log logger = LogFactory.getLog(CtRuleCompatibleAbstract.class);
    public MainEntityType sourceEntityType;
    public MainEntityType targetEntityType;
    public String devType;
    public String xmlContent;
    public Map<String, CtRuleBaseDataItem> ruleBaseDataItemMap = new HashMap<String, CtRuleBaseDataItem>(10);
    public Map<String, String> baseDataInfoMap = new HashMap<String, String>(10);
    public List<CtRuleBaseDataItem> ruleBaseDataItemList = new ArrayList<CtRuleBaseDataItem>(10);
    private int type;
    public StringBuilder warnMsg = new StringBuilder();
    public static final String BOS_BOTP_PLUGIN = "bos-botp-formplugin";

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getTargetFieldKey(Element element) {
        if (element == null) {
            return null;
        }
        String targetFieldKey = null;
        if ("0".equals(this.devType)) {
            Element ele = element.element("TargetFieldKey");
            if (ele == null) {
                return null;
            }
            targetFieldKey = ele.getStringValue();
        } else {
            targetFieldKey = element.attributeValue("oid");
        }
        return targetFieldKey;
    }

    public boolean checkXmlElementIsExist(Element rootElement) {
        if (rootElement.element("DesignMetas") == null || rootElement.element("DesignMetas").element("DesignConvertRuleMeta") == null) {
            return false;
        }
        String target = rootElement.element("DesignMetas").element("DesignConvertRuleMeta").element("TargetEntityNumber").getText();
        String devType = rootElement.element("DesignMetas").element("DesignConvertRuleMeta").element("DevType").getText();
        if (StringUtils.isEmpty((CharSequence)target)) {
            this.warnMsg.append(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219\u672a\u7ed1\u5b9a\u76ee\u6807\u5355\u636e\uff1b", (String)"BOTPFileUtil_13", (String)BOS_BOTP_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)devType)) {
            this.warnMsg.append(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219\u672a\u7ed1\u5b9a\u76ee\u6807\u5355\u636e\uff1b", (String)"BOTPFileUtil_13", (String)BOS_BOTP_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        String source = rootElement.element("DesignMetas").element("DesignConvertRuleMeta").element("SourceEntityNumber").getText();
        if (StringUtils.isEmpty((CharSequence)source)) {
            this.warnMsg.append(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219\u672a\u7ed1\u5b9a\u6e90\u5355\u636e\uff1b", (String)"BOTPFileUtil_14", (String)BOS_BOTP_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        MainEntityType targetMainEntityType = this.getFormMainEntityType(target);
        if (targetMainEntityType == null) {
            this.warnMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u76ee\u6807\u5355\u636e\u4e0d\u5b58\u5728\uff1b", (String)"BOTPFileUtil_15", (String)BOS_BOTP_PLUGIN, (Object[])new Object[0]), target));
            return false;
        }
        this.targetEntityType = targetMainEntityType;
        MainEntityType sourceMainEntityType = this.getFormMainEntityType(source);
        if (sourceMainEntityType == null) {
            this.warnMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u6e90\u5355\u636e\u4e0d\u5b58\u5728\uff1b", (String)"BOTPFileUtil_16", (String)BOS_BOTP_PLUGIN, (Object[])new Object[0]), source));
            return false;
        }
        this.sourceEntityType = sourceMainEntityType;
        this.devType = devType;
        return true;
    }

    public List getNodesByName(Element elem, CtRuleModuleEnum ruleModuleEnum) {
        switch (ruleModuleEnum) {
            case RUNCONDITION: {
                return elem.selectNodes("//RunCondition");
            }
            case FILTERPOLICY: {
                return elem.selectNodes("//FilterPolicy");
            }
            case BIZRULEPOLICY: {
                return elem.selectNodes("//CRBizRuleElement");
            }
            case FIELDMAPPOLICY: {
                return elem.selectNodes("//FieldMapItem");
            }
        }
        return null;
    }

    public MainEntityType getFormMainEntityType(String entityNumber) {
        try {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            return mainEntityType;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void doValByCondiionsString(Element elem) {
        Element byCondiionElement = elem.element("ValByCondiionsString");
        if (byCondiionElement == null) {
            return;
        }
        String targetFieldKey = this.getTargetFieldKey(elem);
        if (StringUtils.isEmpty((CharSequence)targetFieldKey)) {
            return;
        }
        String valByCondiions = byCondiionElement.getStringValue();
        if (StringUtils.isNotEmpty((CharSequence)valByCondiions)) {
            CtCRValByConditions crValByConditions = (CtCRValByConditions)SerializationUtils.fromJsonString((String)valByCondiions, CtCRValByConditions.class);
            if (crValByConditions == null || CollectionUtils.isEmpty((Collection)crValByConditions.getItems())) {
                return;
            }
            for (CtCRValByCondition crValByCondition : crValByConditions.getItems()) {
                if (crValByCondition == null) continue;
                if (crValByCondition.getIfconstant() == 1) {
                    String labelId;
                    String baseDataId;
                    CRFormula crFormula = crValByCondition.getFormula();
                    if (crFormula == null || StringUtils.isEmpty((CharSequence)(baseDataId = crFormula.getExpression())) || StringUtils.isEmpty((CharSequence)(labelId = crValByCondition.getId()))) continue;
                    String baseId = this.getBaseDataId(targetFieldKey, this.sourceEntityType, baseDataId);
                    if (StringUtils.isNotEmpty((CharSequence)baseId)) {
                        crFormula.setExpression(baseId);
                    }
                }
                if (crValByCondition.getCtCRCondition() == null || crValByCondition.getCtCRCondition().getFilterCondition() == null || CollectionUtils.isEmpty((Collection)crValByCondition.getCtCRCondition().getFilterCondition().getFilterRow())) continue;
                List simpleFilterRows = crValByCondition.getCtCRCondition().getFilterCondition().getFilterRow();
                for (SimpleFilterRow simpleFilterRow : simpleFilterRows) {
                    String fieldName;
                    DynamicProperty property;
                    if (!CollectionUtils.isNotEmpty((Collection)simpleFilterRow.getBaseDataIds()) || StringUtils.isEmpty((CharSequence)simpleFilterRow.getFieldName()) || (property = this.sourceEntityType.getProperty(fieldName = simpleFilterRow.getFieldName().split("\\.")[0])) == null || !(property instanceof BasedataProp)) continue;
                    for (FilterValue filterValue : simpleFilterRow.getBaseDataIds()) {
                        if (filterValue == null || filterValue.getValue() == null) continue;
                        String string = this.getBaseDataId(fieldName, this.sourceEntityType, String.valueOf(filterValue.getValue()));
                    }
                }
            }
        }
    }

    public void doConvertType2(Element elem) {
        String content;
        String text;
        Object[] strs;
        String fldConvType;
        Element convertType2Element = elem.element("ConvertType2");
        if (convertType2Element != null && StringUtils.isNotBlank((CharSequence)convertType2Element.getText()) && StringUtils.equalsIgnoreCase((CharSequence)(fldConvType = (strs = StringUtils.split((String)(text = convertType2Element.getText()), (String)","))[0]), (CharSequence)CtFieldConvertType.ByCondition.toString()) && StringUtils.isNotBlank((CharSequence)(content = strs[1]))) {
            Object[] condiions = content.split(";");
            for (int i = 0; i < condiions.length; ++i) {
                Object[] items = condiions[i].split("_");
                String ifconstant = items[3];
                if (!"1".equals(ifconstant)) continue;
                String realId = this.baseDataInfoMap.get(items[0]);
                if (StringUtils.isNotBlank((CharSequence)realId)) {
                    items[4] = realId;
                }
                condiions[i] = StringUtils.join((Object[])items, (String)"_");
            }
            strs[1] = content = StringUtils.join((Object[])condiions, (String)";");
            String byCondition = StringUtils.join((Object[])strs, (String)",");
            convertType2Element.setText(byCondition);
        }
    }

    public void doFieleMappolicy(Element element) {
        List fieldMapPolicyNodeLists = this.getNodesByName(element, CtRuleModuleEnum.FIELDMAPPOLICY);
        for (Element elem : fieldMapPolicyNodeLists) {
            Element convertTypeElement = elem.element("ConvertType");
            if (convertTypeElement == null) continue;
            String convertType = convertTypeElement.getText();
            if ("CONSTANT".equals(convertType)) {
                this.doConstant(elem);
                continue;
            }
            if (!"ByCondition".equals(convertType)) continue;
            this.doValByCondiionsString(elem);
        }
    }

    public void doConstant(Element elem) {
        String targetFieldKey = this.getTargetFieldKey(elem);
        Node formulaNode = elem.selectSingleNode(".//CRFormula");
        if (formulaNode == null) {
            return;
        }
        Element formulaEle = (Element)formulaNode;
        Element expressionNode = formulaEle.element("Expression");
        if (expressionNode == null) {
            return;
        }
        String baseId = this.getBaseDataId(targetFieldKey, this.targetEntityType, String.valueOf(expressionNode.getText()));
    }

    public String getBaseDataId(String fieldKey, MainEntityType entityType, String baseDataId) {
        if (StringUtils.isEmpty((CharSequence)fieldKey)) {
            return null;
        }
        BasedataEntityType bdType = this.getBasedataEntityType(fieldKey, entityType);
        if (bdType != null) {
            String bdName = bdType.getName();
            String numberProperty = bdType.getNumberProperty();
            String displayName = bdType.getDisplayName() == null ? bdName : bdType.getDisplayName().getLocaleValue();
            String id = String.valueOf(baseDataId);
            QFilter[] filter = new QFilter[2];
            filter[0] = bdType.getPrimaryKey() instanceof LongProp ? new QFilter("id", "=", (Object)Long.parseLong(id)) : new QFilter("id", "=", (Object)id);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)bdName, (QFilter[])filter);
            if (dynamicObject == null) {
                this.collectWarnMsg(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u3010%1$s\u3011\u4e0d\u5b58\u5728id\u4e3a%2$s\u6570\u636e\uff1b", (String)"BOTPFileUtil_20", (String)BOS_BOTP_PLUGIN, (Object[])new Object[0]), displayName, id));
                return null;
            }
        } else {
            this.collectWarnMsg(String.format(ResManager.loadKDString((String)"\u6807\u8bc6\u4e3a%s\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728\uff1b", (String)"BOTPFileUtil_17", (String)BOS_BOTP_PLUGIN, (Object[])new Object[0]), fieldKey));
        }
        return null;
    }

    private BasedataEntityType getBasedataEntityType(String fieldKey, MainEntityType entityType) {
        String[] fieldNames = fieldKey.split("\\.");
        BasedataEntityType bdType = null;
        if (fieldNames.length == 1) {
            IDataEntityProperty property = entityType.findProperty(fieldKey);
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                bdType = (BasedataEntityType)bdProp.getComplexType();
                return bdType;
            }
            return null;
        }
        for (int i = 0; i < fieldNames.length && i != fieldNames.length - 1; ++i) {
            IDataEntityProperty property = null;
            if (i == 0) {
                property = entityType.findProperty(fieldNames[0]);
            } else {
                if (bdType == null) break;
                property = bdType.findProperty(fieldNames[i]);
            }
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                bdType = (BasedataEntityType)bdProp.getComplexType();
                continue;
            }
            bdType = null;
        }
        return bdType;
    }

    private void collectWarnMsg(String msg) {
        if (!this.warnMsg.toString().contains(msg)) {
            this.warnMsg.append(msg);
        }
    }

    public void doFilterStringWitchCheck(Element element) {
        Node filterPolicyStringNode = element.selectSingleNode(".//FilterString");
        if (filterPolicyStringNode == null) {
            return;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterPolicyStringNode.getText(), FilterCondition.class);
        List fpSimpleFilterRows = filterCondition.getFilterRow();
        for (SimpleFilterRow simpleFilterRow : fpSimpleFilterRows) {
            if (!CollectionUtils.isNotEmpty((Collection)simpleFilterRow.getBaseDataIds())) continue;
            String fieldName = simpleFilterRow.getFieldName();
            for (FilterValue filterValue : simpleFilterRow.getBaseDataIds()) {
                String string = this.getBaseDataId(fieldName, this.sourceEntityType, String.valueOf(filterValue.getValue()));
            }
        }
    }
}

