/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin.ctbotp;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.plugin.ctbotp.CtRuleCompatibleAbstract;
import kd.bos.entity.ctbotp.constants.CtRuleModuleEnum;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.collections.CollectionUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CtRuleCompatibleImport
extends CtRuleCompatibleAbstract {
    private static final Log logger = LogFactory.getLog(CtRuleCompatibleImport.class);

    public CtRuleCompatibleImport(int type) {
        this.setType(type);
    }

    public void doCompatible(String xmlContent, JSONObject importResult) {
        try {
            Document document = DocumentHelper.parseText((String)xmlContent);
            Element rootElement = document.getRootElement();
            this.checkXmlElementIsExist(rootElement);
            this.checkBaseDataElement(rootElement);
            String msg = this.warnMsg.toString();
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                importResult.put("checkBaseDataWarnMsg", (Object)msg);
            }
        }
        catch (DocumentException e) {
            logger.error(e.getMessage());
        }
    }

    private void checkBaseDataElement(Element element) {
        List filterPolicyEleList;
        this.doFieleMappolicy(element);
        List runConditionEleList = this.getNodesByName(element, CtRuleModuleEnum.RUNCONDITION);
        if (CollectionUtils.isNotEmpty((Collection)runConditionEleList)) {
            Element runConditionEle = (Element)runConditionEleList.get(0);
            this.doFilterStringWitchCheck(runConditionEle);
        }
        if (CollectionUtils.isNotEmpty((Collection)(filterPolicyEleList = this.getNodesByName(element, CtRuleModuleEnum.FILTERPOLICY)))) {
            Element filterPolicyEle = (Element)filterPolicyEleList.get(0);
            this.doFilterStringWitchCheck(filterPolicyEle);
        }
    }
}

