/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.ctbotp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.link.CtBillLinkService;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.CtConvertBill;
import kd.bos.entity.ctbotp.CtConvertOpType;
import kd.bos.entity.ctbotp.CtDataCenter;
import kd.bos.entity.ctbotp.CtTenantData;
import kd.bos.entity.ctbotp.constants.SourceOperateEnum;
import kd.bos.entity.ctbotp.constants.SyncTypeEnum;
import kd.bos.entity.ctbotp.link.CtLkUpQueryArgs;
import kd.bos.entity.ctbotp.runtime.AbstractCtConvertServiceArgs;
import kd.bos.entity.ctbotp.runtime.CtConvertOpParameter;
import kd.bos.entity.ctbotp.runtime.CtConvertOpRule;
import kd.bos.entity.ctbotp.runtime.CtConvertOperationResult;
import kd.bos.entity.ctbotp.runtime.CtOpInfo;
import kd.bos.entity.ctbotp.runtime.CtPushArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.Plugin;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.CtPush;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.ctbotp.CtReleaseConvertDataMutexPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.CtConvertMetaServiceHelper;
import kd.bos.servicehelper.CtConvertServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class CtConvertOpFormEdit
extends AbstractFormPlugin {
    public CtConvertOpParameter opParameter;
    public static final String ALLRULE = "@all";
    private static final Log log = LogFactory.getLog(CtConvertOpFormEdit.class);
    private static final String BOS_FORM_BUSINESS = "bos-botp-formplugin";
    public static final String FormId_ConvertOp = "botp_convertop";
    public static final String FormId_ConvertResult = "botp_convertresult";
    public static final String CustParam_OpParam = "opparam";
    private static final String KEY_FTENANT = "ftenant";
    private static final String KEY_FACCOUNTID = "faccountid";
    private static final String KEY_FBILL = "fbill";
    private static final String KEY_FSYNCTYPE = "fsynctype";
    private static final String KEY_FRULE = "frule";
    private static final String KEY_FRELATIONORG = "frelationorg";
    private static final String KEY_SHOWREPORT = "showreport";
    private static final String KEY_OUTFORMULA = "outformula";
    private static final String KEY_PUSHANDSAVE = "pushandsave";
    private static final String KEY_BACKGROUND_OPTION = "backgroundoption";
    private static final String KEY_OK = "btnok";
    private static final String BILLPARAMETER_SHOWREPORT = "default_showreport";
    private static final String CLOSECALLACTIONID_DRAW = "draw";
    private static final String CLOSECALLACTIONID_CONVERTPROGRESS = "convertprogress";
    private static final String BOS_BOTP_FORMPLUGIN = "bos-botp-formplugin";
    private static final String BOTP_TENANTDATA = "ct_botp_tenantdata";
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"CtConvertOpFormEdit", (int)5);
    private static final Log logger = LogFactory.getLog(CtConvertOpFormEdit.class);

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_OK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getConvertOpParamter();
        this.fillTenantCombo();
        this.fillAccountCombo();
        this.fillBillCombo();
        this.fillRuleCombo(false);
        this.setShowReportByBillParameter();
    }

    private void setShowReportByBillParameter() {
        try {
            CtConvertOpType opType = this.opParameter.getOpType();
            if (opType != CtConvertOpType.Push) {
                return;
            }
            String entityNumber = this.opParameter.getEntityNumber();
            if (StringUtils.isBlank((CharSequence)entityNumber)) {
                return;
            }
            Map billParameter = SystemParamServiceHelper.loadBillParameterObjectFromCache((String)entityNumber);
            if (MapUtils.isEmpty((Map)billParameter)) {
                return;
            }
            boolean defaultShowReport = (Boolean)billParameter.get(BILLPARAMETER_SHOWREPORT);
            this.getModel().setValue(KEY_SHOWREPORT, (Object)defaultShowReport);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getConvertOpParamter().getOpType().compareTo((Enum)CtConvertOpType.Push) != 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_SHOWREPORT, KEY_OUTFORMULA});
        }
    }

    public void click(EventObject evt) {
        CtConvertOpParameter opParameter;
        super.click(evt);
        Control srcCtrl = (Control)evt.getSource();
        if (KEY_OK.equalsIgnoreCase(srcCtrl.getKey()) && (opParameter = this.getConvertOpParamter()).getOpType() == CtConvertOpType.Push) {
            this.doPush(opParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equalsIgnoreCase(KEY_FTENANT)) {
            this.fillAccountCombo();
            this.fillBillCombo();
            this.fillRuleCombo(true);
        }
        if (e.getProperty().getName().equalsIgnoreCase(KEY_FACCOUNTID)) {
            this.fillBillCombo();
            this.fillRuleCombo(true);
        }
        if (e.getProperty().getName().equalsIgnoreCase(KEY_FBILL)) {
            this.fillRuleCombo(true);
        }
        if (e.getProperty().getName().equalsIgnoreCase(KEY_FSYNCTYPE)) {
            this.fillRuleCombo(true);
        }
    }

    private void doPush(CtConvertOpParameter opParameter) {
        CtPushArgs args;
        String tenant = (String)this.getModel().getValue(KEY_FTENANT);
        String accountid = (String)this.getModel().getValue(KEY_FACCOUNTID);
        String targetEntityNumber = (String)this.getModel().getValue(KEY_FBILL);
        String syntype = (String)this.getModel().getValue(KEY_FSYNCTYPE);
        String ruleId = (String)this.getModel().getValue(KEY_FRULE);
        String defOrgId = (String)this.getModel().getValue(KEY_FRELATIONORG);
        Boolean showReport = (Boolean)this.getModel().getValue(KEY_SHOWREPORT);
        String backGroundOption = "1";
        if (this.getModel().getProperty(KEY_BACKGROUND_OPTION) != null) {
            backGroundOption = (String)this.getModel().getValue(KEY_BACKGROUND_OPTION);
        }
        if ((args = this.buildPushArgs(syntype, tenant, accountid, opParameter, targetEntityNumber, ruleId, defOrgId)) == null) {
            return;
        }
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        CtPush.addPushByBillOption((IFormView)parentView, (AbstractCtConvertServiceArgs)args);
        if ("1".equals(backGroundOption) && args.getSelectedRows().size() > 20000 || "2".equals(backGroundOption)) {
            args.setShowReport(showReport.booleanValue());
            return;
        }
        logger.info("\u4e0b\u63a8\u53c2\u6570\uff1a" + SerializationUtils.toJsonString((Object)args));
        if (SyncTypeEnum.REVERSE.getValue().equals(syntype)) {
            List ids = args.getSelectedRows().stream().map(a -> Long.parseLong(a.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            CtLkUpQueryArgs ctLkUpQueryArgs = new CtLkUpQueryArgs();
            ctLkUpQueryArgs.settTenantCode(RequestContext.get().getTenantCode());
            ctLkUpQueryArgs.settAccountId(RequestContext.get().getAccountId());
            ctLkUpQueryArgs.settEntityKey(args.getSourceEntityNumber());
            ctLkUpQueryArgs.settBillIds(ids);
            List ctBillLks = CtBillLinkService.getCtDirtBillLkUp((CtLkUpQueryArgs)ctLkUpQueryArgs);
            args.setCtBillLks(ctBillLks);
        }
        CtConvertOperationResult ctConvertOperationResult = CtConvertServiceHelper.ctPush((CtPushArgs)args);
        CtPush.showReport((IFormView)parentView, (AbstractCtConvertServiceArgs)args, (CtConvertOperationResult)ctConvertOperationResult);
        this.getView().sendFormAction(parentView);
        this.getView().close();
    }

    private CtPushArgs buildPushArgs(String synctype, String tenant, String accountid, CtConvertOpParameter opParameter, String targetEntityNumber, String ruleId, String defOrgId) {
        CtPushArgs args = new CtPushArgs();
        args.settTenantCode(tenant);
        args.settAccountId(accountid);
        args.setSyncType(synctype);
        args.setSourceEntityNumber(opParameter.getEntityNumber());
        args.setTargetEntityNumber(targetEntityNumber);
        args.setHasRight(opParameter.isHasRight());
        args.addCustomParam("botp_requiredatamutex", String.valueOf(true));
        args.setSourceOperate(SourceOperateEnum.OPERATE.getValue());
        args.setAutoSave(true);
        args.setRuleId(ruleId);
        if (!StringUtils.isBlank((CharSequence)defOrgId) && !StringUtils.equals((CharSequence)"0", (CharSequence)defOrgId)) {
            args.setDefOrgId(Long.valueOf(defOrgId));
        }
        args.setSelectedRows((List)opParameter.getSelectedRows());
        args.setBuildConvReport(true);
        args.getCustomParams().putAll(opParameter.getCustomParams());
        return args;
    }

    private void addReleaseSourceDataMutexPlugin(IFormView billView, CtConvertOperationResult drawResult) {
        boolean exist = false;
        String plugInName = CtReleaseConvertDataMutexPlugin.class.getName();
        for (Plugin plugin : billView.getFormShowParameter().getFormConfig().getPlugins()) {
            if (!StringUtils.equals((CharSequence)plugin.getClassName(), (CharSequence)plugInName)) continue;
            exist = true;
            break;
        }
        if (!exist) {
            billView.getFormShowParameter().addCustPlugin(plugInName);
            billView.cacheFormShowParameter();
        }
    }

    private CtConvertOpParameter getConvertOpParamter() {
        if (this.opParameter == null) {
            String opParamJson = (String)this.getView().getFormShowParameter().getCustomParam(CustParam_OpParam);
            if (StringUtils.isNotBlank((CharSequence)opParamJson)) {
                this.opParameter = (CtConvertOpParameter)SerializationUtils.fromJsonString((String)opParamJson, CtConvertOpParameter.class);
            } else {
                this.opParameter = new CtConvertOpParameter();
                this.opParameter.setOpType(CtConvertOpType.Push);
            }
            String opInfoJson = (String)this.getView().getFormShowParameter().getCustomParam("opinfo");
            if (StringUtils.isNotBlank((CharSequence)opInfoJson)) {
                CtOpInfo opInfo = (CtOpInfo)SerializationUtils.fromJsonString((String)opInfoJson, CtOpInfo.class);
                this.opParameter.setOpInfo(opInfo);
            }
        }
        return this.opParameter;
    }

    private void fillTenantCombo() {
        String entityNumber = this.opParameter.getEntityNumber();
        List<ComboItem> tenantItems = this.buildTenantItems(entityNumber);
        if (CollectionUtils.isEmpty(tenantItems)) {
            return;
        }
        ComboEdit tenantEditor = (ComboEdit)this.getView().getControl(KEY_FTENANT);
        tenantEditor.setComboItems(tenantItems);
        this.getModel().setValue(KEY_FTENANT, (Object)tenantItems.get(0).getValue());
    }

    private List<ComboItem> buildTenantItems(String entityNumber) {
        List tenantDatas = CtConvertMetaServiceHelper.loadTenantDatas((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)entityNumber);
        if (CollectionUtils.isEmpty((Collection)tenantDatas)) {
            return null;
        }
        this.getView().getPageCache().put(BOTP_TENANTDATA, SerializationUtils.toJsonString((Object)tenantDatas));
        ArrayList<ComboItem> billItems = new ArrayList<ComboItem>(10);
        for (CtTenantData tenantData : tenantDatas) {
            ComboItem billItem = new ComboItem();
            billItem.setValue(tenantData.getTenantNumber());
            billItem.setCaption(new LocaleString(Lang.defaultLang().toString(), tenantData.getTenantName()));
            billItems.add(billItem);
        }
        return billItems;
    }

    private void fillAccountCombo() {
        CtTenantData currTenant = this.getCurrCtTenant();
        if (currTenant == null) {
            this.cleanComboEdit(KEY_FACCOUNTID);
            return;
        }
        ArrayList<ComboItem> dataCenterItems = new ArrayList<ComboItem>(10);
        for (CtDataCenter dataCenter : currTenant.getDataCenter().values()) {
            ComboItem dataCenterItem = new ComboItem();
            dataCenterItem.setValue(dataCenter.getDataCenterNumber());
            dataCenterItem.setCaption(new LocaleString(dataCenter.getDataCenterName()));
            dataCenterItems.add(dataCenterItem);
        }
        if (dataCenterItems.isEmpty()) {
            this.cleanComboEdit(KEY_FACCOUNTID);
            return;
        }
        ComboEdit dataCenterEditor = (ComboEdit)this.getView().getControl(KEY_FACCOUNTID);
        dataCenterEditor.setComboItems(dataCenterItems);
        this.getModel().setValue(KEY_FACCOUNTID, (Object)((ComboItem)dataCenterItems.get(0)).getValue());
    }

    private CtTenantData getCurrCtTenant() {
        try {
            String teantData = this.getView().getPageCache().get(BOTP_TENANTDATA);
            if (StringUtils.isBlank((CharSequence)teantData)) {
                return null;
            }
            List tenantDatas = SerializationUtils.fromJsonStringToList((String)teantData, CtTenantData.class);
            Object tenant = this.getModel().getValue(KEY_FTENANT);
            if (StringUtils.isBlank((Object)tenant)) {
                return null;
            }
            for (CtTenantData tenantData : tenantDatas) {
                if (!tenant.equals(tenantData.getTenantNumber())) continue;
                return tenantData;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u79df\u6237\u4fe1\u606f\u3002", (String)"CtConvertOpFormEdit_1", (String)"bos-ctbotp-formplugin", (Object[])new Object[0]));
    }

    private void fillBillCombo() {
        CtTenantData currTenant = this.getCurrCtTenant();
        if (currTenant == null) {
            this.cleanComboEdit(KEY_FBILL);
            return;
        }
        Object dataCenterNumber = this.getModel().getValue(KEY_FACCOUNTID);
        if (StringUtils.isBlank((Object)dataCenterNumber)) {
            this.cleanComboEdit(KEY_FBILL);
            return;
        }
        CtDataCenter dataCenter = (CtDataCenter)currTenant.getDataCenter().get(dataCenterNumber);
        ArrayList<ComboItem> billItems = new ArrayList<ComboItem>(10);
        for (CtConvertBill bill : dataCenter.getBills().values()) {
            ComboItem billItem = new ComboItem();
            billItem.setValue(bill.getEntityNumber());
            billItem.setCaption(new LocaleString(Lang.defaultLang().toString(), bill.getEntityName()));
            billItems.add(billItem);
        }
        if (billItems.isEmpty()) {
            this.cleanComboEdit(KEY_FBILL);
            return;
        }
        ComboEdit billEditor = (ComboEdit)this.getView().getControl(KEY_FBILL);
        billEditor.setComboItems(billItems);
        this.getModel().setValue(KEY_FBILL, (Object)((ComboItem)billItems.get(0)).getValue());
    }

    private void fillRuleCombo(boolean change) {
        CtTenantData currTenant = this.getCurrCtTenant();
        Object dataCenterNumber = this.getModel().getValue(KEY_FACCOUNTID);
        if (StringUtils.isBlank((Object)dataCenterNumber)) {
            this.cleanComboEdit(KEY_FRULE);
            return;
        }
        if (currTenant == null) {
            log.error("currTenant is null");
            return;
        }
        CtDataCenter dataCenter = (CtDataCenter)currTenant.getDataCenter().get(dataCenterNumber);
        Object billNumber = this.getModel().getValue(KEY_FBILL);
        if (StringUtils.isBlank((Object)billNumber)) {
            this.cleanComboEdit(KEY_FRULE);
            return;
        }
        CtConvertBill bill = (CtConvertBill)dataCenter.getBills().get(billNumber);
        ArrayList<Object> ruleItems = new ArrayList();
        ArrayList<ComboItem> forwardRuleItems = new ArrayList<ComboItem>();
        ArrayList<ComboItem> reverseRuleItems = new ArrayList<ComboItem>();
        String syncType = this.getModel().getValue(KEY_FSYNCTYPE).toString();
        if (bill != null) {
            for (CtConvertOpRule rule : bill.getRules()) {
                ComboItem ruleItem = new ComboItem();
                ruleItem.setValue(rule.getRuleId());
                ruleItem.setCaption(new LocaleString(rule.getRuleName()));
                if (!SyncTypeEnum.FORWARD.getValue().equals(rule.getSyncType())) {
                    reverseRuleItems.add(ruleItem);
                    continue;
                }
                forwardRuleItems.add(ruleItem);
            }
        }
        if (!change) {
            if (forwardRuleItems.size() > 0) {
                this.getModel().setValue(KEY_FSYNCTYPE, (Object)SyncTypeEnum.FORWARD.getValue());
                ruleItems = forwardRuleItems;
            } else if (reverseRuleItems.size() > 0) {
                this.getModel().setValue(KEY_FSYNCTYPE, (Object)SyncTypeEnum.REVERSE.getValue());
                ruleItems = reverseRuleItems;
            }
        } else {
            ruleItems = syncType.equals(SyncTypeEnum.FORWARD.getValue()) ? forwardRuleItems : reverseRuleItems;
        }
        if (ruleItems.isEmpty()) {
            this.cleanComboEdit(KEY_FRULE);
            return;
        }
        ComboEdit ruleEditor = (ComboEdit)this.getView().getControl(KEY_FRULE);
        ruleEditor.setComboItems(ruleItems);
        this.getModel().setValue(KEY_FRULE, (Object)((ComboItem)ruleItems.get(0)).getValue());
    }

    private void cleanComboEdit(String key) {
        ArrayList items = new ArrayList();
        ComboEdit ruleEditor = (ComboEdit)this.getView().getControl(key);
        ruleEditor.setComboItems(items);
        this.getModel().setValue(key, (Object)"");
    }
}

