/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.ctbotp;

import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.CtTrackDataEntity;
import kd.bos.entity.ctbotp.CtTrackEntityField;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.service.ctbotp.utils.CtBotpTenantUtils;

public class TenantBillEdit
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(TenantBillEdit.class);
    private static final String KEY_ENTRYCONTAINER = "entryentity";
    private static final String KEY_BASEINFOCONTAINER = "fs_baseinfo";
    private static CtTrackDataEntity CTTRACKBILLDATA;

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        CTTRACKBILLDATA = this.getCTBillData(showParameter);
        FlexPanelAp headAp = this.createDynamicPanel();
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", KEY_BASEINFOCONTAINER);
        mapHead.put("items", (String)headAp.createControl().get("items"));
        e.getItems().add(mapHead);
        int useEntryCount = 0;
        for (Map.Entry entry : CTTRACKBILLDATA.getEntityEntrys().entrySet()) {
            if (entry == null || entry.getValue() == null || ((List)entry.getValue()).size() == 0) continue;
            CtTrackDataEntity ctTrackDataEntry = (CtTrackDataEntity)((List)entry.getValue()).get(0);
            EntryAp entryAp = this.createDynamicEntryAp(ctTrackDataEntry);
            HashMap<String, String> mapEntry = new HashMap<String, String>();
            mapEntry.put("id", KEY_ENTRYCONTAINER + useEntryCount);
            mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
            e.getItems().add(mapEntry);
            ++useEntryCount;
        }
    }

    public void beforeBindData(EventObject e) {
        FlexPanelAp dynamicPanel = this.createDynamicPanel();
        Container baseInfoPanel = (Container)this.getView().getControl(KEY_BASEINFOCONTAINER);
        baseInfoPanel.getItems().addAll(((Container)dynamicPanel.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(baseInfoPanel.getItems());
        int useEntryCount = 0;
        for (Map.Entry entry : CTTRACKBILLDATA.getEntityEntrys().entrySet()) {
            if (entry == null || entry.getValue() == null || ((List)entry.getValue()).size() == 0) continue;
            CtTrackDataEntity ctTrackDataEntry = (CtTrackDataEntity)((List)entry.getValue()).get(0);
            EntryAp dynamicEntryAp = this.createDynamicEntryAp(ctTrackDataEntry);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYCONTAINER + useEntryCount);
            List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
            for (Control fieldEdit : fieldEdits) {
                fieldEdit.setView(this.getView());
                entryGrid.getItems().add(fieldEdit);
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_ENTRYCONTAINER + useEntryCount});
            ++useEntryCount;
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        for (int i = 0; i < 10; ++i) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_ENTRYCONTAINER + i});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("setFormStatus", (Object)"2");
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    private CtTrackDataEntity getCTBillData(FormShowParameter showParameter) {
        Long billId = (Long)showParameter.getCustomParam("billId");
        String billNumber = (String)showParameter.getCustomParam("billNumber");
        String tenantCode = (String)showParameter.getCustomParam("tenantCode");
        String accountId = (String)showParameter.getCustomParam("accountId");
        return CtBotpTenantUtils.getCtTrackDataEntity((String)tenantCode, (String)accountId, (String)billNumber, (Long)billId);
    }

    private void registDynamicProps(MainEntityType newMainType) {
        List fieldList = CTTRACKBILLDATA.getFieldList();
        this.registProps((EntityType)newMainType, fieldList);
        int useEntryCount = 0;
        for (Map.Entry entry : CTTRACKBILLDATA.getEntityEntrys().entrySet()) {
            if (entry == null || entry.getValue() == null || ((List)entry.getValue()).size() == 0) continue;
            CtTrackDataEntity ctTrackDataEntry = (CtTrackDataEntity)((List)entry.getValue()).get(0);
            EntryType entryType = (EntryType)newMainType.getAllEntities().get(KEY_ENTRYCONTAINER + useEntryCount);
            this.registProps((EntityType)entryType, ctTrackDataEntry.getFieldList());
            ++useEntryCount;
        }
    }

    private void registProps(EntityType entityType, List<CtTrackEntityField> fieldList) {
        for (CtTrackEntityField ctTrackEntityField : fieldList) {
            TextProp textProp = this.buildTextProp(ctTrackEntityField);
            entityType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        }
    }

    private TextProp buildTextProp(CtTrackEntityField field) {
        TextProp textProp = new TextProp();
        textProp.setName(field.getFieldKey());
        textProp.setDisplayName(new LocaleString(field.getName()));
        return textProp;
    }

    public void createNewData(BizDataEventArgs e) {
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        this.buildFieldData(dataEntity, CTTRACKBILLDATA.getFieldList());
        int useEntryCount = 0;
        for (Map.Entry entry : CTTRACKBILLDATA.getEntityEntrys().entrySet()) {
            DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection(KEY_ENTRYCONTAINER + useEntryCount);
            for (CtTrackDataEntity CtTrackDataEntry : (List)entry.getValue()) {
                DynamicObject newRow = new DynamicObject(rows.getDynamicObjectType());
                this.buildFieldData(newRow, CtTrackDataEntry.getFieldList());
                rows.add((Object)newRow);
            }
            ++useEntryCount;
        }
        e.setDataEntity((Object)dataEntity);
    }

    private void buildFieldData(DynamicObject dataEntity, List<CtTrackEntityField> fieldList) {
        for (CtTrackEntityField field : fieldList) {
            dataEntity.set(field.getFieldKey(), (Object)field.getValue());
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
    }

    private FlexPanelAp createDynamicPanel() {
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey("headAp");
        LinkedList<FieldAp> fieldApItems = new LinkedList<FieldAp>();
        for (CtTrackEntityField field : CTTRACKBILLDATA.getFieldList()) {
            String fieldNumber = field.getFieldKey();
            String fieldName = field.getName();
            FieldAp fieldAp = new FieldAp();
            fieldAp.setId(fieldNumber);
            fieldAp.setKey(fieldNumber);
            fieldAp.setName(new LocaleString(fieldName));
            fieldAp.setBackColor("#FFFFFF");
            fieldAp.setHeight(new LocaleString("40px"));
            fieldAp.setWidth(new LocaleString("230px"));
            fieldAp.setComboShowStyle(2);
            Margin margin = new Margin();
            margin.setTop("8px");
            margin.setBottom("8px");
            margin.setRight("-145px");
            Style style = new Style();
            style.setMargin(margin);
            fieldAp.setStyle(style);
            TextField textfield = new TextField();
            textfield.setId(fieldNumber);
            textfield.setKey(fieldNumber);
            fieldAp.setField((Field)textfield);
            fieldApItems.add(fieldAp);
        }
        headPanelAp.getItems().addAll(fieldApItems);
        return headPanelAp;
    }

    private EntryAp createDynamicEntryAp(CtTrackDataEntity ctTrackDataEntry) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryap");
        for (CtTrackEntityField field : ctTrackDataEntry.getFieldList()) {
            String fieldNumber = field.getFieldKey();
            String fieldName = field.getName();
            EntryFieldAp fieldAp = new EntryFieldAp();
            fieldAp.setId(fieldNumber);
            fieldAp.setKey(fieldNumber);
            fieldAp.setName(new LocaleString(fieldName));
            TextField textField = new TextField();
            textField.setId(fieldNumber);
            textField.setKey(fieldNumber);
            fieldAp.setField((Field)textField);
            entryAp.getItems().add(fieldAp);
        }
        return entryAp;
    }
}

