/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.CtLinkSetElement;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.CtConvertPath;
import kd.bos.entity.ctbotp.apiparam.CtSyncRouteArgs;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.link.CtBillIdLink;
import kd.bos.entity.ctbotp.runtime.CtBFTable;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ctbotp.save.lk.CtBotpRouteManage;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;
import kd.bos.servicehelper.CtConvertMetaServiceHelper;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.ListUtils;

public class AddSyncRouteTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(AddSyncRouteTask.class);

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        LOG.info("------ AddSyncRouteTask begin ------");
        List ctConvertPaths = CtConvertMetaServiceHelper.loadAllConvertPaths();
        for (CtConvertPath ctConvertPath : ctConvertPaths) {
            String sTenantCode = ctConvertPath.getSourceTenant();
            String sAccountId = ctConvertPath.getSourceAccountId();
            String sEntityKey = ctConvertPath.getSourceEntityNumber();
            String tTenantCode = ctConvertPath.getTargetTenant();
            String tAccountId = ctConvertPath.getTargetAccountId();
            String tEntityKey = ctConvertPath.getTargetEntityNumber();
            if (StringUtils.isBlank((CharSequence)sTenantCode) || StringUtils.isBlank((CharSequence)sAccountId) || StringUtils.isBlank((CharSequence)sEntityKey) || StringUtils.isBlank((CharSequence)tTenantCode) || StringUtils.isBlank((CharSequence)tAccountId) || StringUtils.isBlank((CharSequence)tEntityKey) || !tTenantCode.equals(RequestContext.get().getTenantId()) || !tAccountId.equals(RequestContext.get().getAccountId())) continue;
            try {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)tEntityKey);
                CtLinkSetElement ctLinkSetElement = EntityMetadataCache.getCtLinkSet((String)tEntityKey);
                if (ctLinkSetElement == null || StringUtils.isEmpty((CharSequence)ctLinkSetElement.getCtTrackerTable())) continue;
                this.queryAndAddRoute(tEntityKey, new DBRoute(mainEntityType.getDBRouteKey()), ctLinkSetElement.getCtTrackerTable());
            }
            catch (Exception e) {}
        }
        LOG.info("------ AddSyncRouteTask end ------");
    }

    private void queryAndAddRoute(String entityKey, DBRoute dbRoute, String tcTableName) {
        StringBuilder sqlBuilder = new StringBuilder();
        String querySql = "SELECT fstenantcode,fsaccountid,fsentitykey,fsbillid,fttenantcode,ftaccountid,ftentitykey,ftbillid FROM ";
        sqlBuilder.append(querySql);
        sqlBuilder.append(tcTableName);
        HashMap ctBFTableCtAddLinkArgsMap = new HashMap();
        try (DataSet dataset = DB.queryDataSet((String)"algo-AddSyncRouteTask", (DBRoute)dbRoute, (String)sqlBuilder.toString());){
            ArrayList ctAddLinkArgs = new ArrayList();
            boolean i = false;
            for (Row row : dataset) {
                String sTenantCode = row.getString(0);
                String sAccountId = row.getString(1);
                String sEntityKey = row.getString(2);
                Long sBillId = row.getLong(3);
                String tTenantCode = row.getString(4);
                String tAccountId = row.getString(5);
                String tEntityKey = row.getString(6);
                Long tBillId = row.getLong(7);
                CtBFTable ctBFTable = new CtBFTable(sTenantCode, sAccountId, sEntityKey);
                Object ctBillIdLinks = null;
                if (ctBFTableCtAddLinkArgsMap.containsKey(ctBFTable)) {
                    CtBillIdLink ctBillIdLink = new CtBillIdLink(sBillId, tBillId);
                    List ctBillIdLinkList = (List)ctBFTableCtAddLinkArgsMap.get(ctBFTable);
                    if (ctBillIdLinkList.contains(ctBillIdLink)) continue;
                    ctBillIdLinkList.add(ctBillIdLink);
                    continue;
                }
                ArrayList<CtBillIdLink> ctBillIdLinkList = new ArrayList<CtBillIdLink>(16);
                CtBillIdLink ctBillIdLink = new CtBillIdLink(sBillId, tBillId);
                ctBillIdLinkList.add(ctBillIdLink);
                ctBFTableCtAddLinkArgsMap.put(ctBFTable, ctBillIdLinkList);
            }
        }
        if (MapUtils.isEmpty(ctBFTableCtAddLinkArgsMap)) {
            return;
        }
        for (Map.Entry ctBFTableListEntry : ctBFTableCtAddLinkArgsMap.entrySet()) {
            CtBFTable ctBFTable = (CtBFTable)ctBFTableListEntry.getKey();
            List ctBillIdLinkList = (List)ctBFTableListEntry.getValue();
            int batchSize = 5000;
            List batchList = ListUtils.partition((List)ctBillIdLinkList, (int)batchSize);
            for (List ctBillIdLinks : batchList) {
                CtSyncRouteArgs ctSyncRouteArgs = this.buildSyncRouteArgs(entityKey, ctBFTable, ctBillIdLinks);
                try {
                    CtBotpRouteManage.addAllRoute((CtSyncRouteArgs)ctSyncRouteArgs);
                    this.addUpTenantSyncRoute(ctSyncRouteArgs);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    private CtSyncRouteArgs buildSyncRouteArgs(String tEntityKey, CtBFTable ctBFTable, List<CtBillIdLink> ctBillIdLinks) {
        CtSyncRouteArgs ctSyncRouteArg = new CtSyncRouteArgs();
        ctSyncRouteArg.setStenantCode(ctBFTable.getTenantId());
        ctSyncRouteArg.setsAccountId(ctBFTable.getAccountId());
        ctSyncRouteArg.setsEntityKey(ctBFTable.getMainEntityKey());
        ctSyncRouteArg.setTtenantCode(RequestContext.get().getTenantId());
        ctSyncRouteArg.settAccountId(RequestContext.get().getAccountId());
        ctSyncRouteArg.settEntityKey(tEntityKey);
        ctSyncRouteArg.setBillIdLinks(ctBillIdLinks);
        return ctSyncRouteArg;
    }

    public void addUpTenantSyncRoute(CtSyncRouteArgs ctSyncRouteArgs) {
        String result = CtBotpApiUtils.post((String)ctSyncRouteArgs.getStenantCode(), (String)ctSyncRouteArgs.getsAccountId(), (CtApiUrlEnum)CtApiUrlEnum.ADDSYNCROUTE, (String)SerializationUtils.toJsonString((Object)ctSyncRouteArgs));
    }
}

