/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ctbotp.CtDataBaseDataValue;
import kd.bos.entity.ctbotp.constants.CtBillPropEnum;
import kd.bos.entity.property.LongProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CtBaseDataHelper {
    public static List<CtDataBaseDataValue> getBaseDataInfosByNumber(BasedataEntityType bdType, String propName, Object filterList) {
        String bdName = bdType.getName();
        String numberProperty = bdType.getNumberProperty();
        QFilter[] filter = new QFilter[]{new QFilter(propName, "in", filterList)};
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)bdName, (String)numberProperty, (QFilter[])filter);
        ArrayList<CtDataBaseDataValue> ctDataBaseDataValues = new ArrayList<CtDataBaseDataValue>(16);
        for (Map.Entry entry : dynamicObjectMap.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            CtDataBaseDataValue ctDataBaseDataValue = new CtDataBaseDataValue();
            Object num = dynamicObject.get(numberProperty);
            ctDataBaseDataValue.setId(String.valueOf(entry.getKey()));
            ctDataBaseDataValue.setNumber(String.valueOf(num));
            if (bdType.getMasteridType() != 0 && StringUtils.isNotEmpty((CharSequence)bdType.getMasteridPropName()) && dynamicObject.get(bdType.getMasteridPropName()) != null) {
                ctDataBaseDataValue.setMasterId(String.valueOf(dynamicObject.get(bdType.getMasteridPropName())));
            }
            ctDataBaseDataValues.add(ctDataBaseDataValue);
        }
        return ctDataBaseDataValues;
    }

    public static HashMap<String, String> getBaseDataSet(CtBillPropEnum ctBillPropEnum, BasedataEntityType bdType, String propName, Set<String> filterList) {
        HashMap<String, String> idNumber = new HashMap<String, String>(8);
        QFilter[] filter = new QFilter[1];
        if (ctBillPropEnum.name().equals(CtBillPropEnum.ID.name())) {
            if (bdType.getPrimaryKey() instanceof LongProp) {
                List ids = filterList.stream().map(Long::parseLong).collect(Collectors.toList());
                filter[0] = new QFilter(propName, "in", ids);
            } else {
                filter[0] = new QFilter(propName, "in", filterList);
            }
        }
        String bdName = bdType.getName();
        String numberProperty = bdType.getNumberProperty();
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)bdName, (String)numberProperty, (QFilter[])filter);
        for (Map.Entry entry : dynamicObjectMap.entrySet()) {
            if (StringUtils.isBlank(entry.getKey())) continue;
            idNumber.put(String.valueOf(entry.getKey()), String.valueOf(((DynamicObject)entry.getValue()).get(numberProperty)));
        }
        return idNumber;
    }

    public static HashMap<String, String> getBaseDataMasterId(BasedataEntityType bdType, Set<String> filterList) {
        HashMap<String, String> masterIdidNumber = new HashMap<String, String>(8);
        QFilter[] filter = new QFilter[1];
        String masterIdProp = bdType.getMasteridPropName();
        if (StringUtils.isEmpty((CharSequence)masterIdProp)) {
            return null;
        }
        if (bdType.getPrimaryKey() instanceof LongProp) {
            List ids = filterList.stream().map(Long::parseLong).collect(Collectors.toList());
            filter[0] = new QFilter(bdType.getPrimaryKey().getName(), "in", ids);
        } else {
            filter[0] = new QFilter(bdType.getPrimaryKey().getName(), "in", filterList);
        }
        String bdName = bdType.getName();
        String masteridPropName = bdType.getMasteridPropName();
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)bdName, (String)masteridPropName, (QFilter[])filter);
        for (Map.Entry entry : dynamicObjectMap.entrySet()) {
            if (StringUtils.isBlank(entry.getKey())) continue;
            masterIdidNumber.put(String.valueOf(((DynamicObject)entry.getValue()).get(masteridPropName)), String.valueOf(((DynamicObject)entry.getValue()).get(bdType.getNumberProperty())));
        }
        return masterIdidNumber;
    }
}

