/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CtBillTypeService {
    private static final String BOS_MSERVICE_CTBOTP = "bos-mservice-ctbotp";
    private static final String ENABLE = "enable";

    public boolean existBillTypeField(String entityNumber) {
        MainEntityType mainType = null;
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        }
        if (mainType == null) {
            return false;
        }
        for (IDataEntityProperty property : mainType.getProperties()) {
            if (!(property instanceof BillTypeProp)) continue;
            return true;
        }
        return false;
    }

    public Map<String, String> loadBillTypeObjs(String entityNumber) {
        LinkedHashMap<String, String> items = new LinkedHashMap<String, String>(16);
        QFilter[] filters = new QFilter[]{new QFilter("billformid", "=", (Object)entityNumber)};
        Map billTypeObjs = BusinessDataServiceHelper.loadFromCache((String)"bos_billtype", (String)"id, number, name, status, enable, isdefault", (QFilter[])filters);
        for (DynamicObject obj : billTypeObjs.values()) {
            String enable = obj.getString(ENABLE);
            String id = String.valueOf(obj.getPkValue());
            String name = obj.get("name").toString();
            if (!StringUtils.equals((CharSequence)"1", (CharSequence)enable)) {
                name = String.format(ResManager.loadKDString((String)"%s(\u5df2\u7981\u7528)", (String)"CtBillTypeProp_1", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]), name);
            }
            items.put(id, name);
        }
        return items;
    }
}

