/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.UserProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.service.ctbotp.CtBillTreeBuildParameter;
import kd.bos.service.ctbotp.utils.BasedataPropUtil;

public class CtEntityParseHelper {
    private static HashSet<Class<?>> invalidAutoBatchFldTypes = new HashSet();
    private static final String ENTITY_PARSE_HELPER_0 = "CtEntityParseHelper_0";
    private static final String BOS_MSERVICE_CTBOTP = "bos-mservice-ctbotp";

    public static Map<String, IDataEntityProperty> findPropertys(EntityType mainType, String fullPropName) {
        LinkedHashMap<String, IDataEntityProperty> props = new LinkedHashMap<String, IDataEntityProperty>();
        if (mainType.getName().equalsIgnoreCase(fullPropName) || "billhead".equalsIgnoreCase(fullPropName)) {
            props.put(fullPropName, (IDataEntityProperty)mainType.getPrimaryKey());
            return props;
        }
        Object prop = null;
        String[] keys = fullPropName.split("\\.");
        ArrayList<String> unknowKeys = new ArrayList<String>(10);
        for (int i = 0; i < keys.length; ++i) {
            unknowKeys.add(keys[i]);
        }
        String key1 = keys[0];
        int nextKeyIndex = 1;
        if (keys.length == 1) {
            prop = mainType.findProperty(key1);
            if (prop != null) {
                props.put(key1, (IDataEntityProperty)prop);
            } else {
                props.put(key1, null);
            }
            unknowKeys.clear();
        } else if (keys.length > 1) {
            prop = mainType.findProperty(key1);
            if (prop == null) {
                props.put(fullPropName, null);
                unknowKeys.clear();
            } else {
                MainEntityType baseEntityType2;
                BasedataProp bdProp2;
                String key3;
                props.put(key1, (IDataEntityProperty)prop);
                unknowKeys.remove(0);
                String key2 = keys[nextKeyIndex];
                if (prop instanceof EntryProp) {
                    prop = mainType.findProperty(key2);
                    if (prop == null) {
                        prop = mainType.findProperty(key1 + "." + key2);
                    }
                    ++nextKeyIndex;
                    if (prop != null) {
                        props.put(key2, (IDataEntityProperty)prop);
                        unknowKeys.remove(0);
                    }
                }
                if (prop instanceof BasedataProp && keys.length > nextKeyIndex) {
                    key2 = keys[nextKeyIndex];
                    ++nextKeyIndex;
                    BasedataProp bdProp1 = (BasedataProp)prop;
                    MainEntityType baseEntityType1 = (MainEntityType)bdProp1.getComplexType();
                    if ((prop = baseEntityType1.getPrimaryKey().getName().equals(key2) ? baseEntityType1.getPrimaryKey() : baseEntityType1.findProperty(key2)) != null) {
                        props.put(key2, (IDataEntityProperty)prop);
                        unknowKeys.remove(0);
                    }
                    if (prop instanceof BasedataProp && keys.length > nextKeyIndex) {
                        key3 = keys[nextKeyIndex];
                        ++nextKeyIndex;
                        bdProp2 = (BasedataProp)prop;
                        baseEntityType2 = (MainEntityType)bdProp2.getComplexType();
                        if ((prop = baseEntityType2.getPrimaryKey().getName().equals(key3) ? baseEntityType2.getPrimaryKey() : baseEntityType2.findProperty(key3)) != null) {
                            props.put(key3, (IDataEntityProperty)prop);
                            unknowKeys.remove(0);
                        }
                    }
                }
                if (prop instanceof MulBasedataProp && keys.length > nextKeyIndex) {
                    key2 = keys[nextKeyIndex];
                    ++nextKeyIndex;
                    DynamicObjectType subEntityType = ((MulBasedataProp)prop).getDynamicCollectionItemPropertyType();
                    BasedataProp basedataProp = (BasedataProp)subEntityType.getProperties().get((Object)"fbasedataid");
                    if (basedataProp.getName().equals(key2)) {
                        unknowKeys.remove(0);
                    }
                    if (basedataProp instanceof BasedataProp && keys.length > nextKeyIndex) {
                        key3 = keys[nextKeyIndex];
                        ++nextKeyIndex;
                        bdProp2 = basedataProp;
                        baseEntityType2 = (MainEntityType)bdProp2.getComplexType();
                        prop = baseEntityType2.getPrimaryKey().getName().equals(key3) ? baseEntityType2.getPrimaryKey() : baseEntityType2.findProperty(key3);
                        if (prop != null) {
                            props.put(key3, (IDataEntityProperty)prop);
                            unknowKeys.remove(0);
                        }
                    }
                }
            }
        }
        if (unknowKeys.size() > 0) {
            props.put(StringUtils.join(unknowKeys, (String)"."), null);
        }
        return props;
    }

    public static String buildPropFullCaption(EntityType mainType, String fullPropName, String localId) {
        ArrayList<String> captions = new ArrayList<String>();
        Map<String, IDataEntityProperty> props = CtEntityParseHelper.findPropertys(mainType, fullPropName);
        IDataEntityProperty firstProp = props.entrySet().iterator().next().getValue();
        if (firstProp != null) {
            IDataEntityType parentType = null;
            parentType = firstProp instanceof EntryProp ? ((EntryProp)firstProp).getItemType() : firstProp.getParent();
            if (parentType instanceof MainEntityType) {
                String headName = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)ENTITY_PARSE_HELPER_0, (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]);
                captions.add(headName);
            } else if (parentType instanceof EntityType) {
                LocaleString displayCaption = ((EntityType)parentType).getDisplayName();
                captions.add(displayCaption == null ? "" : (String)displayCaption.getItem(localId));
            }
        }
        for (Map.Entry<String, IDataEntityProperty> item : props.entrySet()) {
            if (item.getValue() == null) {
                captions.add(item.getKey());
                continue;
            }
            IDataEntityProperty property = item.getValue();
            if (property instanceof DynamicProperty) {
                LocaleString displayCaption = ((DynamicProperty)property).getDisplayName();
                captions.add(displayCaption == null ? item.getKey() : (String)displayCaption.getItem(localId));
                continue;
            }
            if (property instanceof DynamicProperty || property instanceof EntryProp) continue;
            captions.add(item.getKey());
        }
        return StringUtils.join((Object[])captions.toArray(), (String)".");
    }

    public static String buildPropFullCaption(IDataEntityProperty property) {
        LocaleString displayCaption;
        ArrayList<String> captions = new ArrayList<String>();
        IDataEntityType parentType = property.getParent();
        if (parentType instanceof MainEntityType) {
            captions.add(ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)ENTITY_PARSE_HELPER_0, (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
        } else if (parentType instanceof EntityType) {
            displayCaption = ((EntityType)parentType).getDisplayName();
            captions.add(displayCaption == null ? "" : displayCaption.toString());
        }
        if (property instanceof DynamicProperty) {
            displayCaption = ((DynamicProperty)property).getDisplayName();
            captions.add(displayCaption == null ? property.getName() : displayCaption.toString());
        } else {
            captions.add(property.getName());
        }
        return StringUtils.join((Object[])captions.toArray(), (String)".");
    }

    public static String buildPropEntityKeys(IDataEntityProperty property) {
        LinkedList<String> keys = new LinkedList<String>();
        IDataEntityType parentType = property.getParent();
        while (!(parentType instanceof MainEntityType)) {
            keys.add(parentType.getName());
            parentType = parentType.getParent();
        }
        keys.add("billhead");
        Collections.reverse(keys);
        return StringUtils.join((Object[])keys.toArray(), (String)"|");
    }

    public static TreeNode buildBillTreeNodes(CtBillTreeBuildParameter parameter) {
        MainEntityType mainType = parameter.getMainType();
        TreeNode billNode = new TreeNode("", mainType.getName(), mainType.getDisplayName().toString());
        billNode.setIsOpened(true);
        List<TreeNode> fldNodes = CtEntityParseHelper.buildFldTreeNodes(parameter);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (TreeNode node : fldNodes) {
            nodeMap.put(node.getId(), node);
        }
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return billNode;
    }

    public static List<TreeNode> buildFldTreeNodes(CtBillTreeBuildParameter parameter) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        MainEntityType mainType = parameter.getMainType();
        HashSet<String> selectedEntity = new HashSet<String>();
        selectedEntity.addAll(parameter.getSelectedEntity());
        if (selectedEntity.size() == 0) {
            selectedEntity = new HashSet();
            for (String entityKey : mainType.getAllEntities().keySet()) {
                selectedEntity.add(entityKey);
            }
        }
        for (Map.Entry entry : mainType.getAllEntities().entrySet()) {
            EntityType entityType;
            if (!selectedEntity.contains(entry.getKey()) || (entityType = (EntityType)entry.getValue()) instanceof LinkEntryType || entityType instanceof TreeEntryType) continue;
            String entityNodeId = entityType.getName();
            String entityNodeName = "";
            if (entityType instanceof MainEntityType) {
                entityNodeName = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)ENTITY_PARSE_HELPER_0, (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]);
                entityNodeId = "billhead";
            } else if (entityType.getDisplayName() != null) {
                entityNodeName = entityType.getDisplayName().toString();
            }
            TreeNode entityNode = new TreeNode(mainType.getName(), entityNodeId, entityNodeName);
            entityNode.setIsOpened(true);
            ArrayList<TreeNode> entityFldNodes = new ArrayList<TreeNode>();
            if (parameter.isIncludePKField()) {
                CtEntityParseHelper.buildPKFldTreeNode(entityType, entityNode, entityFldNodes, parameter);
            }
            for (IDataEntityProperty property : entityType.getFields().values()) {
                boolean matched = false;
                if (parameter.isOnlyPhysicsField() && StringUtils.isBlank((CharSequence)property.getAlias()) || "id".equalsIgnoreCase(property.getName()) || "seq".equalsIgnoreCase(property.getName()) || parameter.isFormDisVisitField(property)) continue;
                TreeNode fldNode = CtEntityParseHelper.BuildFldTreeNode(property, parameter.getMatchedProperty(), parameter.getMatchedClassType(), parameter.getForbidClassTypes(), entityNode, "", parameter.isDynamicText(), parameter.getEntityNumbers());
                if (fldNode != null) {
                    entityFldNodes.add(fldNode);
                    matched = true;
                }
                CtEntityParseHelper.addBaseDataAndMulBaseData(fldNode, property, entityNode, parameter, entityFldNodes, matched);
            }
            if (entityFldNodes.size() <= 0) continue;
            nodes.add(entityNode);
            nodes.addAll(entityFldNodes);
        }
        return nodes;
    }

    private static void addBaseDataAndMulBaseData(TreeNode fldNode, IDataEntityProperty property, TreeNode entityNode, CtBillTreeBuildParameter parameter, List<TreeNode> entityFldNodes, boolean matched) {
        if (!(property instanceof BasedataProp) && !(property instanceof MulBasedataProp)) {
            return;
        }
        if (fldNode == null) {
            fldNode = CtEntityParseHelper.BuildFldTreeNode(property, null, null, parameter.getForbidClassTypes(), entityNode, "", parameter.isDynamicText(), parameter.getEntityNumbers());
        }
        if (fldNode == null) {
            return;
        }
        List<Object> refNodes = new ArrayList(10);
        refNodes = property instanceof BasedataProp ? CtEntityParseHelper.getBaseDataNodes(fldNode, property, parameter) : CtEntityParseHelper.getMulBaseDataNodes(fldNode, property, parameter);
        if (refNodes.size() > 0) {
            entityFldNodes.addAll(refNodes);
            if (!matched) {
                entityFldNodes.add(fldNode);
            }
        }
    }

    private static List<TreeNode> getMulBaseDataNodes(TreeNode fldNode, IDataEntityProperty property, CtBillTreeBuildParameter parameter) {
        if (parameter.getForbidRefPropFieldTypes().contains(property.getClass())) {
            return new ArrayList<TreeNode>(0);
        }
        MulBasedataProp mulBdProp = (MulBasedataProp)property;
        BasedataEntityType mulBdType = (BasedataEntityType)mulBdProp.getComplexType();
        IDataEntityProperty number = (IDataEntityProperty)mulBdType.getProperties().get((Object)mulBdType.getNumberProperty());
        ArrayList<IDataEntityProperty> properties = new ArrayList<IDataEntityProperty>(1);
        properties.add(number);
        List<TreeNode> refNodes = CtEntityParseHelper.buildNodes(parameter.getMatchedProperty(), parameter.getMatchedClassType(), parameter.getForbidClassTypes(), properties, fldNode, property.getName() + ".fbasedataid", parameter.isDynamicText(), parameter.getEntityNumbers());
        return refNodes;
    }

    private static List<TreeNode> getBaseDataNodes(TreeNode fldNode, IDataEntityProperty property, CtBillTreeBuildParameter parameter) {
        BasedataProp bdProp = (BasedataProp)property;
        MainEntityType bdType = (MainEntityType)bdProp.getComplexType();
        List<TreeNode> refNodes = CtEntityParseHelper.buildBDFldRefPropNodes(bdType, parameter.getMatchedProperty(), parameter.getMatchedClassType(), parameter.getForbidClassTypes(), fldNode, property.getName(), parameter.isDynamicText(), parameter.getEntityNumbers());
        return refNodes;
    }

    public static boolean isSupportConvField(IDataEntityProperty property) {
        return !(property.getParent() instanceof LinkEntryType);
    }

    public static boolean isSupportAutoBatch(MainEntityType mainType, IDataEntityProperty property) {
        if (CtEntityParseHelper.isAssignableFrom(invalidAutoBatchFldTypes, property.getClass())) {
            return false;
        }
        if (mainType instanceof BillEntityType) {
            String billNo = ((BillEntityType)mainType).getBillNo();
            if (property.getName().equalsIgnoreCase(billNo)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isAssignableFrom(Collection<Class<?>> clsSet, Class<?> cls) {
        if (clsSet == null || clsSet.isEmpty()) {
            return false;
        }
        for (Class<?> item : clsSet) {
            if (!item.equals(cls) && !item.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    private static List<TreeNode> buildBDFldRefPropNodes(MainEntityType bdType, IDataEntityProperty matchedProperty, Class<?> matchedClassType, Set<Class<?>> forbidClassTypes, TreeNode bdFldNode, String prefix, boolean isDynamicText, Set<String> entityNumbers) {
        ArrayList<TreeNode> refNodes = new ArrayList<TreeNode>();
        if (bdType == null) {
            return refNodes;
        }
        for (IDataEntityProperty property : bdType.getFields().values()) {
            String prefix2;
            BasedataProp bdProp2;
            MainEntityType bdType2;
            List<TreeNode> refNodes2;
            if (property instanceof EntryProp) continue;
            TreeNode fldNode = CtEntityParseHelper.BuildFldTreeNode(property, matchedProperty, matchedClassType, forbidClassTypes, bdFldNode, prefix, isDynamicText, entityNumbers);
            boolean matched = false;
            if (fldNode != null) {
                refNodes.add(fldNode);
                matched = true;
            }
            if (!(property instanceof BasedataProp)) continue;
            if (fldNode == null) {
                fldNode = CtEntityParseHelper.BuildFldTreeNode(property, null, null, forbidClassTypes, bdFldNode, prefix, isDynamicText, entityNumbers);
            }
            if ((refNodes2 = CtEntityParseHelper.buildBDFldRefPropNodes(bdType2 = (MainEntityType)(bdProp2 = (BasedataProp)property).getComplexType(), matchedProperty, matchedClassType, forbidClassTypes, fldNode, prefix2 = prefix + "." + property.getName(), isDynamicText, entityNumbers)).size() <= 0) continue;
            refNodes.addAll(refNodes2);
            if (matched) continue;
            refNodes.add(fldNode);
        }
        return refNodes;
    }

    private static List<TreeNode> buildNodes(IDataEntityProperty matchedProperty, Class<?> matchedClassType, Set<Class<?>> forbidClassTypes, List<IDataEntityProperty> properties, TreeNode bdFldNode, String prefix, boolean isDynamicText, Set<String> entityNumbers) {
        ArrayList<TreeNode> refNodes = new ArrayList<TreeNode>();
        for (IDataEntityProperty property : properties) {
            TreeNode fldNode = CtEntityParseHelper.BuildFldTreeNode(property, matchedProperty, matchedClassType, forbidClassTypes, bdFldNode, prefix, isDynamicText, entityNumbers);
            if (fldNode == null) continue;
            refNodes.add(fldNode);
        }
        return refNodes;
    }

    private static TreeNode BuildFldTreeNode(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType, Set<Class<?>> forbidClassTypes, TreeNode parentNode, String prefix, boolean isDynamicText, Set<String> entityNumbers) {
        TreeNode fldNode = null;
        boolean isMatch = CtEntityParseHelper.isMatchType(fldProperty, matchedProperty, matchedClassType, forbidClassTypes, entityNumbers);
        DynamicProperty prop = (DynamicProperty)fldProperty;
        if (isMatch && prop != null) {
            String fullPropName;
            String fldNodeId = fullPropName = StringUtils.isBlank((CharSequence)prefix) ? prop.getName() : prefix + "." + prop.getName();
            if (isDynamicText) {
                fldNodeId = "{" + fullPropName + "}";
            }
            String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            fldNode = new TreeNode(parentNode.getId(), fldNodeId, fldNodeName);
            fldNode.setIsOpened(false);
        }
        return fldNode;
    }

    private static void buildPKFldTreeNode(EntityType entityType, TreeNode entityNode, List<TreeNode> entityFldNodes, CtBillTreeBuildParameter parameter) {
        if (entityType instanceof MainEntityType) {
            TreeNode idNode = CtEntityParseHelper.BuildFldTreeNode((IDataEntityProperty)entityType.getPrimaryKey(), parameter.getMatchedProperty(), null, parameter.getForbidClassTypes(), entityNode, "", parameter.isDynamicText(), parameter.getEntityNumbers());
            if (idNode != null) {
                idNode.setText(String.format(ResManager.loadKDString((String)"%s.\u5185\u7801", (String)"CtEntityParseHelper_1", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]), entityType.getDisplayName().toString()));
                entityFldNodes.add(idNode);
            }
        } else {
            TreeNode seqNode;
            DynamicProperty seqProp;
            TreeNode idNode = CtEntityParseHelper.BuildFldTreeNode((IDataEntityProperty)entityType.getPrimaryKey(), parameter.getMatchedProperty(), null, parameter.getForbidClassTypes(), entityNode, entityType.getName(), parameter.isDynamicText(), parameter.getEntityNumbers());
            if (idNode != null) {
                idNode.setText(String.format(ResManager.loadKDString((String)"%s.\u5185\u7801", (String)"CtEntityParseHelper_1", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]), entityType.getDisplayName().toString()));
                entityFldNodes.add(idNode);
            }
            if ((seqProp = entityType.getProperty("seq")) != null && (seqNode = CtEntityParseHelper.BuildFldTreeNode((IDataEntityProperty)seqProp, parameter.getMatchedProperty(), null, parameter.getForbidClassTypes(), entityNode, entityType.getName(), parameter.isDynamicText(), parameter.getEntityNumbers())) != null) {
                seqNode.setText(String.format(ResManager.loadKDString((String)"%s.\u5e8f\u53f7", (String)"CtEntityParseHelper_2", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]), entityType.getDisplayName().toString()));
                entityFldNodes.add(seqNode);
            }
        }
    }

    private static boolean isMatchType(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType, Set<Class<?>> forbidClassTypes, Set<String> entityNumbers) {
        boolean isMatch = true;
        if (matchedClassType != null) {
            if (!matchedClassType.isInstance(fldProperty)) {
                isMatch = false;
            } else if (matchedClassType.getName().contains(".BasedataProp") && !CtEntityParseHelper.isFromSampleMaster(entityNumbers, BasedataPropUtil.parseMasterEntity((BasedataProp)fldProperty))) {
                isMatch = false;
            }
        }
        if (!forbidClassTypes.isEmpty()) {
            for (Class<?> classType : forbidClassTypes) {
                if (!classType.isInstance(fldProperty)) continue;
                isMatch = false;
            }
        }
        if (matchedProperty != null) {
            if (matchedProperty instanceof BasedataProp) {
                if (!((BasedataProp)matchedProperty).isFromSampleMaster(fldProperty)) {
                    isMatch = false;
                }
            } else if (!matchedProperty.getClass().isInstance(fldProperty)) {
                isMatch = false;
            }
        }
        return isMatch;
    }

    private static boolean isFromSampleMaster(Set<String> entityNumbers1, Set<String> entityNumbers2) {
        for (String number : entityNumbers1) {
            if (!entityNumbers2.contains(number)) continue;
            return true;
        }
        return false;
    }

    static {
        invalidAutoBatchFldTypes.add(DateTimeProp.class);
        invalidAutoBatchFldTypes.add(DateProp.class);
        invalidAutoBatchFldTypes.add(UserProp.class);
    }
}

