/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.CtCRCondition;
import kd.bos.entity.ctbotp.apiparam.GetSimpleBaseDataParam;
import kd.bos.entity.ctbotp.apiparam.TenantF7Param;
import kd.bos.entity.ctbotp.dto.SimpleBaseDataDto;
import kd.bos.entity.ctbotp.dto.TenantF7Dto;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.metadata.treebuilder.FilterFieldBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.SimpleBaseData;

public class CtF7ListBuilder {
    private static final String FIELD_NAME = "fieldName";
    private static final String VALUE = "value";

    public List<Map<String, Object>> buildFilterColumns(String entityNumber, String onlyHeadField) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterFieldBuildOption option = new FilterFieldBuildOption();
        boolean isOnlyMainEntityField = !StringUtils.isBlank((CharSequence)onlyHeadField) && Boolean.parseBoolean(onlyHeadField);
        option.setCompatibleProductMode(true);
        if (isOnlyMainEntityField) {
            option.getSelectedEntity().add(entityNumber);
        }
        List cols = FormTreeBuilder.buildFilterColumns((MainEntityType)entityType, (FilterFieldBuildOption)option);
        this.removeInvalidFilterColumns(entityType, cols);
        return cols;
    }

    public String tranFormula(String entityNumber, String conditionStr, String tranExpr) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || StringUtils.isBlank((CharSequence)conditionStr)) {
            return tranExpr;
        }
        CtCRCondition conditionObj = (CtCRCondition)SerializationUtils.fromJsonString((String)conditionStr, CtCRCondition.class);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterCondition filterCondition = conditionObj.getFilterCondition();
        if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
            String[] scripts = new String[]{"", ""};
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            scripts = filterBuilder.buildFilterScript();
            ArrayList<String> descs = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)scripts[1])) {
                descs.add(scripts[1]);
            }
            if (StringUtils.isNotBlank((CharSequence)tranExpr)) {
                descs.add(tranExpr);
            }
            tranExpr = StringUtils.join((Object[])descs.toArray(), (String)ResManager.loadKDString((String)" \u4e14 ", (String)"ConditionEdit_0", (String)"bos-botp-formplugin", (Object[])new Object[0]));
        }
        return tranExpr;
    }

    public TenantF7Dto buildF7Pram(TenantF7Param param) {
        QFilter approvedQFilter;
        QFilter mainOrgFilter;
        TenantF7Dto tenantF7Dto = new TenantF7Dto();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)param.getEntityNumber());
        FilterField filterField = this.getFilterField(param.getFieldName(), mainType);
        String refEntityId = param.getEntityId();
        tenantF7Dto.setRefEntityId(refEntityId);
        IBasedataField basedataProp = (IBasedataField)filterField.getLatestParent();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        IDataEntityType parent = ((IDataEntityProperty)basedataProp).getParent();
        if (EntityTypeUtil.isMainOrgProp((IDataEntityProperty)((IDataEntityProperty)basedataProp)) && parent instanceof BillEntityType && (mainOrgFilter = PermissionFilterUtil.getMainOrgFilter((IBasedataField)basedataProp, (String)parent.getName(), (String)"", null, (String)"", (int)-1, (String)"47150e89000000ac")) != null) {
            qFilters.add(mainOrgFilter);
        }
        int index = 0;
        ArrayList filterValues = new ArrayList(10);
        boolean isSelectedId = false;
        for (Map map : param.getPostData()) {
            String postFieldName = (String)map.get(FIELD_NAME);
            List valueList = (List)map.get(VALUE);
            Object baseDataIds = map.get("baseDataIds");
            if (index == param.getRowIndex() && param.getFieldName().equals(postFieldName)) {
                if (baseDataIds != null && !((List)baseDataIds).isEmpty()) {
                    isSelectedId = true;
                    for (Object object : (List)baseDataIds) {
                        if (object == null || !StringUtils.isNotEmpty((CharSequence)object.toString())) continue;
                        filterValues.add(object);
                    }
                } else {
                    for (Object filterValue : valueList) {
                        if (filterValue == null || !StringUtils.isNotEmpty((CharSequence)filterValue.toString())) continue;
                        filterValues.add(filterValue);
                    }
                }
                break;
            }
            ++index;
        }
        boolean isMulti = filterField.getCompareType(param.getCompareTypeId()).isMulti();
        tenantF7Dto.setMultiSelect(Boolean.valueOf(isMulti));
        if (basedataProp instanceof OrgProp) {
            String orgFuncID = ((OrgProp)basedataProp).getOrgFunc();
            tenantF7Dto.setOrgFuncID(orgFuncID);
        }
        if ((approvedQFilter = PermissionFilterUtil.getApprovedFilter((EntityType)EntityMetadataCache.getDataEntityType((String)param.getEntityId()))) != null) {
            qFilters.add(approvedQFilter);
        }
        tenantF7Dto.setFilterValues(filterValues);
        tenantF7Dto.setSelectedId(Boolean.valueOf(isSelectedId));
        tenantF7Dto.setqFilters(SerializationUtils.toJsonString(qFilters));
        tenantF7Dto.setRefPropKey(filterField.getRefPropKey());
        return tenantF7Dto;
    }

    public SimpleBaseDataDto buildSimpleBaseData(GetSimpleBaseDataParam param) {
        SimpleBaseDataDto dataDto = new SimpleBaseDataDto();
        ListSelectedRowCollection rows = (ListSelectedRowCollection)SerializationUtils.fromJsonString((String)param.getSelectedRows(), ListSelectedRowCollection.class);
        if (rows == null) {
            return null;
        }
        String entityId = param.getActionIds()[0];
        String fieldKey = param.getActionIds()[3];
        String fieldName = param.getActionIds()[4];
        String selfEntityNumber = null;
        if (param.getActionIds().length >= 6) {
            selfEntityNumber = param.getActionIds()[5];
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType(selfEntityNumber);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        SimpleBaseData simpleBaseData = SimpleBaseData.loadSimpleBaseDataWithPkToName((BasedataEntityType)entityType, rows, fieldKey, dataEntityType, fieldName);
        dataDto.setIds(simpleBaseData.getIds());
        dataDto.setValues(simpleBaseData.getValues());
        return dataDto;
    }

    private void removeInvalidFilterColumns(MainEntityType entityType, List<Map<String, Object>> cols) {
        Map fields = entityType.getAllFields();
        Iterator<Map<String, Object>> iterator = cols.iterator();
        while (iterator.hasNext()) {
            String name;
            Map<String, Object> col = iterator.next();
            if (col == null || col.get(FIELD_NAME) == null) {
                iterator.remove();
            }
            if ((name = (String)col.get(FIELD_NAME)).contains(".") && fields.get(name.substring(0, name.indexOf("."))) instanceof PictureProp) {
                iterator.remove();
            }
            if (!name.contains(".") || !(fields.get(name.substring(0, name.indexOf("."))) instanceof MulBasedataProp)) continue;
            iterator.remove();
        }
    }

    private FilterField getFilterField(String fieldName, MainEntityType mainType) {
        FilterField filterField = FilterField.create((MainEntityType)mainType, (String)fieldName);
        return filterField;
    }
}

