/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ctbotp.apiparam.CtMainEntityTypeReq;
import kd.bos.entity.ctbotp.dto.CtAttachmentPanelApDto;
import kd.bos.entity.ctbotp.dto.MainEntityTypeDto;
import kd.bos.entity.ctbotp.dto.TargetFieldInfo;
import kd.bos.form.field.ComboItem;
import kd.bos.service.ctbotp.CtBillTypeService;
import kd.bos.service.ctbotp.GetSourceFieldInfo;
import kd.bos.service.ctbotp.GetTargetFieldInfo;
import kd.bos.service.ctbotp.helper.CtAttachmentConvertHelper;

public class CtGetMainEntityTypeInfo {
    private static final String BOS_MSERVICE_CTBOTP = "bos-mservice-ctbotp";
    private List<ComboItem> comboItems;
    private Map<String, List<ComboItem>> mapSubComboItems;
    private Map<String, String> entityTypes;

    public MainEntityTypeDto getEntityInfo(CtMainEntityTypeReq mainEntityTypeReq) {
        String entityNumber = mainEntityTypeReq.getEntityNumber();
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            if (mainType == null) {
                return null;
            }
            this.getAllEntities(entityNumber, mainType, mainEntityTypeReq.getLocalId());
            MainEntityTypeDto dto = new MainEntityTypeDto();
            this.setBizappId(dto, entityNumber);
            dto.setName(mainType.getName());
            dto.setBizAppNumber(mainType.getBizAppNumber());
            dto.setComboItems(this.comboItems);
            dto.setSubComboItems(this.mapSubComboItems);
            dto.setEntityTypes(this.entityTypes);
            dto.setDisplayName(mainType.getDisplayName().toString());
            CtBillTypeService billTypeService = new CtBillTypeService();
            boolean existBillTypeField = billTypeService.existBillTypeField(entityNumber);
            dto.setExistBillTypeField(existBillTypeField);
            if (existBillTypeField) {
                Map<String, String> billtypes = billTypeService.loadBillTypeObjs(entityNumber);
                dto.setBillTypes(billtypes);
            }
            List<CtAttachmentPanelApDto> attPanelApList = CtAttachmentConvertHelper.getAttachmentPanelApForApi(entityNumber, mainEntityTypeReq.getLocalId());
            dto.setAttachmentPanelApDtos(attPanelApList);
            if (mainEntityTypeReq.getTargetBill().booleanValue()) {
                GetTargetFieldInfo targetFieldInfo = new GetTargetFieldInfo();
                List<TargetFieldInfo> list = targetFieldInfo.getConvertField(entityNumber, mainEntityTypeReq.getMirrorSync());
                dto.setTargetConvertFields(list);
            } else {
                HashMap<String, String> sourceFieldNames = new HashMap<String, String>(16);
                List sourceFieldKeys = mainEntityTypeReq.getSourceFieldKeys();
                for (String sourceFieldKey : sourceFieldKeys) {
                    GetSourceFieldInfo getSourceFieldInfo = new GetSourceFieldInfo();
                    String sourceFieldName = getSourceFieldInfo.getFieldCaption(entityNumber, sourceFieldKey, mainEntityTypeReq.getLocalId());
                    sourceFieldNames.put(sourceFieldKey, sourceFieldName);
                }
                dto.setSourceFieldNames(sourceFieldNames);
            }
            return dto;
        }
        return null;
    }

    public String buildEntityKeys(String entityNumber, String entryEntity) {
        LinkedList<String> keys = new LinkedList<String>();
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            if (mainType == null) {
                return null;
            }
            Map entitys = mainType.getAllEntities();
            for (EntityType entity : entitys.values()) {
                if (!entity.getName().equals(entryEntity)) continue;
                if (entity instanceof MainEntityType) break;
                EntityType parentType = entity;
                while (!(parentType instanceof MainEntityType)) {
                    keys.add(parentType.getName());
                    parentType = parentType.getParent();
                }
                break block0;
            }
        }
        keys.add("billhead");
        Collections.reverse(keys);
        return StringUtils.join((Object[])keys.toArray(), (String)"|");
    }

    private void getAllEntities(String entityNumber, MainEntityType mainType, String localId) {
        this.comboItems = new ArrayList<ComboItem>(16);
        this.entityTypes = new HashMap<String, String>(16);
        this.mapSubComboItems = new HashMap<String, List<ComboItem>>(16);
        Map entitys = mainType.getAllEntities();
        ComboItem headItem = new ComboItem();
        headItem.setId(this.buildEntityKeys(entityNumber, mainType.getName()));
        headItem.setValue(mainType.getName());
        headItem.setCaption(new LocaleString(localId, ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"CtGetMainEntityTypeInfo_1", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0])));
        this.comboItems.add(headItem);
        this.entityTypes.put(mainType.getName(), mainType.getName());
        for (EntityType entity : entitys.values()) {
            if (entity instanceof LinkEntryType) continue;
            if (!this.entityTypes.containsKey(entity.getName())) {
                this.entityTypes.put(entity.getName(), entity.getName());
            }
            if (entity instanceof EntryType) {
                ComboItem entryItem = new ComboItem();
                entryItem.setValue(entity.getName());
                entryItem.setCaption(entity.getDisplayName());
                entryItem.setId(this.buildEntityKeys(entityNumber, entity.getName()));
                this.comboItems.add(entryItem);
            }
            if (!(entity instanceof SubEntryType)) continue;
            IDataEntityType parent = entity.getParent();
            ComboItem entryItem = new ComboItem();
            entryItem.setValue(entity.getName());
            entryItem.setCaption(entity.getDisplayName());
            entryItem.setId(this.buildEntityKeys(entityNumber, entity.getName()));
            if (parent == null || !StringUtils.isNotBlank((CharSequence)parent.getName())) continue;
            if (this.mapSubComboItems.get(entity.getParent().getName()) != null) {
                this.mapSubComboItems.get(parent.getName()).add(entryItem);
                continue;
            }
            ArrayList<ComboItem> subEntryItems = new ArrayList<ComboItem>(10);
            ComboItem blankItem = new ComboItem();
            blankItem.setValue("");
            blankItem.setCaption(new LocaleString());
            subEntryItems.add(blankItem);
            subEntryItems.add(entryItem);
            this.mapSubComboItems.put(parent.getName(), subEntryItems);
        }
    }

    private void setBizappId(final MainEntityTypeDto mainEntityTypeDto, String entityNumber) {
        if (StringUtils.isBlank((CharSequence)mainEntityTypeDto.getBizappId())) {
            String sql = "SELECT FNumber, FSubsysId, FBizAppId FROM t_meta_entitydesign WHERE FNumber = ?";
            Object[] params = new SqlParameter[]{new SqlParameter(":FNumber", 12, (Object)entityNumber)};
            ResultSetHandler<Object> action = new ResultSetHandler<Object>(){

                public Object handle(ResultSet rs) throws Exception {
                    if (rs.next()) {
                        int subSysId = rs.getInt("FSubsysId");
                        String bizAppId = rs.getString("FBizAppId");
                        mainEntityTypeDto.setSubSysId(Integer.valueOf(subSysId));
                        mainEntityTypeDto.setBizappId(bizAppId);
                    }
                    return null;
                }
            };
            DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
        }
    }
}

