/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.dto.TargetFieldInfo;
import kd.bos.entity.ctbotp.dto.TargetFieldPropInfo;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.service.ctbotp.CtBillTreeBuildParameter;
import kd.bos.service.ctbotp.CtEntityParseHelper;
import kd.bos.service.ctbotp.CtFieldSeqComparator;
import kd.bos.service.ctbotp.utils.BasedataPropUtil;

public class GetTargetFieldInfo {
    public List<TargetFieldInfo> getConvertField(String targetNumber, Boolean mirrorSync) {
        MainEntityType targetMainType = null;
        if (StringUtils.isNotBlank((CharSequence)targetNumber)) {
            targetMainType = EntityMetadataCache.getDataEntityType((String)targetNumber);
        }
        if (targetMainType == null) {
            return new ArrayList<TargetFieldInfo>();
        }
        CtBillTreeBuildParameter billTreeBuildParameter = new CtBillTreeBuildParameter(targetMainType);
        ArrayList<IDataEntityProperty> allFields = new ArrayList<IDataEntityProperty>();
        for (EntityType entityType : targetMainType.getAllEntities().values()) {
            for (IDataEntityProperty property : entityType.getFields().values()) {
                if (!mirrorSync.booleanValue() && (!(property instanceof IFieldHandle) || !((IFieldHandle)property).isConvertTote()) || !CtEntityParseHelper.isSupportConvField(property) || billTreeBuildParameter.isFormDisVisitField(property)) continue;
                allFields.add(property);
            }
        }
        allFields.sort(new CtFieldSeqComparator(targetMainType));
        ArrayList<TargetFieldInfo> list = new ArrayList<TargetFieldInfo>(allFields.size());
        for (IDataEntityProperty property : allFields) {
            TargetFieldInfo fieldInfo = new TargetFieldInfo();
            DynamicProperty field = (DynamicProperty)property;
            String targetFieldKey = field.getName();
            String targetFieldName = CtEntityParseHelper.buildPropFullCaption(property);
            String targetentitykeys = CtEntityParseHelper.buildPropEntityKeys(property);
            String propertyClassName = property.getClass().getName();
            fieldInfo.setTargetFieldKey(targetFieldKey);
            fieldInfo.setTargetFieldName(targetFieldName);
            fieldInfo.setTargetEntityKeys(targetentitykeys);
            fieldInfo.setTargetFieldType(propertyClassName);
            if (property instanceof BasedataProp) {
                String number = ((BasedataProp)property).getBaseEntityId();
                fieldInfo.setTargetBaseDataNumber(number);
            }
            list.add(fieldInfo);
        }
        return list;
    }

    public TargetFieldPropInfo findProperty(String targetNumber, String targetField) {
        TargetFieldPropInfo targetFieldPropInfo = new TargetFieldPropInfo();
        MainEntityType targetMainType = null;
        if (StringUtils.isNotBlank((CharSequence)targetNumber)) {
            targetMainType = EntityMetadataCache.getDataEntityType((String)targetNumber);
        }
        if (targetMainType == null) {
            return null;
        }
        IDataEntityProperty targetProperty = targetMainType.findProperty(targetField);
        if (targetProperty == null) {
            return null;
        }
        if (targetProperty instanceof BasedataProp) {
            BasedataProp bdProp = (BasedataProp)targetProperty;
            Set<String> entityNumbers = BasedataPropUtil.parseMasterEntity(bdProp);
            targetFieldPropInfo.setEntityNumbers(entityNumbers);
        }
        targetFieldPropInfo.setTargetProperty(targetProperty.getClass().getName());
        return targetFieldPropInfo;
    }

    public boolean isSupportAutoBatch(String targetNumber, String targetFieldKey) {
        MainEntityType targetMainType = null;
        if (StringUtils.isNotBlank((CharSequence)targetNumber)) {
            targetMainType = EntityMetadataCache.getDataEntityType((String)targetNumber);
        }
        if (targetMainType == null) {
            return false;
        }
        DynamicProperty dynamicProperty = (DynamicProperty)targetMainType.findProperty(targetFieldKey);
        return CtEntityParseHelper.isSupportAutoBatch(targetMainType, (IDataEntityProperty)dynamicProperty);
    }
}

