/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.business.datamodel;

import java.util.HashMap;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LayoutControlInfo;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.DefaultDefValueProvider;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.FieldDefValue;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CtBillDefValueProvider
extends DefaultDefValueProvider {
    private static final Log log = LogFactory.getLog(CtBillDefValueProvider.class);
    private static final String FORMID_BOS_LAYOUTSCHEME = "bos_newpageconfig";
    private static final String KEY_FIELD_CONTROL_ENTRY = "fieldcontrolentry_d";
    Long schemeId;
    Map<String, Object> defValueMap = null;

    public CtBillDefValueProvider(Long schemeId) {
        this.schemeId = schemeId;
    }

    public Object getDefValue(IFieldHandle fieldProp) {
        Object loayoutDefaultValue = this.getLayoutDefaultValue(fieldProp);
        return loayoutDefaultValue != null ? loayoutDefaultValue : super.getDefValue(fieldProp);
    }

    public FieldDefValue getDefValue2(IFieldHandle fieldProp) {
        return this.getLayoutDefaultValue(fieldProp) != null ? null : super.getDefValue2(fieldProp);
    }

    private Object getLayoutDefaultValue(IFieldHandle fieldProp) {
        String key = "";
        Object defaultValue = null;
        if (fieldProp instanceof IDataEntityProperty) {
            key = ((IDataEntityProperty)fieldProp).getName();
        }
        Map<String, Object> defValueMap = this.getDefValueMap();
        if (fieldProp instanceof BooleanProp) {
            Object defValue = defValueMap.get(key);
            if (StringUtils.isNotBlank((Object)defValue) && ("true".equalsIgnoreCase(defValue.toString()) || "false".equalsIgnoreCase(defValue.toString()))) {
                defaultValue = Boolean.parseBoolean(defValue.toString());
            }
        } else if (fieldProp instanceof DynamicProperty && StringUtils.isNotBlank((Object)defValueMap.get(key))) {
            defaultValue = defValueMap.get(key);
        }
        return defaultValue;
    }

    private Map<String, Object> getDefValueMap() {
        if (this.defValueMap == null) {
            this.defValueMap = this.schemeId == null || Long.compare(0L, this.schemeId) == 0 ? new HashMap<String, Object>() : CtBillDefValueProvider.getLayoutDefValue(this.schemeId);
        }
        return this.defValueMap;
    }

    private static Map<String, Object> getLayoutDefValue(Long schemeId) {
        HashMap<String, Object> defValueMap = new HashMap<String, Object>();
        Object[] pkIds = new Long[]{schemeId};
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)FORMID_BOS_LAYOUTSCHEME);
        Map dataFromCache = BusinessDataReader.loadFromCache((Object[])pkIds, (DynamicObjectType)dt);
        DynamicObject billLayoutObj = (DynamicObject)dataFromCache.get(schemeId);
        if (billLayoutObj == null) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u5e03\u5c40\u65b9\u6848\u65e0\u6cd5\u67e5\u51fa\u6570\u636e id:%s", (String)"BillDefValueProvider_0", (String)"bos-mservice-botp", (Object[])new Object[0]), schemeId.toString());
            throw new KDException(new ErrorCode("BillDefValueProvider_01", errMsg), new Object[0]);
        }
        DynamicObjectCollection fldctlentry = billLayoutObj.getDynamicObjectCollection(KEY_FIELD_CONTROL_ENTRY);
        fldctlentry.forEach(fldctlRow -> defValueMap.put(fldctlRow.getString("fieldkey"), fldctlRow.get("defaultvalue")));
        if (LayoutControlInfo.isOutLog()) {
            StackTraceElement[] stackTrace;
            log.error(String.format("BillDefValueProvider.getLayoutDefValue.ctlMap:%s", SerializationUtils.toJsonString(defValueMap)));
            StringBuilder sb = new StringBuilder();
            sb.append("layoutlog - ");
            for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
                String className = stackTraceElement.getClassName();
                String methodName = stackTraceElement.getMethodName();
                sb.append(className).append(",").append(methodName).append(System.lineSeparator());
            }
            log.error(sb.toString());
        }
        return defValueMap;
    }
}

