/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.controller;

import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.apiparam.CtAutoMatchFieldsReq;
import kd.bos.entity.ctbotp.apiparam.CtFieldCaptionReq;
import kd.bos.entity.ctbotp.apiparam.CtMainEntityTypeReq;
import kd.bos.entity.ctbotp.apiparam.TreeNodeParam;
import kd.bos.entity.ctbotp.dto.CtAttachmentPanelApDto;
import kd.bos.entity.ctbotp.dto.DeleteRuleDto;
import kd.bos.entity.ctbotp.dto.DynamicPropertyDto;
import kd.bos.entity.ctbotp.dto.MainEntityTypeDto;
import kd.bos.entity.ctbotp.dto.TargetFieldPropInfo;
import kd.bos.entity.ctbotp.syncdata.SyncRuleRecord;
import kd.bos.entity.ctbotp.syncdata.SyncRuleResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.ctbotp.CtRuleTreeNode;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.service.ctbotp.CtGetMainEntityTypeInfo;
import kd.bos.service.ctbotp.GetSourceFieldInfo;
import kd.bos.service.ctbotp.GetTargetFieldInfo;
import kd.bos.service.ctbotp.SyncCtConvertRule;
import kd.bos.service.ctbotp.helper.CtAttachmentConvertHelper;
import kd.bos.servicehelper.CtConvertMetaServiceHelper;

@ApiController(value="bos", desc="\u8de8\u79df\u6237BOTP")
@ApiMapping(value="/ctbotp")
public class CtBotpController {
    private static final String BOS_MSERVICE_CTBOTP = "bos-mservice-ctbotp";
    private Log log = LogFactory.getLog(CtBotpController.class);
    private CtGetMainEntityTypeInfo getMainEntityTypeInfo = new CtGetMainEntityTypeInfo();
    private GetSourceFieldInfo getSourceFieldInfo = new GetSourceFieldInfo();
    private GetTargetFieldInfo getTargetFieldInfo = new GetTargetFieldInfo();
    private SyncCtConvertRule syncCtConvertRule = new SyncCtConvertRule();

    @ApiPostMapping(value="/getMainEntityInfo", desc="\u83b7\u53d6\u4e3b\u5b9e\u4f53\u4fe1\u606f")
    public CustomApiResult<@ApiResponseBody(value="MainEntityTypeDto") MainEntityTypeDto> getMainEntityInfo(@Valid @ApiRequestBody(value="\u83b7\u53d6\u4e3b\u5b9e\u4f53\u4fe1\u606f\u53c2\u6570\u5bf9\u8c61", required=true) CtMainEntityTypeReq mainEntityTypeReq) {
        this.log.info("mainEntityTypeReq:" + SerializationUtils.toJsonString((Object)mainEntityTypeReq));
        MainEntityTypeDto dto = this.getMainEntityTypeInfo.getEntityInfo(mainEntityTypeReq);
        if (dto != null) {
            return CustomApiResult.success((Object)dto);
        }
        return CustomApiResult.fail((String)"1000", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u4e3b\u5b9e\u4f53\u4fe1\u606f\u5931\u8d25\u3002", (String)"CtBotpController_0", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
    }

    @ApiGetMapping(value="/buildEntityKeys", desc="\u6784\u5efa\u5b9e\u4f53\u4fe1\u606f")
    public CustomApiResult<String> buildEntityKeys(@NotNull @ApiParam(value="\u5355\u636e\u6807\u8bc6", required=true) @NotNull @ApiParam(value="\u5355\u636e\u6807\u8bc6", required=true) String entityNumber, @NotNull @ApiParam(value="\u5355\u636e\u4f53\u540d", required=true) @NotNull @ApiParam(value="\u5355\u636e\u4f53\u540d", required=true) String entryEntity) {
        this.log.info("entityNumber:" + entityNumber);
        this.log.info("entryEntity:" + entryEntity);
        String keys = this.getMainEntityTypeInfo.buildEntityKeys(entityNumber, entryEntity);
        if (StringUtils.isNotBlank((CharSequence)keys)) {
            return CustomApiResult.success((Object)keys);
        }
        return CustomApiResult.fail((String)"1001", (String)ResManager.loadKDString((String)"\u6784\u5efa\u5b9e\u4f53\u4fe1\u606f\u5931\u8d25\u3002", (String)"CtBotpController_1", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
    }

    @ApiPostMapping(value="/getAutoMatchFields", desc="\u83b7\u53d6\u81ea\u52a8\u5339\u914d\u5b57\u6bb5\u5c5e\u6027")
    public CustomApiResult<@ApiResponseBody Map<String, DynamicPropertyDto>> getAutoMatchFields(@Valid @ApiRequestBody(value="\u83b7\u53d6\u81ea\u52a8\u5339\u914d\u5b57\u6bb5\u5c5e\u6027\u5165\u53c2", required=true) CtAutoMatchFieldsReq autoMatchFieldsReq) {
        this.log.info("autoMatchFieldsReq:{}", (Object)SerializationUtils.toJsonString((Object)autoMatchFieldsReq));
        Map<String, DynamicPropertyDto> result = this.getSourceFieldInfo.getAutoMatchFields(autoMatchFieldsReq);
        if (result != null) {
            return CustomApiResult.success(result);
        }
        return CustomApiResult.fail((String)"1002", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u81ea\u52a8\u5339\u914d\u5b57\u6bb5\u5c5e\u6027\u5931\u8d25\u3002", (String)"CtBotpController_2", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
    }

    @ApiPostMapping(value="/getSourceTreeNode", desc="\u83b7\u53d6\u6e90\u5355\u5b57\u6bb5\u8282\u70b9")
    public CustomApiResult<TreeNode> getSourceTreeNode(@Valid @ApiRequestBody(value="\u6e90\u5355\u5b57\u6bb5\u8282\u70b9\u53c2\u6570\u4fe1\u606f", required=true) TreeNodeParam treeNodeParam) {
        this.log.info("treeNodeParam:" + SerializationUtils.toJsonString((Object)treeNodeParam));
        TreeNode node = this.getSourceFieldInfo.getSourceTreeNode(treeNodeParam);
        if (node != null) {
            return CustomApiResult.success((Object)node);
        }
        return CustomApiResult.fail((String)"1003", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u6e90\u5355\u5b57\u6bb5\u8282\u70b9\u5931\u8d25\u3002", (String)"CtBotpController_3", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
    }

    @ApiGetMapping(value="/getBillTreeNode", desc="\u83b7\u53d6\u5355\u636e\u8282\u70b9")
    public CustomApiResult<TreeNode> getBillTreeNode(@NotNull @ApiParam(value="\u5355\u636e\u6807\u8bc6", required=true) @NotNull @ApiParam(value="\u5355\u636e\u6807\u8bc6", required=true) String entityNumber, @NotNull @ApiParam(value="\u5355\u636e\u4f53\u540d", required=false) @NotNull @ApiParam(value="\u5355\u636e\u4f53\u540d", required=false) String selectEntitys) {
        this.log.info("entityNumber:" + entityNumber);
        TreeNode treeNode = this.getSourceFieldInfo.getSourceBillTreeNode(entityNumber, selectEntitys);
        if (treeNode != null) {
            return CustomApiResult.success((Object)treeNode);
        }
        return CustomApiResult.fail((String)"1004", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u4e3b\u5b9e\u4f53\u4fe1\u606f\u5931\u8d25\u3002", (String)"CtBotpController_4", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
    }

    @ApiPostMapping(value="/getFieldCaption", desc="\u83b7\u53d6\u6e90\u5355\u5b57\u6bb5\u63cf\u8ff0")
    public CustomApiResult<String> getFieldCaption(@NotNull @ApiRequestBody(value="\u5355\u636e\u6807\u8bc6", required=true) CtFieldCaptionReq fieldCaptionReq) {
        this.log.info("sourceEntityNumber:" + SerializationUtils.toJsonString((Object)fieldCaptionReq));
        String fieldCaption = this.getSourceFieldInfo.getFieldCaption(fieldCaptionReq.getSourceEntityNumber(), fieldCaptionReq.getFieldPropName(), fieldCaptionReq.getLocalId());
        if (StringUtils.isNotBlank((CharSequence)fieldCaption)) {
            return CustomApiResult.success((Object)fieldCaption);
        }
        return CustomApiResult.fail((String)"1005", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u6e90\u5355\u5b57\u6bb5\u63cf\u8ff0\u5931\u8d25\u3002", (String)"CtBotpController_5", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
    }

    @ApiGetMapping(value="/findProperty", desc="\u67e5\u627e\u76ee\u6807\u5355\u5b57\u6bb5\u5c5e\u6027")
    public CustomApiResult<@ApiResponseBody(value="TargetFieldPropInfo") TargetFieldPropInfo> findProperty(@NotNull @ApiParam(value="\u5355\u636e\u6807\u8bc6", required=true) @NotNull @ApiParam(value="\u5355\u636e\u6807\u8bc6", required=true) String targetNumber, @NotNull @ApiParam(value="\u5355\u636e\u6807\u8bc6", required=true) @NotNull @ApiParam(value="\u5355\u636e\u6807\u8bc6", required=true) String targetField) {
        this.log.info("targetNumber:" + targetNumber);
        this.log.info("targetField:" + targetField);
        TargetFieldPropInfo targetFieldPropInfo = this.getTargetFieldInfo.findProperty(targetNumber, targetField);
        if (StringUtils.isNotBlank((CharSequence)targetFieldPropInfo.getTargetProperty())) {
            return CustomApiResult.success((Object)targetFieldPropInfo);
        }
        return CustomApiResult.fail((String)"1007", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u4e3b\u5b9e\u4f53\u4fe1\u606f\u5931\u8d25\u3002", (String)"CtBotpController_7", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
    }

    @ApiPostMapping(value="/syncRule", desc="\u540c\u6b65\u8f6c\u6362\u89c4\u5219")
    public CustomApiResult<@ApiResponseBody(value="SyncRuleResult") SyncRuleResult> syncRule(@Valid @ApiRequestBody(value="\u6e90\u5355\u5b57\u6bb5\u8282\u70b9\u53c2\u6570\u4fe1\u606f", required=true) CtRuleTreeNode ctRuleTreeNode) {
        this.log.info("param:" + SerializationUtils.toJsonString((Object)ctRuleTreeNode));
        SyncRuleResult result = this.syncCtConvertRule.syncRule(ctRuleTreeNode);
        if (result != null) {
            return CustomApiResult.success((Object)result);
        }
        return CustomApiResult.fail((String)"1009", (String)ResManager.loadKDString((String)"\u540c\u6b65\u8f6c\u6362\u89c4\u5219\u5931\u8d25\u3002", (String)"CtBotpController_9", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
    }

    @ApiPostMapping(value="/deleteRules", desc="\u5220\u9664\u8de8\u79df\u6237\u8f6c\u6362\u89c4\u5219")
    public CustomApiResult<Boolean> deleteRules(@Valid @ApiRequestBody(value="\u5220\u9664\u8de8\u79df\u6237\u8f6c\u6362\u89c4\u5219", required=true) DeleteRuleDto deleteRuleDto) {
        this.log.info("ruleIds:" + SerializationUtils.toJsonString((Object)deleteRuleDto.getDelRuleIds()));
        try {
            CtConvertMetaServiceHelper.delete((String[])deleteRuleDto.getDelRuleIds().toArray(new String[0]));
            return CustomApiResult.success((Object)true);
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return CustomApiResult.fail((String)"1012", (String)ResManager.loadKDString((String)"\u5220\u9664\u8f6c\u6362\u89c4\u5219\u5931\u8d25\u3002", (String)"CtBotpController_12", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
        }
    }

    @ApiGetMapping(value="/getAttPanelApList", desc="\u83b7\u53d6\u9644\u4ef6\u9762\u677f\u63a7\u4ef6\u96c6\u5408")
    public CustomApiResult<List<CtAttachmentPanelApDto>> getAttPanelApList(@NotNull @ApiParam(value="\u5b9e\u4f53\u6807\u8bc6", required=true) @NotNull @ApiParam(value="\u5b9e\u4f53\u6807\u8bc6", required=true) String entityNumber, @NotNull @ApiParam(value="\u8bed\u8a00", required=true) @NotNull @ApiParam(value="\u8bed\u8a00", required=true) String localId) {
        this.log.info("getAttPanelApList entityNumber:" + entityNumber);
        try {
            List<CtAttachmentPanelApDto> attPanelApList = CtAttachmentConvertHelper.getAttachmentPanelApForApi(entityNumber, localId);
            return CustomApiResult.success(attPanelApList);
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            return CustomApiResult.fail((String)"1013", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u9644\u4ef6\u9762\u677f\u63a7\u4ef6\u96c6\u5408\u5931\u8d25\u3002", (String)"CtBotpController_13", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
        }
    }

    @ApiGetMapping(value="/getSyncRec", desc="\u83b7\u53d6\u540c\u6b65\u8bb0\u5f55")
    public CustomApiResult<@ApiResponseBody(value="\u540c\u6b65\u8bb0\u5f55") SyncRuleRecord> getSyncRec(@NotNull @ApiParam(value="\u89c4\u5219\u7248\u672cID", required=true) @NotNull @ApiParam(value="\u89c4\u5219\u7248\u672cID", required=true) Long verId) {
        this.log.info("verId:" + verId);
        SyncRuleRecord record = this.syncCtConvertRule.getSyncRec(verId);
        return CustomApiResult.success((Object)record);
    }

    @ApiPostMapping(value="/updateSyncStatus", desc="\u66f4\u65b0\u6e90\u79df\u6237\u540c\u6b65\u8bb0\u5f55\u72b6\u6001")
    public CustomApiResult<Boolean> updateSyncStatus(@NotNull @ApiParam(value="\u89c4\u5219\u7248\u672cID", required=true) @NotNull @ApiParam(value="\u89c4\u5219\u7248\u672cID", required=true) Long verId) {
        this.log.info("verId:" + verId);
        try {
            this.syncCtConvertRule.updateSyncStatus(verId);
        }
        catch (Exception e) {
            return CustomApiResult.fail((String)"1015", (String)ResManager.loadKDString((String)"\u66f4\u65b0\u6e90\u79df\u6237\u540c\u6b65\u8bb0\u5f55\u72b6\u6001\u5931\u8d25\u3002", (String)"CtBotpController_15", (String)BOS_MSERVICE_CTBOTP, (Object[])new Object[0]));
        }
        return CustomApiResult.success((Object)true);
    }
}

